/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.drools.beliefs.bayes.BayesVariable;
import org.drools.beliefs.bayes.JunctionTreeClique;
import org.drools.beliefs.bayes.OpenBitSet;
import org.drools.beliefs.bayes.PotentialMultiplier;
import org.drools.beliefs.bayes.SeparatorState;
import org.drools.beliefs.graph.Graph;

public class JunctionTreeSeparator {
    private int id;
    private OpenBitSet bitSet;
    private List<BayesVariable> values;
    private JunctionTreeClique parent;
    private JunctionTreeClique child;

    public JunctionTreeSeparator(int id, JunctionTreeClique parent, JunctionTreeClique child, OpenBitSet bitSet, Graph<BayesVariable> graph) {
        this.id = id;
        this.bitSet = bitSet;
        this.parent = parent;
        this.child = child;
        child.setParentSeparator(this);
        parent.getChildren().add(this);
        this.values = new ArrayList<BayesVariable>((int)bitSet.cardinality());
        int i = bitSet.nextSetBit(0);
        while (i >= 0) {
            this.values.add(graph.getNode(i).getContent());
            i = bitSet.nextSetBit(i + 1);
        }
    }

    public OpenBitSet getBitSet() {
        return this.bitSet;
    }

    public JunctionTreeClique getParent() {
        return this.parent;
    }

    public JunctionTreeClique getChild() {
        return this.child;
    }

    public int getId() {
        return this.id;
    }

    public SeparatorState createState() {
        int numberOfStates = PotentialMultiplier.createNumberOfStates(this.values);
        double[] potentials = new double[numberOfStates];
        Arrays.fill(potentials, 1.0);
        return new SeparatorState(this, potentials);
    }

    public void resetState(SeparatorState sepSet) {
        Arrays.fill(sepSet.getPotentials(), 1.0);
    }

    public List<BayesVariable> getValues() {
        return this.values;
    }

    public String toString() {
        return "JunctionTreeSeparator{id=" + this.id + ", bitSet=" + this.bitSet + ", parent=" + this.parent.getId() + ", child=" + this.child.getId() + '}';
    }
}

