/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes;

import org.drools.beliefs.bayes.BayesBeliefSet;
import org.drools.beliefs.bayes.BayesFact;
import org.drools.beliefs.bayes.BayesHardEvidence;
import org.drools.beliefs.bayes.BayesInstance;
import org.drools.beliefs.bayes.BayesVariable;
import org.drools.beliefs.bayes.PropertyReference;
import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.beliefsystem.BeliefSystem;
import org.drools.core.beliefsystem.ModedAssertion;
import org.drools.core.beliefsystem.simple.SimpleLogicalDependency;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.LogicalDependency;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.spi.Activation;
import org.drools.core.spi.PropagationContext;

public class BayesBeliefSystem<M extends BayesHardEvidence<M>>
implements BeliefSystem<M> {
    private NamedEntryPoint ep;
    private TruthMaintenanceSystem tms;

    public BayesBeliefSystem(NamedEntryPoint ep, TruthMaintenanceSystem tms) {
        this.ep = ep;
        this.tms = tms;
    }

    public void insert(LogicalDependency<M> node, BeliefSet<M> beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        boolean wasEmpty = beliefSet.isEmpty();
        boolean wasUndecided = beliefSet.isUndecided();
        beliefSet.add(node.getMode());
        BayesHardEvidence evidence = (BayesHardEvidence)beliefSet.getFirst();
        PropertyReference propRef = (PropertyReference)node.getObject();
        BayesFact bayesFact = (BayesFact)propRef.getInstance();
        BayesInstance bayesInstance = bayesFact.getBayesInstance();
        InternalFactHandle fh = beliefSet.getFactHandle();
        BayesVariable var = bayesInstance.getFieldNames().get(propRef.getName());
        if (!wasUndecided && beliefSet.isUndecided()) {
            bayesInstance.setDecided(var, false);
            bayesInstance.setLikelyhood(var, null);
        } else {
            bayesInstance.setDecided(var, true);
            bayesInstance.setLikelyhood(var, evidence.getDistribution());
        }
    }

    public void delete(LogicalDependency<M> node, BeliefSet<M> beliefSet, PropagationContext context) {
        boolean wasUndecided = beliefSet.isUndecided();
        beliefSet.remove(node.getMode());
        PropertyReference propRef = (PropertyReference)node.getObject();
        BayesFact bayesFact = (BayesFact)propRef.getInstance();
        BayesInstance bayesInstance = bayesFact.getBayesInstance();
        BayesVariable var = bayesInstance.getFieldNames().get(propRef.getName());
        boolean empty = beliefSet.isEmpty();
        if (empty) {
            bayesInstance.unsetLikelyhood(var);
            return;
        }
        BayesHardEvidence evidence = (BayesHardEvidence)beliefSet.getFirst();
        if (!wasUndecided && beliefSet.isUndecided()) {
            bayesInstance.setDecided(var, false);
            bayesInstance.unsetLikelyhood(var);
        } else if (wasUndecided && !beliefSet.isUndecided()) {
            bayesInstance.setDecided(var, true);
            bayesInstance.setLikelyhood(var, evidence.getDistribution());
        }
    }

    public BeliefSet newBeliefSet(InternalFactHandle fh) {
        return new BayesBeliefSet(fh, this);
    }

    public LogicalDependency<M> newLogicalDependency(Activation<M> activation, BeliefSet<M> beliefSet, Object object, Object value) {
        BayesHardEvidence mode = (BayesHardEvidence)((Object)value);
        SimpleLogicalDependency dep = new SimpleLogicalDependency(activation, beliefSet, object, (ModedAssertion)((BayesHardEvidence)((Object)value)));
        mode.setLogicalDependency(dep);
        return dep;
    }

    public void read(LogicalDependency<M> node, BeliefSet<M> beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
    }

    public TruthMaintenanceSystem getTruthMaintenanceSystem() {
        return null;
    }
}

