/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes.assembler;

import java.util.ArrayList;
import org.drools.beliefs.bayes.BayesNetwork;
import org.drools.beliefs.bayes.JunctionTree;
import org.drools.beliefs.bayes.JunctionTreeBuilder;
import org.drools.beliefs.bayes.assembler.BayesNetworkAssemblerError;
import org.drools.beliefs.bayes.model.Bif;
import org.drools.beliefs.bayes.model.XmlBifParser;
import org.drools.compiler.builder.AbstractResourceProcessor;
import org.kie.api.io.Resource;
import org.kie.internal.builder.KnowledgeBuilderError;

public class JunctionTreeProcessor
extends AbstractResourceProcessor<JunctionTree> {
    public JunctionTreeProcessor(Resource resource) {
        super(resource);
    }

    public void process() {
        JunctionTreeBuilder builder;
        BayesNetwork network;
        ArrayList<KnowledgeBuilderError> errors = new ArrayList<KnowledgeBuilderError>();
        Bif bif = XmlBifParser.loadBif(this.getResource(), errors);
        if (bif == null) {
            errors.forEach(x$0 -> this.appendError((KnowledgeBuilderError)x$0));
            return;
        }
        try {
            network = XmlBifParser.buildBayesNetwork(bif);
        }
        catch (Exception e) {
            this.appendError((KnowledgeBuilderError)new BayesNetworkAssemblerError(this.getResource(), "Unable to parse opening Stream:\n" + e.toString()));
            return;
        }
        try {
            builder = new JunctionTreeBuilder(network);
        }
        catch (Exception e) {
            this.appendError((KnowledgeBuilderError)new BayesNetworkAssemblerError(this.getResource(), "Unable to build Junction Tree:\n" + e.toString()));
            return;
        }
        this.setProcessedResource(builder.build(this.getResource(), network.getPackageName(), network.getName()));
    }
}

