/*
 * Decompiled with CFR 0.152.
 */
package org.drools.benchmark.benchmarks;

import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.benchmark.BenchmarkDefinition;
import org.drools.benchmark.benchmarks.AbstractBenchmark;
import org.drools.benchmark.model.cep.Figure;
import org.drools.benchmark.model.cep.Letter;
import org.drools.builder.KnowledgeBuilder;
import org.drools.conf.EventProcessingOption;
import org.drools.conf.KnowledgeBaseOption;
import org.drools.runtime.StatefulKnowledgeSession;

public class CepBenchmark
extends AbstractBenchmark {
    private final int eventNr;
    private int offset = 0;
    private static KnowledgeBase kbase;
    private StatefulKnowledgeSession ksession;
    private int cloneCounter = 0;

    public CepBenchmark(int eventNr) {
        this.eventNr = eventNr;
    }

    public void init(BenchmarkDefinition definition, boolean isFirst) {
        if (isFirst) {
            KnowledgeBuilder kbuilder = this.createKnowledgeBuilder("cep.drl");
            KnowledgeBaseConfiguration config = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
            config.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
            kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)config);
            kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        }
        this.ksession = kbase.newStatefulKnowledgeSession();
        new Thread(new Runnable(){

            public void run() {
                CepBenchmark.this.ksession.fireUntilHalt();
            }
        }).start();
    }

    public void execute(int repNr) {
        for (int key = this.offset; key < this.offset + this.eventNr; ++key) {
            this.insertLetter(key);
            this.insertFigure(key);
        }
    }

    private void insertLetter(int key) {
        this.ksession.insert((Object)new Letter(key, (char)(65 + key / 100 % 26)));
    }

    private void insertFigure(int key) {
        this.ksession.insert((Object)new Figure(key, 10000000 + key % 10000000));
    }

    public void terminate(boolean isLast) {
        this.ksession.halt();
        this.ksession.dispose();
    }

    public CepBenchmark clone() {
        CepBenchmark clone = new CepBenchmark(this.eventNr);
        clone.offset = this.eventNr * this.cloneCounter;
        ++this.cloneCounter;
        return clone;
    }
}

