/*
 * Decompiled with CFR 0.152.
 */
package org.drools.benchmark.benchmarks;

import org.drools.benchmark.BenchmarkDefinition;
import org.drools.benchmark.benchmarks.AbstractBenchmark;
import org.drools.benchmark.model.cep.Figure;
import org.drools.benchmark.model.cep.Letter;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.internal.KieBaseConfiguration;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class CepBenchmark
extends AbstractBenchmark {
    private final int eventNr;
    private int offset = 0;
    private static KnowledgeBase kbase;
    private StatefulKnowledgeSession ksession;
    private int cloneCounter = 0;

    public CepBenchmark(int eventNr) {
        this.eventNr = eventNr;
    }

    @Override
    public void init(BenchmarkDefinition definition, boolean isFirst) {
        if (isFirst) {
            KnowledgeBuilder kbuilder = this.createKnowledgeBuilder("cep.drl");
            KieBaseConfiguration config = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
            config.setOption((KieBaseOption)EventProcessingOption.STREAM);
            kbase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)config);
            kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        }
        this.ksession = kbase.newStatefulKnowledgeSession();
        new Thread(new Runnable(){

            @Override
            public void run() {
                CepBenchmark.this.ksession.fireUntilHalt();
            }
        }).start();
    }

    @Override
    public void execute(int repNr) {
        for (int key = this.offset; key < this.offset + this.eventNr; ++key) {
            this.insertLetter(key);
            this.insertFigure(key);
        }
    }

    private void insertLetter(int key) {
        this.ksession.insert((Object)new Letter(key, (char)(65 + key / 100 % 26)));
    }

    private void insertFigure(int key) {
        this.ksession.insert((Object)new Figure(key, 10000000 + key % 10000000));
    }

    @Override
    public void terminate(boolean isLast) {
        this.ksession.halt();
        this.ksession.dispose();
    }

    @Override
    public CepBenchmark clone() {
        CepBenchmark clone = new CepBenchmark(this.eventNr);
        clone.offset = this.eventNr * this.cloneCounter;
        ++this.cloneCounter;
        return clone;
    }
}

