/*
 * Decompiled with CFR 0.152.
 */
package org.drools.benchmark.benchmarks;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.benchmark.BenchmarkDefinition;
import org.drools.benchmark.benchmarks.AbstractBenchmark;
import org.drools.benchmark.model.waltz.Line;
import org.drools.benchmark.model.waltz.Stage;
import org.kie.api.io.ResourceType;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class WaltzBenchmark
extends AbstractBenchmark {
    private KnowledgeBase kbase;
    private List<Line> lines = new ArrayList<Line>();

    @Override
    public void init(BenchmarkDefinition definition) {
        try {
            this.kbase = this.readRule();
            this.loadLines("/waltz50.dat");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void execute(int repNr) {
        StatefulKnowledgeSession session = this.kbase.newStatefulKnowledgeSession();
        for (Line l : this.lines) {
            session.insert((Object)l);
        }
        session.insert((Object)new Stage(1));
        session.fireAllRules();
        session.dispose();
    }

    private KnowledgeBase readRule() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)this.getClass().getResourceAsStream("/waltz.drl")), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    private void loadLines(String filename) throws IOException {
        if (!this.lines.isEmpty()) {
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(WaltzBenchmark.class.getResourceAsStream(filename)));
        Pattern pat = Pattern.compile(".*make line \\^p1 ([0-9]*) \\^p2 ([0-9]*).*");
        String line = reader.readLine();
        while (line != null) {
            Matcher m = pat.matcher(line);
            if (m.matches()) {
                Line l = new Line(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)));
                this.lines.add(l);
            }
            line = reader.readLine();
        }
        reader.close();
    }
}

