/*
 * Decompiled with CFR 0.152.
 */
package org.drools.benchmark;

import java.text.NumberFormat;
import org.drools.benchmark.BenchmarkResult;

public class ResultsAccumulator {
    public static final String RESULTS_FORMAT = "Benchmark Description;Min Duration;Max Duration;Avg Duration;Min Used Memory;Max Used Memory;Avg Used Memory";
    private static NumberFormat nf = NumberFormat.getInstance();
    private String benchmarkDescription;
    private int resultsCounter = 0;
    private long minDuration = Long.MAX_VALUE;
    private long maxDuration = 0L;
    private long totalDuration = 0L;
    private long minUsedMemory = Long.MAX_VALUE;
    private long maxUsedMemory = 0L;
    private long totalUsedMemory = 0L;

    public void accumulate(BenchmarkResult result) {
        if (this.benchmarkDescription == null) {
            this.benchmarkDescription = result.getDescription();
        } else if (!this.benchmarkDescription.equals(result.getDescription())) {
            throw new RuntimeException("Accumulating different benchmarks");
        }
        ++this.resultsCounter;
        this.minDuration = Math.min(this.minDuration, result.getDuration());
        this.maxDuration = Math.max(this.maxDuration, result.getDuration());
        this.totalDuration += result.getDuration();
        this.minUsedMemory = Math.min(this.minUsedMemory, result.memoryUsedByBenchmark());
        this.maxUsedMemory = Math.max(this.maxUsedMemory, result.memoryUsedByBenchmark());
        this.totalUsedMemory += result.memoryUsedByBenchmark();
    }

    public String toString() {
        double averageDuration = this.resultsCounter < 4 ? (double)this.totalDuration / (double)this.resultsCounter : (double)(this.totalDuration - this.minDuration - this.maxDuration) / (double)(this.resultsCounter - 2);
        return this.benchmarkDescription + ";" + nf.format(this.minDuration) + ";" + nf.format(this.maxDuration) + ";" + nf.format(averageDuration) + ";" + nf.format(this.minUsedMemory) + ";" + nf.format(this.maxUsedMemory) + ";" + nf.format(this.totalUsedMemory / (long)this.resultsCounter);
    }

    static {
        nf.setGroupingUsed(false);
        nf.setMinimumFractionDigits(0);
        nf.setMaximumFractionDigits(3);
        nf.setMaximumIntegerDigits(12);
    }
}

