/*
 * Decompiled with CFR 0.152.
 */
package org.drools.bpmn2.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.bpmn2.core.Definitions;
import org.drools.bpmn2.core.Error;
import org.drools.bpmn2.core.Escalation;
import org.drools.bpmn2.core.Interface;
import org.drools.bpmn2.core.ItemDefinition;
import org.drools.bpmn2.core.Lane;
import org.drools.bpmn2.core.Message;
import org.drools.bpmn2.core.SequenceFlow;
import org.drools.bpmn2.xml.XmlBPMNProcessDumper;
import org.drools.compiler.xml.ProcessBuildData;
import org.drools.definition.process.Connection;
import org.drools.definition.process.Node;
import org.drools.definition.process.NodeContainer;
import org.drools.definition.process.Process;
import org.drools.process.core.Context;
import org.drools.process.core.context.exception.ActionExceptionHandler;
import org.drools.process.core.context.exception.ExceptionHandler;
import org.drools.process.core.context.exception.ExceptionScope;
import org.drools.process.core.context.swimlane.Swimlane;
import org.drools.process.core.event.EventTypeFilter;
import org.drools.process.core.timer.Timer;
import org.drools.ruleflow.core.RuleFlowProcess;
import org.drools.workflow.core.Constraint;
import org.drools.workflow.core.DroolsAction;
import org.drools.workflow.core.impl.ConnectionImpl;
import org.drools.workflow.core.impl.ConnectionRef;
import org.drools.workflow.core.impl.ConstraintImpl;
import org.drools.workflow.core.impl.DroolsConsequenceAction;
import org.drools.workflow.core.impl.NodeImpl;
import org.drools.workflow.core.node.CompositeContextNode;
import org.drools.workflow.core.node.EventNode;
import org.drools.workflow.core.node.HumanTaskNode;
import org.drools.workflow.core.node.Split;
import org.drools.workflow.core.node.StateNode;
import org.drools.xml.BaseAbstractHandler;
import org.drools.xml.ExtensibleXmlParser;
import org.drools.xml.Handler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessHandler
extends BaseAbstractHandler
implements Handler {
    public static final String CONNECTIONS = "BPMN.Connections";

    public ProcessHandler() {
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(Definitions.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.validPeers.add(ItemDefinition.class);
            this.validPeers.add(Message.class);
            this.validPeers.add(Interface.class);
            this.validPeers.add(Escalation.class);
            this.validPeers.add(Error.class);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        String id = attrs.getValue("id");
        String name = attrs.getValue("name");
        String packageName = attrs.getValue("http://www.jboss.org/drools", "packageName");
        RuleFlowProcess process = new RuleFlowProcess();
        process.setAutoComplete(true);
        process.setId(id);
        if (name == null) {
            name = id;
        }
        process.setName(name);
        process.setType("RuleFlow");
        if (packageName == null) {
            packageName = "org.drools.bpmn2";
        }
        process.setPackageName(packageName);
        ((ProcessBuildData)parser.getData()).setProcess((Process)process);
        return process;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        parser.endElementBuilder();
        RuleFlowProcess process = (RuleFlowProcess)parser.getCurrent();
        List connections = (List)process.getMetaData(CONNECTIONS);
        ProcessHandler.linkConnections((NodeContainer)process, connections);
        ProcessHandler.linkBoundaryEvents((NodeContainer)process);
        List lanes = (List)process.getMetaData("BPMN.Lanes");
        this.assignLanes(process, lanes);
        this.postProcessNodes((NodeContainer)process);
        return process;
    }

    public Class<?> generateNodeFor() {
        return Process.class;
    }

    /*
     * Unable to fully structure code
     */
    public static void linkConnections(NodeContainer nodeContainer, List<SequenceFlow> connections) {
        if (connections != null) {
            for (SequenceFlow connection : connections) {
                block20: {
                    block19: {
                        sourceRef = connection.getSourceRef();
                        targetRef = connection.getTargetRef();
                        source = null;
                        target = null;
                        try {
                            sourceRef = sourceRef.substring(1);
                            sourceRef = sourceRef.substring(sourceRef.lastIndexOf("-") + 1);
                            source = nodeContainer.getNode((long)new Integer(sourceRef).intValue());
                            break block19;
                        }
                        catch (NumberFormatException e) {
                            var12_16 = nodeContainer.getNodes();
                            var11_14 = var12_16.length;
                            var10_12 = 0;
                            ** while (var10_12 < var11_14)
                        }
lbl-1000:
                        // 1 sources

                        {
                            node = var12_16[var10_12];
                            if (connection.getSourceRef().equals(node.getMetaData("UniqueId"))) {
                                source = node;
                                break;
                            }
                            ++var10_12;
                            continue;
                        }
lbl23:
                        // 2 sources

                        if (source == null) {
                            throw new IllegalArgumentException("Could not find source node for connection:" + connection.getSourceRef());
                        }
                    }
                    try {
                        targetRef = targetRef.substring(1);
                        targetRef = targetRef.substring(targetRef.lastIndexOf("-") + 1);
                        target = nodeContainer.getNode((long)new Integer(targetRef).intValue());
                        break block20;
                    }
                    catch (NumberFormatException e) {
                        var12_16 = nodeContainer.getNodes();
                        var11_14 = var12_16.length;
                        var10_12 = 0;
                        ** while (var10_12 < var11_14)
                    }
lbl-1000:
                    // 1 sources

                    {
                        node = var12_16[var10_12];
                        if (connection.getTargetRef().equals(node.getMetaData("UniqueId"))) {
                            target = node;
                            break;
                        }
                        ++var10_12;
                        continue;
                    }
lbl42:
                    // 2 sources

                    if (target == null) {
                        throw new IllegalArgumentException("Could not find target node for connection:" + connection.getTargetRef());
                    }
                }
                result = new ConnectionImpl(source, "DROOLS_DEFAULT", target, "DROOLS_DEFAULT");
                result.setMetaData("bendpoints", (Object)connection.getBendpoints());
                result.setMetaData("UniqueId", (Object)connection.getId());
                if (!(source instanceof Split)) continue;
                split = (Split)source;
                constraint = new ConstraintImpl();
                defaultConnection = (String)split.getMetaData("Default");
                if (defaultConnection != null && defaultConnection.equals(connection.getId())) {
                    constraint.setDefault(true);
                }
                if (connection.getName() != null) {
                    constraint.setName(connection.getName());
                } else {
                    constraint.setName("");
                }
                if (connection.getType() != null) {
                    constraint.setType(connection.getType());
                } else {
                    constraint.setType("code");
                }
                if (connection.getLanguage() != null) {
                    constraint.setDialect(connection.getLanguage());
                }
                if (connection.getExpression() != null) {
                    constraint.setConstraint(connection.getExpression());
                }
                split.addConstraint(new ConnectionRef(target.getId(), "DROOLS_DEFAULT"), (Constraint)constraint);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void linkBoundaryEvents(NodeContainer nodeContainer) {
        var4_1 = nodeContainer.getNodes();
        var3_2 = var4_1.length;
        var2_3 = 0;
        while (var2_3 < var3_2) {
            node = var4_1[var2_3];
            if (node instanceof EventNode && (attachedTo = (String)node.getMetaData("AttachedTo")) != null) {
                block16: {
                    type = ((EventTypeFilter)((EventNode)node).getEventFilters().get(0)).getType();
                    attachedNode = null;
                    try {
                        attachedToString = attachedTo.substring(1);
                        attachedToString = attachedToString.substring(attachedToString.lastIndexOf("-") + 1);
                        attachedNode = nodeContainer.getNode((long)new Integer(attachedToString).intValue());
                        break block16;
                    }
                    catch (NumberFormatException e) {
                        var12_21 = nodeContainer.getNodes();
                        var11_17 = var12_21.length;
                        var10_13 = 0;
                        ** while (var10_13 < var11_17)
                    }
lbl-1000:
                    // 1 sources

                    {
                        subnode = var12_21[var10_13];
                        if (attachedTo.equals(subnode.getMetaData("UniqueId"))) {
                            attachedNode = subnode;
                            break;
                        }
                        ++var10_13;
                        continue;
                    }
lbl25:
                    // 2 sources

                    if (attachedNode == null) {
                        throw new IllegalArgumentException("Could not find node to attach to: " + attachedTo);
                    }
                }
                if (type.startsWith("Escalation-")) {
                    cancelActivity = (Boolean)node.getMetaData("CancelActivity");
                    compositeNode = (CompositeContextNode)attachedNode;
                    exceptionScope = (ExceptionScope)compositeNode.getDefaultContext("ExceptionScope");
                    if (exceptionScope == null) {
                        exceptionScope = new ExceptionScope();
                        compositeNode.addContext((Context)exceptionScope);
                        compositeNode.setDefaultContext((Context)exceptionScope);
                    }
                    escalationCode = (String)node.getMetaData("EscalationEvent");
                    exceptionHandler = new ActionExceptionHandler();
                    exceptionHandler.setAction((DroolsAction)new DroolsConsequenceAction("java", String.valueOf(cancelActivity != false ? "((org.drools.workflow.instance.NodeInstance) kcontext.getNodeInstance()).cancel();" : "") + "kcontext.getProcessInstance().signalEvent(\"Escalation-" + attachedTo + "-" + escalationCode + "\", null);"));
                    exceptionScope.setExceptionHandler(escalationCode, (ExceptionHandler)exceptionHandler);
                } else if (type.startsWith("Error-")) {
                    compositeNode = (CompositeContextNode)attachedNode;
                    exceptionScope = (ExceptionScope)compositeNode.getDefaultContext("ExceptionScope");
                    if (exceptionScope == null) {
                        exceptionScope = new ExceptionScope();
                        compositeNode.addContext((Context)exceptionScope);
                        compositeNode.setDefaultContext((Context)exceptionScope);
                    }
                    errorCode = (String)node.getMetaData("ErrorEvent");
                    exceptionHandler = new ActionExceptionHandler();
                    exceptionHandler.setAction((DroolsAction)new DroolsConsequenceAction("java", "((org.drools.workflow.instance.NodeInstance) kcontext.getNodeInstance()).cancel();kcontext.getProcessInstance().signalEvent(\"Error-" + attachedTo + "-" + errorCode + "\", null);"));
                    exceptionScope.setExceptionHandler(errorCode, (ExceptionHandler)exceptionHandler);
                } else if (type.startsWith("Timer-")) {
                    cancelActivity = (Boolean)node.getMetaData("CancelActivity");
                    compositeNode = (CompositeContextNode)attachedNode;
                    timeCycle = (String)node.getMetaData("TimeCycle");
                    timer = new Timer();
                    timer.setDelay(timeCycle);
                    compositeNode.addTimer(timer, (DroolsAction)new DroolsConsequenceAction("java", String.valueOf(cancelActivity != false ? "((org.drools.workflow.instance.NodeInstance) kcontext.getNodeInstance()).cancel();" : "") + "kcontext.getProcessInstance().signalEvent(\"Timer-" + attachedTo + "-" + timeCycle + "\", null);"));
                } else if (type.startsWith("Compensate-")) {
                    uniqueId = (String)node.getMetaData("UniqueId");
                    eventType = "Compensate-" + uniqueId;
                    ((EventTypeFilter)((EventNode)node).getEventFilters().get(0)).setType(eventType);
                }
            }
            ++var2_3;
        }
    }

    private void assignLanes(RuleFlowProcess process, List<Lane> lanes) {
        ArrayList<String> laneNames = new ArrayList<String>();
        HashMap<String, String> laneMapping = new HashMap<String, String>();
        if (lanes != null) {
            for (Lane lane : lanes) {
                String name = lane.getName();
                if (name == null) continue;
                Swimlane swimlane = new Swimlane();
                swimlane.setName(name);
                process.getSwimlaneContext().addSwimlane(swimlane);
                laneNames.add(name);
                for (String flowElementRef : lane.getFlowElements()) {
                    laneMapping.put(flowElementRef, name);
                }
            }
        }
        this.assignLanes((NodeContainer)process, laneMapping);
    }

    private void postProcessNodes(NodeContainer container) {
        Node[] nodeArray = container.getNodes();
        int n = nodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            if (node instanceof StateNode) {
                StateNode stateNode = (StateNode)node;
                String condition = (String)stateNode.getMetaData("Condition");
                ConstraintImpl constraint = new ConstraintImpl();
                constraint.setConstraint(condition);
                constraint.setType("rule");
                for (Connection connection : stateNode.getDefaultOutgoingConnections()) {
                    stateNode.setConstraint(connection, (Constraint)constraint);
                }
            } else if (node instanceof NodeContainer) {
                this.postProcessNodes((NodeContainer)node);
            }
            ++n2;
        }
    }

    private void assignLanes(NodeContainer nodeContainer, Map<String, String> laneMapping) {
        Node[] nodeArray = nodeContainer.getNodes();
        int n = nodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            String lane = null;
            String uniqueId = (String)node.getMetaData("UniqueId");
            lane = uniqueId != null ? laneMapping.get(uniqueId) : laneMapping.get(XmlBPMNProcessDumper.getUniqueNodeId(node));
            if (lane != null) {
                ((NodeImpl)node).setMetaData("Lane", (Object)lane);
                if (node instanceof HumanTaskNode) {
                    ((HumanTaskNode)node).setSwimlane(lane);
                }
            }
            if (node instanceof NodeContainer) {
                this.assignLanes((NodeContainer)node, laneMapping);
            }
            ++n2;
        }
    }
}

