/*
 * Decompiled with CFR 0.152.
 */
package org.drools.bpmn2.legacy.beta1;

import java.util.ArrayList;
import org.drools.bpmn2.legacy.beta1.AbstractNodeHandler;
import org.drools.process.core.event.EventTypeFilter;
import org.drools.workflow.core.Node;
import org.drools.workflow.core.NodeContainer;
import org.drools.workflow.core.node.EventNode;
import org.drools.xml.ExtensibleXmlParser;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BoundaryEventHandler
extends AbstractNodeHandler {
    protected Node createNode(Attributes attrs) {
        return new EventNode();
    }

    public Class generateNodeFor() {
        return EventNode.class;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        Node node = (Node)parser.getCurrent();
        String attachedTo = element.getAttribute("attachedToRef");
        String cancelActivityString = element.getAttribute("cancelActivity");
        boolean cancelActivity = true;
        if ("false".equals(cancelActivityString)) {
            cancelActivity = false;
        }
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("escalationEventDefinition".equals(nodeName)) {
                this.handleEscalationNode(node, element, uri, localName, parser, attachedTo, cancelActivity);
                break;
            }
            if ("errorEventDefinition".equals(nodeName)) {
                this.handleErrorNode(node, element, uri, localName, parser, attachedTo, cancelActivity);
                break;
            }
            if ("timerEventDefinition".equals(nodeName)) {
                this.handleTimerNode(node, element, uri, localName, parser, attachedTo, cancelActivity);
                break;
            }
            if (!"compensateEventDefinition".equals(nodeName)) continue;
            this.handleCompensationNode(node, element, uri, localName, parser, attachedTo, cancelActivity);
            break;
        }
        NodeContainer nodeContainer = (NodeContainer)parser.getParent();
        nodeContainer.addNode((org.drools.definition.process.Node)node);
        return node;
    }

    protected void handleEscalationNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser, String attachedTo, boolean cancelActivity) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        EventNode eventNode = (EventNode)node;
        eventNode.setMetaData("AttachedTo", (Object)attachedTo);
        eventNode.setMetaData("CancelActivity", (Object)cancelActivity);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String type;
            String nodeName = xmlNode.getNodeName();
            if (!"escalationEventDefinition".equals(nodeName) || (type = ((Element)xmlNode).getAttribute("escalationCode")) == null || type.trim().length() <= 0) continue;
            ArrayList<EventTypeFilter> eventFilters = new ArrayList<EventTypeFilter>();
            EventTypeFilter eventFilter = new EventTypeFilter();
            eventFilter.setType("Escalation-" + attachedTo + "-" + type);
            eventFilters.add(eventFilter);
            eventNode.setEventFilters(eventFilters);
            eventNode.setMetaData("EscalationEvent", (Object)type);
        }
    }

    protected void handleErrorNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser, String attachedTo, boolean cancelActivity) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        EventNode eventNode = (EventNode)node;
        eventNode.setMetaData("AttachedTo", (Object)attachedTo);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String type;
            String nodeName = xmlNode.getNodeName();
            if (!"errorEventDefinition".equals(nodeName) || (type = ((Element)xmlNode).getAttribute("errorCode")) == null || type.trim().length() <= 0) continue;
            ArrayList<EventTypeFilter> eventFilters = new ArrayList<EventTypeFilter>();
            EventTypeFilter eventFilter = new EventTypeFilter();
            eventFilter.setType("Error-" + attachedTo + "-" + type);
            eventFilters.add(eventFilter);
            eventNode.setEventFilters(eventFilters);
            eventNode.setMetaData("ErrorEvent", (Object)type);
        }
    }

    protected void handleTimerNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser, String attachedTo, boolean cancelActivity) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        EventNode eventNode = (EventNode)node;
        eventNode.setMetaData("AttachedTo", (Object)attachedTo);
        eventNode.setMetaData("CancelActivity", (Object)cancelActivity);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"timerEventDefinition".equals(nodeName)) continue;
            String timeCycle = null;
            org.w3c.dom.Node subNode = xmlNode.getFirstChild();
            while (subNode instanceof Element) {
                String subNodeName = subNode.getNodeName();
                if ("timeCycle".equals(subNodeName)) {
                    timeCycle = subNode.getTextContent();
                    break;
                }
                subNode = subNode.getNextSibling();
            }
            if (timeCycle == null || timeCycle.trim().length() <= 0) continue;
            ArrayList<EventTypeFilter> eventFilters = new ArrayList<EventTypeFilter>();
            EventTypeFilter eventFilter = new EventTypeFilter();
            eventFilter.setType("Timer-" + attachedTo + "-" + timeCycle);
            eventFilters.add(eventFilter);
            eventNode.setEventFilters(eventFilters);
            eventNode.setMetaData("TimeCycle", (Object)timeCycle);
        }
    }

    protected void handleCompensationNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser, String attachedTo, boolean cancelActivity) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        EventNode eventNode = (EventNode)node;
        eventNode.setMetaData("AttachedTo", (Object)attachedTo);
        ArrayList<EventTypeFilter> eventFilters = new ArrayList<EventTypeFilter>();
        EventTypeFilter eventFilter = new EventTypeFilter();
        String eventType = "Compensate-";
        eventFilter.setType(eventType);
        eventFilters.add(eventFilter);
        ((EventNode)node).setEventFilters(eventFilters);
    }

    public void writeNode(Node node, StringBuilder xmlDump, boolean includeMeta) {
        throw new IllegalArgumentException("Writing out should be handled by specific handlers");
    }
}

