/*
 * Decompiled with CFR 0.152.
 */
package org.drools.bpmn2.legacy.beta1;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.bpmn2.legacy.beta1.AbstractNodeHandler;
import org.drools.bpmn2.legacy.beta1.BPMNSemanticModule;
import org.drools.compiler.xml.XmlDumper;
import org.drools.definition.process.Connection;
import org.drools.definition.process.Node;
import org.drools.definition.process.NodeContainer;
import org.drools.process.core.ContextContainer;
import org.drools.process.core.Process;
import org.drools.process.core.Work;
import org.drools.process.core.context.swimlane.Swimlane;
import org.drools.process.core.context.swimlane.SwimlaneContext;
import org.drools.process.core.context.variable.Variable;
import org.drools.process.core.context.variable.VariableScope;
import org.drools.process.core.datatype.impl.type.ObjectDataType;
import org.drools.process.core.event.EventTypeFilter;
import org.drools.workflow.core.Constraint;
import org.drools.workflow.core.WorkflowProcess;
import org.drools.workflow.core.node.ActionNode;
import org.drools.workflow.core.node.CompositeNode;
import org.drools.workflow.core.node.EndNode;
import org.drools.workflow.core.node.EventNode;
import org.drools.workflow.core.node.EventTrigger;
import org.drools.workflow.core.node.FaultNode;
import org.drools.workflow.core.node.ForEachNode;
import org.drools.workflow.core.node.HumanTaskNode;
import org.drools.workflow.core.node.Join;
import org.drools.workflow.core.node.RuleSetNode;
import org.drools.workflow.core.node.Split;
import org.drools.workflow.core.node.StartNode;
import org.drools.workflow.core.node.SubProcessNode;
import org.drools.workflow.core.node.TimerNode;
import org.drools.workflow.core.node.Trigger;
import org.drools.workflow.core.node.WorkItemNode;
import org.drools.xml.Handler;
import org.drools.xml.SemanticModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlBPMNProcessDumper {
    public static final String JAVA_LANGUAGE = "http://www.java.com/java";
    public static final String RULE_LANGUAGE = "http://www.jboss.org/drools/rule";
    public static final String XPATH_LANGUAGE = "http://www.w3.org/1999/XPath";
    public static XmlBPMNProcessDumper INSTANCE = new XmlBPMNProcessDumper();
    private static final String EOL = System.getProperty("line.separator");
    private SemanticModule semanticModule = new BPMNSemanticModule();

    private XmlBPMNProcessDumper() {
    }

    public String dump(org.drools.definition.process.WorkflowProcess process) {
        return this.dump(process, true);
    }

    public String dump(org.drools.definition.process.WorkflowProcess process, boolean includeMeta) {
        StringBuilder xmlDump = new StringBuilder();
        this.visitProcess(process, xmlDump, includeMeta);
        return xmlDump.toString();
    }

    protected void visitProcess(org.drools.definition.process.WorkflowProcess process, StringBuilder xmlDump, boolean includeMeta) {
        String packageName;
        String targetNamespace = (String)process.getMetaData().get("TargetNamespace");
        if (targetNamespace == null) {
            targetNamespace = "http://www.jboss.org/drools";
        }
        xmlDump.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?> " + EOL + "<definitions id=\"Definition\"" + EOL + "             targetNamespace=\"" + targetNamespace + "\"" + EOL + "             typeLanguage=\"http://www.java.com/javaTypes\"" + EOL + "             expressionLanguage=\"http://www.mvel.org/2.0\"" + EOL + "             xmlns=\"http://schema.omg.org/spec/BPMN/2.0\"" + EOL + "             xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"" + EOL + "             xs:schemaLocation=\"http://schema.omg.org/spec/BPMN/2.0 BPMN20.xsd\"" + EOL + "             xmlns:di=\"http://bpmndi.org\"" + EOL + "             xmlns:tns=\"http://www.jboss.org/drools\">" + EOL + EOL);
        VariableScope variableScope = (VariableScope)((Process)process).getDefaultContext("VariableScope");
        this.visitVariableScope(variableScope, "_", xmlDump);
        this.visitSubVariableScopes(process.getNodes(), xmlDump);
        xmlDump.append("  <resource id=\"Actor\" name=\"Human Actor\" />" + EOL + EOL);
        this.visitInterfaces(process, xmlDump);
        xmlDump.append("  <process processType=\"executable\" ");
        if (process.getId() != null) {
            xmlDump.append("id=\"" + XmlDumper.replaceIllegalChars((String)process.getId()) + "\" ");
        }
        if (process.getName() != null) {
            xmlDump.append("name=\"" + XmlDumper.replaceIllegalChars((String)process.getName()) + "\" ");
        }
        if ((packageName = process.getPackageName()) != null && !"org.drools.bpmn2".equals(packageName)) {
            xmlDump.append("tns:packageName=\"" + XmlDumper.replaceIllegalChars((String)packageName) + "\" ");
        }
        xmlDump.append(">" + EOL + EOL);
        this.visitLanes(process, xmlDump);
        this.visitHeader(process, xmlDump, includeMeta);
        this.visitNodes(process, xmlDump, includeMeta);
        this.visitConnections(process.getNodes(), xmlDump, includeMeta);
        xmlDump.append("  </process>" + EOL + EOL);
        if (includeMeta) {
            xmlDump.append("  <di:processDiagram processRef=\"" + XmlDumper.replaceIllegalChars((String)process.getId()) + "\" >" + EOL + "    <di:laneCompartment isVisible=\"false\" >" + EOL);
            for (Node node : process.getNodes()) {
                int offsetY;
                int offsetX;
                String nodeType = null;
                Integer x = (Integer)node.getMetaData().get("x");
                Integer y = (Integer)node.getMetaData().get("y");
                Integer width = (Integer)node.getMetaData().get("width");
                Integer height = (Integer)node.getMetaData().get("height");
                if (node instanceof StartNode || node instanceof EndNode || node instanceof EventNode || node instanceof FaultNode) {
                    nodeType = "event";
                    offsetX = (width - 30) / 2;
                    width = 30;
                    x = x + offsetX;
                    offsetY = (height - 30) / 2;
                    y = y + offsetY;
                    height = 30;
                } else if (node instanceof ActionNode || node instanceof RuleSetNode || node instanceof TimerNode) {
                    nodeType = "activity";
                } else if (node instanceof Join || node instanceof Split) {
                    nodeType = "gateway";
                    offsetX = (width - 40) / 2;
                    width = 40;
                    x = x + offsetX;
                    offsetY = (height - 40) / 2;
                    y = y + offsetY;
                    height = 40;
                } else if (node instanceof SubProcessNode) {
                    nodeType = "calledSubprocess";
                } else if (node instanceof CompositeNode) {
                    nodeType = "subprocess";
                } else if (node instanceof WorkItemNode) {
                    nodeType = "activity";
                }
                xmlDump.append("      <di:" + nodeType + "Shape id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_gui\" " + nodeType + "Ref=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "\" " + "x=\"" + x + "\" " + "y=\"" + y + "\" " + "width=\"" + width + "\" " + "height=\"" + height + "\" " + " />" + EOL);
            }
            xmlDump.append("    </di:laneCompartment>" + EOL);
            this.visitConnectionsDi(process.getNodes(), xmlDump);
            xmlDump.append("  </di:processDiagram>" + EOL + EOL);
        }
        xmlDump.append("</definitions>");
    }

    private void visitVariableScope(VariableScope variableScope, String prefix, StringBuilder xmlDump) {
        if (variableScope != null && !variableScope.getVariables().isEmpty()) {
            for (Variable variable : variableScope.getVariables()) {
                xmlDump.append("  <itemDefinition id=\"" + XmlDumper.replaceIllegalChars((String)(prefix + variable.getName())) + "Item\" ");
                if (variable.getType() != null) {
                    xmlDump.append("structureRef=\"" + XmlDumper.replaceIllegalChars((String)variable.getType().getStringType()) + "\" ");
                }
                xmlDump.append("/>" + EOL);
            }
            xmlDump.append(EOL);
        }
    }

    private void visitSubVariableScopes(Node[] nodes, StringBuilder xmlDump) {
        for (Node node : nodes) {
            VariableScope variableScope;
            if (node instanceof ContextContainer && (variableScope = (VariableScope)((ContextContainer)node).getDefaultContext("VariableScope")) != null) {
                this.visitVariableScope(variableScope, XmlBPMNProcessDumper.getUniqueNodeId(node) + "-", xmlDump);
            }
            if (!(node instanceof NodeContainer)) continue;
            this.visitSubVariableScopes(((NodeContainer)node).getNodes(), xmlDump);
        }
    }

    private void visitLanes(org.drools.definition.process.WorkflowProcess process, StringBuilder xmlDump) {
        Collection swimlanes = ((SwimlaneContext)((WorkflowProcess)process).getDefaultContext("SwimlaneScope")).getSwimlanes();
        if (!swimlanes.isEmpty()) {
            xmlDump.append("    <laneSet>" + EOL);
            for (Swimlane swimlane : swimlanes) {
                xmlDump.append("      <lane name=\"" + XmlDumper.replaceIllegalChars((String)swimlane.getName()) + "\" >" + EOL);
                this.visitLane((NodeContainer)process, swimlane.getName(), xmlDump);
                xmlDump.append("      </lane>" + EOL);
            }
            xmlDump.append("    </laneSet>" + EOL);
        }
    }

    private void visitLane(NodeContainer container, String lane, StringBuilder xmlDump) {
        for (Node node : container.getNodes()) {
            String swimlane;
            if (node instanceof HumanTaskNode) {
                swimlane = ((HumanTaskNode)node).getSwimlane();
                if (lane.equals(swimlane)) {
                    xmlDump.append("        <flowElementRef>" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "</flowElementRef>" + EOL);
                }
            } else {
                swimlane = (String)node.getMetaData().get("Lane");
                if (lane.equals(swimlane)) {
                    xmlDump.append("        <flowElementRef>" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "</flowElementRef>" + EOL);
                }
            }
            if (!(node instanceof NodeContainer)) continue;
            this.visitLane((NodeContainer)node, lane, xmlDump);
        }
    }

    protected void visitHeader(org.drools.definition.process.WorkflowProcess process, StringBuilder xmlDump, boolean includeMeta) {
        VariableScope variableScope = (VariableScope)((Process)process).getDefaultContext("VariableScope");
        if (variableScope != null) {
            XmlBPMNProcessDumper.visitVariables(variableScope.getVariables(), xmlDump);
        }
    }

    public static void visitVariables(List<Variable> variables, StringBuilder xmlDump) {
        if (!variables.isEmpty()) {
            xmlDump.append("    <!-- process variables -->" + EOL);
            for (Variable variable : variables) {
                if (variable.getMetaData("DataObject") != null) continue;
                xmlDump.append("    <property id=\"" + XmlDumper.replaceIllegalChars((String)variable.getName()) + "\" ");
                if (variable.getType() != null) {
                    xmlDump.append("itemSubjectRef=\"_" + XmlDumper.replaceIllegalChars((String)variable.getName()) + "Item\"");
                }
                xmlDump.append("/>" + EOL);
            }
            for (Variable variable : variables) {
                if (variable.getMetaData("DataObject") == null) continue;
                xmlDump.append("    <dataObject id=\"" + XmlDumper.replaceIllegalChars((String)variable.getName()) + "\" ");
                if (variable.getType() != null) {
                    xmlDump.append("itemSubjectRef=\"_" + XmlDumper.replaceIllegalChars((String)variable.getName()) + "Item\"");
                }
                xmlDump.append("/>" + EOL);
            }
            xmlDump.append(EOL);
        }
    }

    protected void visitInterfaces(org.drools.definition.process.WorkflowProcess process, StringBuilder xmlDump) {
        for (Node node : process.getNodes()) {
            String messageType;
            String messageType2;
            if (node instanceof WorkItemNode) {
                Work work = ((WorkItemNode)node).getWork();
                if (work == null) continue;
                if ("Service Task".equals(work.getName())) {
                    String parameterType;
                    String operationName;
                    String interfaceName = (String)work.getParameter("Interface");
                    if (interfaceName == null) {
                        interfaceName = "";
                    }
                    if ((operationName = (String)work.getParameter("Operation")) == null) {
                        operationName = "";
                    }
                    if ((parameterType = (String)work.getParameter("ParameterType")) == null) {
                        parameterType = "";
                    }
                    xmlDump.append("  <itemDefinition id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_InMessageType\" structureRef=\"" + parameterType + "\"/>" + EOL + "  <message id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_InMessage\" structureRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_InMessageType\" />" + EOL + "  <interface id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_ServiceInterface\" name=\"" + interfaceName + "\">" + EOL + "    <operation id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_ServiceOperation\" name=\"" + operationName + "\">" + EOL + "      <inMessageRef>" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_InMessage</inMessageRef>" + EOL + "    </operation>" + EOL + "  </interface>" + EOL + EOL);
                    continue;
                }
                if ("Send Task".equals(work.getName())) {
                    messageType2 = (String)work.getParameter("MessageType");
                    if (messageType2 == null) {
                        messageType2 = "";
                    }
                    xmlDump.append("  <itemDefinition id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_MessageType\" structureRef=\"" + XmlDumper.replaceIllegalChars((String)messageType2) + "\"/>" + EOL + "  <message id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_Message\" structureRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_MessageType\" />" + EOL + EOL);
                    continue;
                }
                if (!"Receive Task".equals(work.getName())) continue;
                messageType2 = (String)work.getParameter("MessageType");
                if (messageType2 == null) {
                    messageType2 = "";
                }
                xmlDump.append("  <itemDefinition id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_MessageType\" structureRef=\"" + XmlDumper.replaceIllegalChars((String)messageType2) + "\"/>" + EOL + "  <message id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_Message\" structureRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_MessageType\" />" + EOL + EOL);
                continue;
            }
            if (node instanceof EndNode) {
                messageType = (String)node.getMetaData().get("MessageType");
                if (messageType == null) continue;
                xmlDump.append("  <itemDefinition id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_MessageType\" structureRef=\"" + XmlDumper.replaceIllegalChars((String)messageType) + "\"/>" + EOL + "  <message id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_Message\" structureRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_MessageType\" />" + EOL + EOL);
                continue;
            }
            if (node instanceof ActionNode) {
                messageType = (String)node.getMetaData().get("MessageType");
                if (messageType == null) continue;
                xmlDump.append("  <itemDefinition id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_MessageType\" structureRef=\"" + XmlDumper.replaceIllegalChars((String)messageType) + "\"/>" + EOL + "  <message id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_Message\" structureRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_MessageType\" />" + EOL + EOL);
                continue;
            }
            if (node instanceof EventNode) {
                String messageRef = ((EventTypeFilter)((EventNode)node).getEventFilters().get(0)).getType();
                messageRef = messageRef.substring(8);
                messageType2 = (String)node.getMetaData().get("MessageType");
                xmlDump.append("  <itemDefinition id=\"" + XmlDumper.replaceIllegalChars((String)messageRef) + "Type\" structureRef=\"" + XmlDumper.replaceIllegalChars((String)messageType2) + "\"/>" + EOL + "  <message id=\"" + XmlDumper.replaceIllegalChars((String)messageRef) + "\" structureRef=\"" + XmlDumper.replaceIllegalChars((String)messageRef) + "Type\" />" + EOL + EOL);
                continue;
            }
            if (node instanceof StartNode) {
                String eventType;
                Trigger trigger;
                StartNode startNode = (StartNode)node;
                if (startNode.getTriggers() == null || startNode.getTriggers().isEmpty() || !((trigger = (Trigger)startNode.getTriggers().get(0)) instanceof EventTrigger) || !(eventType = ((EventTypeFilter)((EventTrigger)trigger).getEventFilters().get(0)).getType()).startsWith("Message-")) continue;
                eventType = eventType.substring(8);
                String messageType3 = (String)node.getMetaData().get("MessageType");
                xmlDump.append("  <itemDefinition id=\"" + XmlDumper.replaceIllegalChars((String)eventType) + "Type\" structureRef=\"" + XmlDumper.replaceIllegalChars((String)messageType3) + "\"/>" + EOL + "  <message id=\"" + XmlDumper.replaceIllegalChars((String)eventType) + "\" structureRef=\"" + XmlDumper.replaceIllegalChars((String)eventType) + "Type\" />" + EOL + EOL);
                continue;
            }
            if (!(node instanceof ForEachNode)) continue;
            ForEachNode forEachNode = (ForEachNode)node;
            xmlDump.append("  <itemDefinition id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((Node)forEachNode) + "_multiInstanceItemType\" structureRef=\"" + XmlDumper.replaceIllegalChars((String)((ObjectDataType)forEachNode.getVariableType()).getClassName()) + "\"/>" + EOL + EOL);
        }
    }

    private void visitNodes(org.drools.definition.process.WorkflowProcess process, StringBuilder xmlDump, boolean includeMeta) {
        xmlDump.append("    <!-- nodes -->" + EOL);
        for (Node node : process.getNodes()) {
            this.visitNode(node, xmlDump, includeMeta);
        }
        xmlDump.append(EOL);
    }

    public void visitNode(Node node, StringBuilder xmlDump, boolean includeMeta) {
        Handler handler = this.semanticModule.getHandlerByClass(node.getClass());
        if (handler == null) {
            throw new IllegalArgumentException("Unknown node type: " + node);
        }
        ((AbstractNodeHandler)handler).writeNode((org.drools.workflow.core.Node)node, xmlDump, includeMeta);
    }

    private void visitConnections(Node[] nodes, StringBuilder xmlDump, boolean includeMeta) {
        xmlDump.append("    <!-- connections -->" + EOL);
        ArrayList connections = new ArrayList();
        for (Node node : nodes) {
            for (List connectionList : node.getIncomingConnections().values()) {
                connections.addAll(connectionList);
            }
        }
        for (Connection connection : connections) {
            this.visitConnection(connection, xmlDump, includeMeta);
        }
        xmlDump.append(EOL);
    }

    public void visitConnection(Connection connection, StringBuilder xmlDump, boolean includeMeta) {
        xmlDump.append("    <sequenceFlow id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(connection.getFrom()) + "-" + XmlBPMNProcessDumper.getUniqueNodeId(connection.getTo()) + "\" sourceRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId(connection.getFrom()) + "\" ");
        xmlDump.append("targetRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId(connection.getTo()) + "\" ");
        if (connection.getFrom() instanceof Split) {
            Split split = (Split)connection.getFrom();
            if (split.getType() == 2 || split.getType() == 3) {
                Constraint constraint = split.getConstraint(connection);
                if (constraint == null) {
                    xmlDump.append(">" + EOL + "      <conditionExpression xs:type=\"tFormalExpression\" />");
                } else {
                    if (constraint.getName() != null && constraint.getName().trim().length() > 0) {
                        xmlDump.append("name=\"" + XmlDumper.replaceIllegalChars((String)constraint.getName()) + "\" ");
                    }
                    xmlDump.append(">" + EOL + "      <conditionExpression xs:type=\"tFormalExpression\" ");
                    if ("code".equals(constraint.getType())) {
                        if ("java".equals(constraint.getDialect())) {
                            xmlDump.append("language=\"http://www.java.com/java\" ");
                        } else if ("XPath".equals(constraint.getDialect())) {
                            xmlDump.append("language=\"http://www.w3.org/1999/XPath\" ");
                        }
                    } else {
                        xmlDump.append("language=\"http://www.jboss.org/drools/rule\" ");
                    }
                    String constraintString = constraint.getConstraint();
                    if (constraintString == null) {
                        constraintString = "";
                    }
                    xmlDump.append(">" + XmlDumper.replaceIllegalChars((String)constraintString) + "</conditionExpression>");
                }
                xmlDump.append(EOL + "    </sequenceFlow>" + EOL);
            } else {
                xmlDump.append("/>" + EOL);
            }
        } else {
            xmlDump.append("/>" + EOL);
        }
    }

    public static String getUniqueNodeId(Node node) {
        String result = (String)node.getMetaData().get("UniqueId");
        if (result != null) {
            return result;
        }
        result = node.getId() + "";
        NodeContainer nodeContainer = node.getNodeContainer();
        while (nodeContainer instanceof CompositeNode) {
            CompositeNode composite = (CompositeNode)nodeContainer;
            result = composite.getId() + "-" + result;
            nodeContainer = composite.getNodeContainer();
        }
        return "_" + result;
    }

    private void visitConnectionsDi(Node[] nodes, StringBuilder xmlDump) {
        ArrayList connections = new ArrayList();
        for (Node node : nodes) {
            for (List connectionList : node.getIncomingConnections().values()) {
                connections.addAll(connectionList);
            }
            if (!(node instanceof CompositeNode)) continue;
            this.visitConnectionsDi(((CompositeNode)node).getNodes(), xmlDump);
        }
        for (Connection connection : connections) {
            String[] points;
            String bendpoints = (String)connection.getMetaData().get("bendpoints");
            xmlDump.append("    <di:sequenceFlowConnector sequenceFlowRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId(connection.getFrom()) + "-" + XmlBPMNProcessDumper.getUniqueNodeId(connection.getTo()) + "\" " + "sourceRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId(connection.getFrom()) + "_gui\" " + "targetRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId(connection.getTo()) + "_gui\" ");
            if (bendpoints == null) {
                xmlDump.append("/>" + EOL);
                continue;
            }
            xmlDump.append(">" + EOL);
            bendpoints = bendpoints.substring(1, bendpoints.length() - 1);
            for (String point : points = bendpoints.split(";")) {
                String[] coords = point.split(",");
                if (coords.length != 2) continue;
                xmlDump.append("      <di:bendpoint x=\"" + coords[0] + "\" y=\"" + coords[1] + "\" />" + EOL);
            }
            xmlDump.append("    </di:sequenceFlowConnector>" + EOL);
        }
    }
}

