/*
 * Decompiled with CFR 0.152.
 */
package org.drools.bpmn2.legacy.beta1.di;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.bpmn2.core.Definitions;
import org.drools.bpmn2.legacy.beta1.XmlBPMNProcessDumper;
import org.drools.bpmn2.legacy.beta1.di.SequenceFlowConnectorHandler;
import org.drools.bpmn2.legacy.beta1.di.ShapeHandler;
import org.drools.compiler.xml.ProcessBuildData;
import org.drools.definition.process.Connection;
import org.drools.definition.process.Node;
import org.drools.definition.process.Process;
import org.drools.ruleflow.core.RuleFlowProcess;
import org.drools.workflow.core.impl.ConnectionImpl;
import org.drools.xml.BaseAbstractHandler;
import org.drools.xml.ExtensibleXmlParser;
import org.drools.xml.Handler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessDiagramHandler
extends BaseAbstractHandler
implements Handler {
    public ProcessDiagramHandler() {
        this.initValidParents();
        this.initValidPeers();
        this.allowNesting = false;
    }

    protected void initValidParents() {
        this.validParents = new HashSet();
        this.validParents.add(Definitions.class);
    }

    protected void initValidPeers() {
        this.validPeers = new HashSet();
        this.validPeers.add(Process.class);
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        String processRef = attrs.getValue("processRef");
        ProcessInfo info = new ProcessInfo(processRef);
        return info;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        parser.endElementBuilder();
        ProcessInfo processInfo = (ProcessInfo)parser.getCurrent();
        RuleFlowProcess process = (RuleFlowProcess)((ProcessBuildData)parser.getData()).getProcess();
        for (ShapeHandler.NodeInfo nodeInfo : processInfo.getNodeInfos().values()) {
            boolean found = false;
            for (Node node : process.getNodes()) {
                String id = XmlBPMNProcessDumper.getUniqueNodeId(node);
                if (!nodeInfo.getNodeRef().equals(id)) continue;
                found = true;
                ((org.drools.workflow.core.Node)node).setMetaData("x", (Object)nodeInfo.getX());
                ((org.drools.workflow.core.Node)node).setMetaData("y", (Object)nodeInfo.getY());
                ((org.drools.workflow.core.Node)node).setMetaData("width", (Object)nodeInfo.getWidth());
                ((org.drools.workflow.core.Node)node).setMetaData("height", (Object)nodeInfo.getHeight());
                break;
            }
            if (found) continue;
            throw new IllegalArgumentException("Could not find node " + nodeInfo.getNodeRef());
        }
        for (SequenceFlowConnectorHandler.ConnectionInfo connectionInfo : processInfo.getConnectionInfos()) {
            if (connectionInfo.getBendpoints() == null) continue;
            ShapeHandler.NodeInfo sourceNodeInfo = processInfo.getNodeInfo(connectionInfo.getSourceRef());
            if (sourceNodeInfo == null) {
                throw new IllegalArgumentException("Could not find sourceRef for connection info: " + connectionInfo.getSourceRef());
            }
            ShapeHandler.NodeInfo targetNodeInfo = processInfo.getNodeInfo(connectionInfo.getTargetRef());
            if (targetNodeInfo == null) {
                throw new IllegalArgumentException("Could not find sourceRef for connection info: " + connectionInfo.getTargetRef());
            }
            Node sourceNode = null;
            for (Node node : process.getNodes()) {
                String id = XmlBPMNProcessDumper.getUniqueNodeId(node);
                if (!sourceNodeInfo.getNodeRef().equals(id)) continue;
                sourceNode = node;
                break;
            }
            if (sourceNode == null) {
                throw new IllegalArgumentException("Could not find node for nodeRef: " + sourceNodeInfo.getNodeRef());
            }
            boolean found = false;
            for (List outgoingConnections : sourceNode.getOutgoingConnections().values()) {
                for (Connection connection : outgoingConnections) {
                    if (!targetNodeInfo.getNodeRef().equals(XmlBPMNProcessDumper.getUniqueNodeId(connection.getTo()))) continue;
                    ((ConnectionImpl)connection).setMetaData("bendpoints", (Object)connectionInfo.getBendpoints());
                    found = true;
                    break;
                }
                if (!found) continue;
                break;
            }
            if (found) continue;
            throw new IllegalArgumentException("Could not find connection from  " + sourceNodeInfo.getNodeRef() + " to " + targetNodeInfo.getNodeRef());
        }
        return processInfo;
    }

    public Class<?> generateNodeFor() {
        return ProcessInfo.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProcessInfo {
        private String processRef;
        private Map<String, ShapeHandler.NodeInfo> nodeInfos = new HashMap<String, ShapeHandler.NodeInfo>();
        private List<SequenceFlowConnectorHandler.ConnectionInfo> connectionInfos = new ArrayList<SequenceFlowConnectorHandler.ConnectionInfo>();

        public ProcessInfo(String processRef) {
            this.processRef = processRef;
        }

        public String getProcessRef() {
            return this.processRef;
        }

        public void addNodeInfo(ShapeHandler.NodeInfo nodeInfo) {
            this.nodeInfos.put(nodeInfo.getId(), nodeInfo);
        }

        public Map<String, ShapeHandler.NodeInfo> getNodeInfos() {
            return this.nodeInfos;
        }

        public ShapeHandler.NodeInfo getNodeInfo(String nodeRef) {
            return this.nodeInfos.get(nodeRef);
        }

        public void addConnectionInfo(SequenceFlowConnectorHandler.ConnectionInfo connectionInfo) {
            this.connectionInfos.add(connectionInfo);
        }

        public List<SequenceFlowConnectorHandler.ConnectionInfo> getConnectionInfos() {
            return this.connectionInfos;
        }
    }
}

