/*
 * Decompiled with CFR 0.152.
 */
package org.drools.bpmn2.xml;

import org.drools.bpmn2.xml.AbstractNodeHandler;
import org.drools.bpmn2.xml.XmlBPMNProcessDumper;
import org.drools.compiler.xml.XmlDumper;
import org.drools.process.core.event.EventTypeFilter;
import org.drools.workflow.core.Node;
import org.drools.workflow.core.node.EventNode;
import org.xml.sax.Attributes;

public class EventNodeHandler
extends AbstractNodeHandler {
    protected Node createNode(Attributes attrs) {
        throw new IllegalArgumentException("Reading in should be handled by intermediate catch event handler");
    }

    public Class generateNodeFor() {
        return EventNode.class;
    }

    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        EventNode eventNode = (EventNode)node;
        String attachedTo = (String)eventNode.getMetaData("AttachedTo");
        if (attachedTo == null) {
            this.writeNode("intermediateCatchEvent", (Node)eventNode, xmlDump, metaDataType);
            xmlDump.append(">" + EOL);
            if (eventNode.getVariableName() != null) {
                xmlDump.append("      <dataOutput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.drools.definition.process.Node)eventNode) + "_Output\" name=\"event\" />" + EOL);
                xmlDump.append("      <dataOutputAssociation>" + EOL);
                xmlDump.append("      <sourceRef>" + XmlBPMNProcessDumper.getUniqueNodeId((org.drools.definition.process.Node)eventNode) + "_Output</sourceRef>" + EOL + "      <targetRef>" + XmlDumper.replaceIllegalChars((String)eventNode.getVariableName()) + "</targetRef>" + EOL);
                xmlDump.append("      </dataOutputAssociation>" + EOL);
                xmlDump.append("      <outputSet>" + EOL);
                xmlDump.append("        <dataOutputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((org.drools.definition.process.Node)eventNode) + "_Output</dataOutputRefs>" + EOL);
                xmlDump.append("      </outputSet>" + EOL);
            }
            if (eventNode.getEventFilters().size() > 0) {
                String type = ((EventTypeFilter)eventNode.getEventFilters().get(0)).getType();
                if (type.startsWith("Message-")) {
                    type = type.substring(8);
                    xmlDump.append("      <messageEventDefinition messageRef=\"" + XmlDumper.replaceIllegalChars((String)type) + "\"/>" + EOL);
                } else {
                    xmlDump.append("      <signalEventDefinition signalRef=\"" + XmlDumper.replaceIllegalChars((String)type) + "\"/>" + EOL);
                }
            }
            this.endNode("intermediateCatchEvent", xmlDump);
        } else {
            String type = ((EventTypeFilter)eventNode.getEventFilters().get(0)).getType();
            if (type.startsWith("Escalation-")) {
                type = type.substring(attachedTo.length() + 12);
                boolean cancelActivity = (Boolean)eventNode.getMetaData("CancelActivity");
                this.writeNode("boundaryEvent", (Node)eventNode, xmlDump, metaDataType);
                xmlDump.append("attachedToRef=\"" + attachedTo + "\" ");
                if (!cancelActivity) {
                    xmlDump.append("cancelActivity=\"false\" ");
                }
                xmlDump.append(">" + EOL);
                xmlDump.append("      <escalationEventDefinition escalationRef=\"" + XmlDumper.replaceIllegalChars((String)type) + "\" />" + EOL);
                this.endNode("boundaryEvent", xmlDump);
            } else if (type.startsWith("Error-")) {
                type = type.substring(attachedTo.length() + 7);
                this.writeNode("boundaryEvent", (Node)eventNode, xmlDump, metaDataType);
                xmlDump.append("attachedToRef=\"" + attachedTo + "\" ");
                xmlDump.append(">" + EOL);
                xmlDump.append("      <errorEventDefinition errorRef=\"" + XmlDumper.replaceIllegalChars((String)type) + "\" />" + EOL);
                this.endNode("boundaryEvent", xmlDump);
            } else if (type.startsWith("Timer-")) {
                type = type.substring(attachedTo.length() + 7);
                boolean cancelActivity = (Boolean)eventNode.getMetaData("CancelActivity");
                this.writeNode("boundaryEvent", (Node)eventNode, xmlDump, metaDataType);
                xmlDump.append("attachedToRef=\"" + attachedTo + "\" ");
                if (!cancelActivity) {
                    xmlDump.append("cancelActivity=\"false\" ");
                }
                xmlDump.append(">" + EOL);
                xmlDump.append("      <timerEventDefinition>" + EOL + "        <timeCycle xs:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)((String)eventNode.getMetaData("TimeCycle"))) + "</timeCycle>" + EOL + "      </timerEventDefinition>" + EOL);
                this.endNode("boundaryEvent", xmlDump);
            } else if (type.startsWith("Compensate-")) {
                type = type.substring(attachedTo.length() + 7);
                this.writeNode("boundaryEvent", (Node)eventNode, xmlDump, metaDataType);
                xmlDump.append("attachedToRef=\"" + attachedTo + "\" ");
                xmlDump.append(">" + EOL);
                xmlDump.append("      <compensateEventDefinition/>" + EOL);
                this.endNode("boundaryEvent", xmlDump);
            }
        }
    }
}

