/*
 * Decompiled with CFR 0.152.
 */
package org.drools.bpmn2.xml;

import java.util.ArrayList;
import java.util.HashSet;
import org.drools.bpmn2.core.Lane;
import org.drools.definition.process.WorkflowProcess;
import org.drools.ruleflow.core.RuleFlowProcess;
import org.drools.xml.BaseAbstractHandler;
import org.drools.xml.ExtensibleXmlParser;
import org.drools.xml.Handler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaneHandler
extends BaseAbstractHandler
implements Handler {
    public static final String LANES = "BPMN.Lanes";

    public LaneHandler() {
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(RuleFlowProcess.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        String id = attrs.getValue("id");
        String name = attrs.getValue("name");
        WorkflowProcess process = (WorkflowProcess)parser.getParent();
        ArrayList<Lane> lanes = (ArrayList<Lane>)((RuleFlowProcess)process).getMetaData(LANES);
        if (lanes == null) {
            lanes = new ArrayList<Lane>();
            ((RuleFlowProcess)process).setMetaData(LANES, lanes);
        }
        Lane lane = new Lane(id);
        lane.setName(name);
        lanes.add(lane);
        return lane;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        Lane lane = (Lane)parser.getCurrent();
        for (Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"flowNodeRef".equals(nodeName)) continue;
            String flowElementRef = xmlNode.getTextContent();
            lane.addFlowElement(flowElementRef);
        }
        return lane;
    }

    public Class<?> generateNodeFor() {
        return Lane.class;
    }
}

