/*
 * Decompiled with CFR 0.152.
 */
package org.drools.bpmn2.xml;

import java.util.List;
import java.util.Map;
import org.drools.bpmn2.core.Message;
import org.drools.bpmn2.xml.AbstractNodeHandler;
import org.drools.compiler.xml.ProcessBuildData;
import org.drools.process.core.event.EventFilter;
import org.drools.process.core.event.EventTypeFilter;
import org.drools.workflow.core.Node;
import org.drools.workflow.core.node.ConstraintTrigger;
import org.drools.workflow.core.node.EventTrigger;
import org.drools.workflow.core.node.StartNode;
import org.drools.workflow.core.node.Trigger;
import org.drools.xml.ExtensibleXmlParser;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class StartEventHandler
extends AbstractNodeHandler {
    protected Node createNode(Attributes attrs) {
        return new StartNode();
    }

    public Class generateNodeFor() {
        return StartNode.class;
    }

    protected void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        StartNode startNode = (StartNode)node;
        block0: for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            EventTrigger trigger;
            String nodeName = xmlNode.getNodeName();
            if ("dataOutputAssociation".equals(nodeName)) {
                this.readDataOutputAssociation(xmlNode, startNode);
                continue;
            }
            if ("conditionalEventDefinition".equals(nodeName)) {
                String constraint = null;
                for (org.w3c.dom.Node subNode = xmlNode.getFirstChild(); subNode != null; subNode = subNode.getNextSibling()) {
                    String subnodeName = subNode.getNodeName();
                    if (!"condition".equals(subnodeName)) continue;
                    constraint = xmlNode.getTextContent();
                    break;
                }
                ConstraintTrigger trigger2 = new ConstraintTrigger();
                trigger2.setConstraint(constraint);
                startNode.addTrigger((Trigger)trigger2);
                break;
            }
            if ("signalEventDefinition".equals(nodeName)) {
                String type = ((Element)xmlNode).getAttribute("signalRef");
                if (type == null || type.trim().length() <= 0) continue;
                EventTrigger trigger3 = new EventTrigger();
                EventTypeFilter eventFilter = new EventTypeFilter();
                eventFilter.setType(type);
                trigger3.addEventFilter((EventFilter)eventFilter);
                String mapping = (String)startNode.getMetaData("TriggerMapping");
                if (mapping != null) {
                    trigger3.addInMapping(mapping, "event");
                }
                startNode.addTrigger((Trigger)trigger3);
                continue;
            }
            if ("messageEventDefinition".equals(nodeName)) {
                String messageRef = ((Element)xmlNode).getAttribute("messageRef");
                Map messages = (Map)((ProcessBuildData)parser.getData()).getMetaData("Messages");
                if (messages == null) {
                    throw new IllegalArgumentException("No messages found");
                }
                Message message = (Message)messages.get(messageRef);
                if (message == null) {
                    throw new IllegalArgumentException("Could not find message " + messageRef);
                }
                startNode.setMetaData("MessageType", (Object)message.getType());
                trigger = new EventTrigger();
                EventTypeFilter eventFilter = new EventTypeFilter();
                eventFilter.setType("Message-" + messageRef);
                trigger.addEventFilter((EventFilter)eventFilter);
                String mapping = (String)startNode.getMetaData("TriggerMapping");
                if (mapping != null) {
                    trigger.addInMapping(mapping, "event");
                }
                startNode.addTrigger((Trigger)trigger);
                continue;
            }
            if (!"timerEventDefinition".equals(nodeName)) continue;
            org.w3c.dom.Node subNode = xmlNode.getFirstChild();
            while (subNode instanceof Element) {
                String period;
                String subNodeName = subNode.getNodeName();
                if ("timeCycle".equals(subNodeName) && (period = subNode.getTextContent()) != null && period.trim().length() > 0) {
                    trigger = new ConstraintTrigger();
                    trigger.setConstraint("");
                    trigger.setHeader("timer (int:" + period + " " + period + ")");
                    startNode.addTrigger((Trigger)trigger);
                    continue block0;
                }
                subNode = subNode.getNextSibling();
            }
        }
    }

    protected void readDataOutputAssociation(org.w3c.dom.Node xmlNode, StartNode startNode) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        if ("sourceRef".equals(subNode.getNodeName())) {
            subNode = subNode.getNextSibling();
        }
        String to = subNode.getTextContent();
        startNode.setMetaData("TriggerMapping", (Object)to);
    }

    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        StartNode startNode = (StartNode)node;
        this.writeNode("startEvent", (Node)startNode, xmlDump, metaDataType);
        List triggers = startNode.getTriggers();
        if (triggers != null) {
            xmlDump.append(">" + EOL);
            if (triggers.size() > 1) {
                throw new IllegalArgumentException("Multiple start triggers not supported");
            }
            Trigger trigger = (Trigger)triggers.get(0);
            if (trigger instanceof ConstraintTrigger) {
                ConstraintTrigger constraintTrigger = (ConstraintTrigger)trigger;
                if (constraintTrigger.getHeader() == null) {
                    xmlDump.append("      <conditionalEventDefinition>" + EOL);
                    xmlDump.append("        <condition xs:type=\"tFormalExpression\" language=\"http://www.jboss.org/drools/rule\">" + constraintTrigger.getConstraint() + "</condition>" + EOL);
                    xmlDump.append("      </conditionalEventDefinition>" + EOL);
                } else {
                    String header = constraintTrigger.getHeader();
                    int lenght = (header.length() - 13) / 2;
                    String period = header.substring(11, 11 + lenght);
                    xmlDump.append("      <timerEventDefinition>" + EOL);
                    xmlDump.append("        <timeCycle xs:type=\"tFormalExpression\">" + period + "</timeCycle>" + EOL);
                    xmlDump.append("      </timerEventDefinition>" + EOL);
                }
            } else if (trigger instanceof EventTrigger) {
                String type;
                EventTrigger eventTrigger = (EventTrigger)trigger;
                if (!trigger.getInMappings().isEmpty()) {
                    String mapping = (String)eventTrigger.getInMappings().keySet().iterator().next();
                    xmlDump.append("      <dataOutput id=\"_" + startNode.getId() + "_Output\" />" + EOL + "      <dataOutputAssociation>" + EOL + "        <sourceRef>_" + startNode.getId() + "_Output</sourceRef>" + EOL + "        <targetRef>" + mapping + "</targetRef>" + EOL + "      </dataOutputAssociation>" + EOL + "      <outputSet>" + EOL + "        <dataOutputRefs>_" + startNode.getId() + "_Output</dataOutputRefs>" + EOL + "      </outputSet>" + EOL);
                }
                if ((type = ((EventTypeFilter)eventTrigger.getEventFilters().get(0)).getType()).startsWith("Message-")) {
                    type = type.substring(8);
                    xmlDump.append("      <messageEventDefinition messageRef=\"" + type + "\"/>" + EOL);
                } else {
                    xmlDump.append("      <signalEventDefinition signalRef=\"" + type + "\" />" + EOL);
                }
            } else {
                throw new IllegalArgumentException("Unsupported trigger type " + trigger);
            }
            this.endNode("startEvent", xmlDump);
        } else {
            this.endNode(xmlDump);
        }
    }
}

