/*
 * Decompiled with CFR 0.152.
 */
package org.drools.bpmn2.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.bpmn2.xml.AbstractNodeHandler;
import org.drools.bpmn2.xml.BPMNSemanticModule;
import org.drools.compiler.xml.XmlDumper;
import org.drools.definition.process.Connection;
import org.drools.definition.process.Node;
import org.drools.definition.process.NodeContainer;
import org.drools.process.core.ContextContainer;
import org.drools.process.core.Process;
import org.drools.process.core.Work;
import org.drools.process.core.context.swimlane.Swimlane;
import org.drools.process.core.context.swimlane.SwimlaneContext;
import org.drools.process.core.context.variable.Variable;
import org.drools.process.core.context.variable.VariableScope;
import org.drools.process.core.datatype.impl.type.ObjectDataType;
import org.drools.process.core.event.EventTypeFilter;
import org.drools.workflow.core.Constraint;
import org.drools.workflow.core.WorkflowProcess;
import org.drools.workflow.core.impl.DroolsConsequenceAction;
import org.drools.workflow.core.node.ActionNode;
import org.drools.workflow.core.node.CompositeNode;
import org.drools.workflow.core.node.EndNode;
import org.drools.workflow.core.node.EventNode;
import org.drools.workflow.core.node.EventTrigger;
import org.drools.workflow.core.node.FaultNode;
import org.drools.workflow.core.node.ForEachNode;
import org.drools.workflow.core.node.HumanTaskNode;
import org.drools.workflow.core.node.Join;
import org.drools.workflow.core.node.Split;
import org.drools.workflow.core.node.StartNode;
import org.drools.workflow.core.node.Trigger;
import org.drools.workflow.core.node.WorkItemNode;
import org.drools.xml.Handler;
import org.drools.xml.SemanticModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlBPMNProcessDumper {
    public static final String JAVA_LANGUAGE = "http://www.java.com/java";
    public static final String RULE_LANGUAGE = "http://www.jboss.org/drools/rule";
    public static final String XPATH_LANGUAGE = "http://www.w3.org/1999/XPath";
    public static final int NO_META_DATA = 0;
    public static final int META_DATA_AS_NODE_PROPERTY = 1;
    public static final int META_DATA_USING_DI = 2;
    public static XmlBPMNProcessDumper INSTANCE = new XmlBPMNProcessDumper();
    private static final String EOL = System.getProperty("line.separator");
    private SemanticModule semanticModule = new BPMNSemanticModule();
    private int metaDataType = 2;

    private XmlBPMNProcessDumper() {
    }

    public String dump(org.drools.definition.process.WorkflowProcess process) {
        return this.dump(process, 2);
    }

    public String dump(org.drools.definition.process.WorkflowProcess process, boolean includeMeta) {
        return this.dump(process, 1);
    }

    public String dump(org.drools.definition.process.WorkflowProcess process, int metaDataType) {
        StringBuilder xmlDump = new StringBuilder();
        this.visitProcess(process, xmlDump, metaDataType);
        return xmlDump.toString();
    }

    public int getMetaDataType() {
        return this.metaDataType;
    }

    public void setMetaDataType(int metaDataType) {
        this.metaDataType = metaDataType;
    }

    protected void visitProcess(org.drools.definition.process.WorkflowProcess process, StringBuilder xmlDump, int metaDataType) {
        String packageName;
        String targetNamespace = (String)process.getMetaData().get("TargetNamespace");
        if (targetNamespace == null) {
            targetNamespace = "http://www.jboss.org/drools";
        }
        xmlDump.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?> " + EOL + "<definitions id=\"Definition\"" + EOL + "             targetNamespace=\"" + targetNamespace + "\"" + EOL + "             typeLanguage=\"http://www.java.com/javaTypes\"" + EOL + "             expressionLanguage=\"http://www.mvel.org/2.0\"" + EOL + "             xmlns=\"http://www.omg.org/spec/BPMN/20100524/MODEL\"" + EOL + "             xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"" + EOL + "             xs:schemaLocation=\"http://www.omg.org/spec/BPMN/20100524/MODEL BPMN20.xsd\"" + EOL + (metaDataType == 1 ? "             xmlns:g=\"http://www.jboss.org/drools/flow/gpd\"" + EOL : "") + (metaDataType == 2 ? "             xmlns:bpmndi=\"http://www.omg.org/spec/BPMN/20100524/DI\"" + EOL + "             xmlns:dc=\"http://www.omg.org/spec/DD/20100524/DC\"" + EOL + "             xmlns:di=\"http://www.omg.org/spec/DD/20100524/DI\"" + EOL : "") + "             xmlns:tns=\"http://www.jboss.org/drools\">" + EOL + EOL);
        VariableScope variableScope = (VariableScope)((Process)process).getDefaultContext("VariableScope");
        this.visitVariableScope(variableScope, "_", xmlDump);
        this.visitSubVariableScopes(process.getNodes(), xmlDump);
        this.visitInterfaces(process.getNodes(), xmlDump);
        this.visitEscalations(process.getNodes(), xmlDump, new ArrayList<String>());
        this.visitErrors(process.getNodes(), xmlDump, new ArrayList<String>());
        xmlDump.append("  <process processType=\"Private\" isExecutable=\"true\" ");
        if (process.getId() != null) {
            xmlDump.append("id=\"" + XmlDumper.replaceIllegalChars((String)process.getId()) + "\" ");
        }
        if (process.getName() != null) {
            xmlDump.append("name=\"" + XmlDumper.replaceIllegalChars((String)process.getName()) + "\" ");
        }
        if ((packageName = process.getPackageName()) != null && !"org.drools.bpmn2".equals(packageName)) {
            xmlDump.append("tns:packageName=\"" + XmlDumper.replaceIllegalChars((String)packageName) + "\" ");
        }
        xmlDump.append(">" + EOL + EOL);
        this.visitLanes(process, xmlDump);
        this.visitHeader(process, xmlDump, metaDataType);
        this.visitNodes(process, xmlDump, metaDataType);
        this.visitConnections(process.getNodes(), xmlDump, metaDataType);
        xmlDump.append("  </process>" + EOL + EOL);
        if (metaDataType == 2) {
            xmlDump.append("  <bpmndi:BPMNDiagram>" + EOL + "    <bpmndi:BPMNPlane bpmnElement=\"" + XmlDumper.replaceIllegalChars((String)process.getId()) + "\" >" + EOL);
            this.visitNodesDi(process.getNodes(), xmlDump);
            this.visitConnectionsDi(process.getNodes(), xmlDump);
            xmlDump.append("    </bpmndi:BPMNPlane>" + EOL + "  </bpmndi:BPMNDiagram>" + EOL + EOL);
        }
        xmlDump.append("</definitions>");
    }

    private void visitVariableScope(VariableScope variableScope, String prefix, StringBuilder xmlDump) {
        if (variableScope != null && !variableScope.getVariables().isEmpty()) {
            for (Variable variable : variableScope.getVariables()) {
                xmlDump.append("  <itemDefinition id=\"" + XmlDumper.replaceIllegalChars((String)(prefix + variable.getName())) + "Item\" ");
                if (variable.getType() != null) {
                    xmlDump.append("structureRef=\"" + XmlDumper.replaceIllegalChars((String)variable.getType().getStringType()) + "\" ");
                }
                xmlDump.append("/>" + EOL);
            }
            xmlDump.append(EOL);
        }
    }

    private void visitSubVariableScopes(Node[] nodes, StringBuilder xmlDump) {
        for (Node node : nodes) {
            VariableScope variableScope;
            if (node instanceof ContextContainer && (variableScope = (VariableScope)((ContextContainer)node).getDefaultContext("VariableScope")) != null) {
                this.visitVariableScope(variableScope, XmlBPMNProcessDumper.getUniqueNodeId(node) + "-", xmlDump);
            }
            if (!(node instanceof NodeContainer)) continue;
            this.visitSubVariableScopes(((NodeContainer)node).getNodes(), xmlDump);
        }
    }

    private void visitLanes(org.drools.definition.process.WorkflowProcess process, StringBuilder xmlDump) {
        Collection swimlanes = ((SwimlaneContext)((WorkflowProcess)process).getDefaultContext("SwimlaneScope")).getSwimlanes();
        if (!swimlanes.isEmpty()) {
            xmlDump.append("    <laneSet>" + EOL);
            for (Swimlane swimlane : swimlanes) {
                xmlDump.append("      <lane name=\"" + XmlDumper.replaceIllegalChars((String)swimlane.getName()) + "\" >" + EOL);
                this.visitLane((NodeContainer)process, swimlane.getName(), xmlDump);
                xmlDump.append("      </lane>" + EOL);
            }
            xmlDump.append("    </laneSet>" + EOL);
        }
    }

    private void visitLane(NodeContainer container, String lane, StringBuilder xmlDump) {
        for (Node node : container.getNodes()) {
            String swimlane;
            if (node instanceof HumanTaskNode) {
                swimlane = ((HumanTaskNode)node).getSwimlane();
                if (lane.equals(swimlane)) {
                    xmlDump.append("        <flowNodeRef>" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "</flowNodeRef>" + EOL);
                }
            } else {
                swimlane = (String)node.getMetaData().get("Lane");
                if (lane.equals(swimlane)) {
                    xmlDump.append("        <flowNodeRef>" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "</flowNodeRef>" + EOL);
                }
            }
            if (!(node instanceof NodeContainer)) continue;
            this.visitLane((NodeContainer)node, lane, xmlDump);
        }
    }

    protected void visitHeader(org.drools.definition.process.WorkflowProcess process, StringBuilder xmlDump, int metaDataType) {
        VariableScope variableScope = (VariableScope)((Process)process).getDefaultContext("VariableScope");
        if (variableScope != null) {
            XmlBPMNProcessDumper.visitVariables(variableScope.getVariables(), xmlDump);
        }
    }

    public static void visitVariables(List<Variable> variables, StringBuilder xmlDump) {
        if (!variables.isEmpty()) {
            xmlDump.append("    <!-- process variables -->" + EOL);
            for (Variable variable : variables) {
                if (variable.getMetaData("DataObject") != null) continue;
                xmlDump.append("    <property id=\"" + XmlDumper.replaceIllegalChars((String)variable.getName()) + "\" ");
                if (variable.getType() != null) {
                    xmlDump.append("itemSubjectRef=\"_" + XmlDumper.replaceIllegalChars((String)variable.getName()) + "Item\"");
                }
                xmlDump.append("/>" + EOL);
            }
            for (Variable variable : variables) {
                if (variable.getMetaData("DataObject") == null) continue;
                xmlDump.append("    <dataObject id=\"" + XmlDumper.replaceIllegalChars((String)variable.getName()) + "\" ");
                if (variable.getType() != null) {
                    xmlDump.append("itemSubjectRef=\"_" + XmlDumper.replaceIllegalChars((String)variable.getName()) + "Item\"");
                }
                xmlDump.append("/>" + EOL);
            }
            xmlDump.append(EOL);
        }
    }

    protected void visitInterfaces(Node[] nodes, StringBuilder xmlDump) {
        for (Node node : nodes) {
            String messageType;
            String messageType2;
            if (node instanceof WorkItemNode) {
                Work work = ((WorkItemNode)node).getWork();
                if (work != null) {
                    if ("Service Task".equals(work.getName())) {
                        String parameterType;
                        String operationName;
                        String interfaceName = (String)work.getParameter("Interface");
                        if (interfaceName == null) {
                            interfaceName = "";
                        }
                        if ((operationName = (String)work.getParameter("Operation")) == null) {
                            operationName = "";
                        }
                        if ((parameterType = (String)work.getParameter("ParameterType")) == null) {
                            parameterType = "";
                        }
                        xmlDump.append("  <itemDefinition id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_InMessageType\" structureRef=\"" + parameterType + "\"/>" + EOL + "  <message id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_InMessage\" itemRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_InMessageType\" />" + EOL + "  <interface id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_ServiceInterface\" name=\"" + interfaceName + "\">" + EOL + "    <operation id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_ServiceOperation\" name=\"" + operationName + "\">" + EOL + "      <inMessageRef>" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_InMessage</inMessageRef>" + EOL + "    </operation>" + EOL + "  </interface>" + EOL + EOL);
                    } else if ("Send Task".equals(work.getName())) {
                        messageType2 = (String)work.getParameter("MessageType");
                        if (messageType2 == null) {
                            messageType2 = "";
                        }
                        xmlDump.append("  <itemDefinition id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_MessageType\" structureRef=\"" + XmlDumper.replaceIllegalChars((String)messageType2) + "\"/>" + EOL + "  <message id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_Message\" itemRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_MessageType\" />" + EOL + EOL);
                    } else if ("Receive Task".equals(work.getName())) {
                        String messageId = (String)work.getParameter("MessageId");
                        String messageType3 = (String)work.getParameter("MessageType");
                        if (messageType3 == null) {
                            messageType3 = "";
                        }
                        xmlDump.append("  <itemDefinition id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_MessageType\" structureRef=\"" + XmlDumper.replaceIllegalChars((String)messageType3) + "\"/>" + EOL + "  <message id=\"" + messageId + "\" itemRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_MessageType\" />" + EOL + EOL);
                    }
                }
            } else if (node instanceof EndNode) {
                messageType = (String)node.getMetaData().get("MessageType");
                if (messageType != null) {
                    xmlDump.append("  <itemDefinition id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_MessageType\" structureRef=\"" + XmlDumper.replaceIllegalChars((String)messageType) + "\"/>" + EOL + "  <message id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_Message\" itemRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_MessageType\" />" + EOL + EOL);
                }
            } else if (node instanceof ActionNode) {
                messageType = (String)node.getMetaData().get("MessageType");
                if (messageType != null) {
                    xmlDump.append("  <itemDefinition id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_MessageType\" structureRef=\"" + XmlDumper.replaceIllegalChars((String)messageType) + "\"/>" + EOL + "  <message id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_Message\" itemRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "_MessageType\" />" + EOL + EOL);
                }
            } else if (node instanceof EventNode) {
                String messageRef;
                if (node.getMetaData().get("AttachedTo") == null && (messageRef = ((EventTypeFilter)((EventNode)node).getEventFilters().get(0)).getType()).startsWith("Message-")) {
                    messageRef = messageRef.substring(8);
                    messageType2 = (String)node.getMetaData().get("MessageType");
                    xmlDump.append("  <itemDefinition id=\"" + XmlDumper.replaceIllegalChars((String)messageRef) + "Type\" structureRef=\"" + XmlDumper.replaceIllegalChars((String)messageType2) + "\"/>" + EOL + "  <message id=\"" + XmlDumper.replaceIllegalChars((String)messageRef) + "\" itemRef=\"" + XmlDumper.replaceIllegalChars((String)messageRef) + "Type\" />" + EOL + EOL);
                }
            } else if (node instanceof StartNode) {
                String eventType;
                Trigger trigger;
                StartNode startNode = (StartNode)node;
                if (startNode.getTriggers() != null && !startNode.getTriggers().isEmpty() && (trigger = (Trigger)startNode.getTriggers().get(0)) instanceof EventTrigger && (eventType = ((EventTypeFilter)((EventTrigger)trigger).getEventFilters().get(0)).getType()).startsWith("Message-")) {
                    eventType = eventType.substring(8);
                    String messageType4 = (String)node.getMetaData().get("MessageType");
                    xmlDump.append("  <itemDefinition id=\"" + XmlDumper.replaceIllegalChars((String)eventType) + "Type\" structureRef=\"" + XmlDumper.replaceIllegalChars((String)messageType4) + "\"/>" + EOL + "  <message id=\"" + XmlDumper.replaceIllegalChars((String)eventType) + "\" itemRef=\"" + XmlDumper.replaceIllegalChars((String)eventType) + "Type\" />" + EOL + EOL);
                }
            } else if (node instanceof ForEachNode) {
                ForEachNode forEachNode = (ForEachNode)node;
                String type = null;
                if (forEachNode.getVariableType() instanceof ObjectDataType) {
                    type = ((ObjectDataType)forEachNode.getVariableType()).getClassName();
                }
                xmlDump.append("  <itemDefinition id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((Node)forEachNode) + "_multiInstanceItemType\" " + (type == null ? "" : "structureRef=\"" + XmlDumper.replaceIllegalChars((String)type) + "\"") + "/>" + EOL + EOL);
            }
            if (!(node instanceof CompositeNode)) continue;
            this.visitInterfaces(((CompositeNode)node).getNodes(), xmlDump);
        }
    }

    protected void visitEscalations(Node[] nodes, StringBuilder xmlDump, List<String> escalations) {
        for (Node node : nodes) {
            EventNode eventNode;
            String type;
            if (node instanceof FaultNode) {
                String escalationCode;
                FaultNode faultNode = (FaultNode)node;
                if (!faultNode.isTerminateParent() && !escalations.contains(escalationCode = faultNode.getFaultName())) {
                    escalations.add(escalationCode);
                    xmlDump.append("  <escalation id=\"" + XmlDumper.replaceIllegalChars((String)escalationCode) + "\" escalationCode=\"" + XmlDumper.replaceIllegalChars((String)escalationCode) + "\" />" + EOL);
                }
            } else if (node instanceof ActionNode) {
                String type2;
                String s;
                ActionNode actionNode = (ActionNode)node;
                DroolsConsequenceAction action = (DroolsConsequenceAction)actionNode.getAction();
                if (action != null && (s = action.getConsequence()).startsWith("org.drools.process.instance.context.exception.ExceptionScopeInstance scopeInstance = (org.drools.process.instance.context.exception.ExceptionScopeInstance) ((org.drools.workflow.instance.NodeInstance) kcontext.getNodeInstance()).resolveContextInstance(org.drools.process.core.context.exception.ExceptionScope.EXCEPTION_SCOPE, \"") && !escalations.contains(type2 = (s = s.substring(327)).substring(0, s.indexOf("\"")))) {
                    escalations.add(type2);
                    xmlDump.append("  <escalation id=\"" + XmlDumper.replaceIllegalChars((String)type2) + "\" escalationCode=\"" + XmlDumper.replaceIllegalChars((String)type2) + "\" />" + EOL);
                }
            } else if (node instanceof EventNode && (type = (String)(eventNode = (EventNode)node).getMetaData("EscalationEvent")) != null && !escalations.contains(type)) {
                escalations.add(type);
                xmlDump.append("  <escalation id=\"" + XmlDumper.replaceIllegalChars((String)type) + "\" escalationCode=\"" + XmlDumper.replaceIllegalChars((String)type) + "\" />" + EOL);
            }
            if (!(node instanceof CompositeNode)) continue;
            this.visitEscalations(((CompositeNode)node).getNodes(), xmlDump, escalations);
        }
    }

    protected void visitErrors(Node[] nodes, StringBuilder xmlDump, List<String> errors) {
        for (Node node : nodes) {
            EventNode eventNode;
            String type;
            if (node instanceof FaultNode) {
                String errorCode;
                FaultNode faultNode = (FaultNode)node;
                if (faultNode.isTerminateParent() && !errors.contains(errorCode = faultNode.getFaultName())) {
                    errors.add(errorCode);
                    xmlDump.append("  <error id=\"" + XmlDumper.replaceIllegalChars((String)errorCode) + "\" errorCode=\"" + XmlDumper.replaceIllegalChars((String)errorCode) + "\" />" + EOL);
                }
            } else if (node instanceof EventNode && (type = (String)(eventNode = (EventNode)node).getMetaData("ErrorEvent")) != null && !errors.contains(type)) {
                errors.add(type);
                xmlDump.append("  <error id=\"" + XmlDumper.replaceIllegalChars((String)type) + "\" errorCode=\"" + XmlDumper.replaceIllegalChars((String)type) + "\" />" + EOL);
            }
            if (!(node instanceof CompositeNode)) continue;
            this.visitErrors(((CompositeNode)node).getNodes(), xmlDump, errors);
        }
    }

    private void visitNodes(org.drools.definition.process.WorkflowProcess process, StringBuilder xmlDump, int metaDataType) {
        xmlDump.append("    <!-- nodes -->" + EOL);
        for (Node node : process.getNodes()) {
            this.visitNode(node, xmlDump, metaDataType);
        }
        xmlDump.append(EOL);
    }

    public void visitNode(Node node, StringBuilder xmlDump, int metaDataType) {
        Handler handler = this.semanticModule.getHandlerByClass(node.getClass());
        if (handler == null) {
            throw new IllegalArgumentException("Unknown node type: " + node);
        }
        ((AbstractNodeHandler)handler).writeNode((org.drools.workflow.core.Node)node, xmlDump, metaDataType);
    }

    private void visitNodesDi(Node[] nodes, StringBuilder xmlDump) {
        for (Node node : nodes) {
            int offsetY;
            int offsetX;
            Integer x = (Integer)node.getMetaData().get("x");
            Integer y = (Integer)node.getMetaData().get("y");
            Integer width = (Integer)node.getMetaData().get("width");
            Integer height = (Integer)node.getMetaData().get("height");
            if (x == null) {
                x = 0;
            }
            if (y == null) {
                y = 0;
            }
            if (width == null) {
                width = 48;
            }
            if (height == null) {
                height = 48;
            }
            if (node instanceof StartNode || node instanceof EndNode || node instanceof EventNode || node instanceof FaultNode) {
                offsetX = (width - 48) / 2;
                width = 48;
                x = x + offsetX;
                offsetY = (height - 48) / 2;
                y = y + offsetY;
                height = 48;
            } else if (node instanceof Join || node instanceof Split) {
                offsetX = (width - 48) / 2;
                width = 48;
                x = x + offsetX;
                offsetY = (height - 48) / 2;
                y = y + offsetY;
                height = 48;
            }
            xmlDump.append("      <bpmndi:BPMNShape bpmnElement=\"" + XmlBPMNProcessDumper.getUniqueNodeId(node) + "\" >" + EOL + "        <dc:Bounds x=\"" + x + "\" " + "y=\"" + y + "\" " + "width=\"" + width + "\" " + "height=\"" + height + "\" />" + EOL + "      </bpmndi:BPMNShape>" + EOL);
            if (!(node instanceof CompositeNode)) continue;
            this.visitNodesDi(((CompositeNode)node).getNodes(), xmlDump);
        }
    }

    private void visitConnections(Node[] nodes, StringBuilder xmlDump, int metaDataType) {
        xmlDump.append("    <!-- connections -->" + EOL);
        ArrayList connections = new ArrayList();
        for (Node node : nodes) {
            for (List connectionList : node.getIncomingConnections().values()) {
                connections.addAll(connectionList);
            }
        }
        for (Connection connection : connections) {
            this.visitConnection(connection, xmlDump, metaDataType);
        }
        xmlDump.append(EOL);
    }

    public void visitConnection(Connection connection, StringBuilder xmlDump, int metaDataType) {
        String bendpoints;
        xmlDump.append("    <sequenceFlow id=\"" + XmlBPMNProcessDumper.getUniqueNodeId(connection.getFrom()) + "-" + XmlBPMNProcessDumper.getUniqueNodeId(connection.getTo()) + "\" sourceRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId(connection.getFrom()) + "\" ");
        xmlDump.append("targetRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId(connection.getTo()) + "\" ");
        if (metaDataType == 1 && (bendpoints = (String)connection.getMetaData().get("bendpoints")) != null) {
            xmlDump.append("g:bendpoints=\"" + bendpoints + "\" ");
        }
        if (connection.getFrom() instanceof Split) {
            Split split = (Split)connection.getFrom();
            if (split.getType() == 2 || split.getType() == 3) {
                Constraint constraint = split.getConstraint(connection);
                if (constraint == null) {
                    xmlDump.append(">" + EOL + "      <conditionExpression xs:type=\"tFormalExpression\" />");
                } else {
                    if (constraint.getName() != null && constraint.getName().trim().length() > 0) {
                        xmlDump.append("name=\"" + XmlDumper.replaceIllegalChars((String)constraint.getName()) + "\" ");
                    }
                    xmlDump.append(">" + EOL + "      <conditionExpression xs:type=\"tFormalExpression\" ");
                    if ("code".equals(constraint.getType())) {
                        if ("java".equals(constraint.getDialect())) {
                            xmlDump.append("language=\"http://www.java.com/java\" ");
                        } else if ("XPath".equals(constraint.getDialect())) {
                            xmlDump.append("language=\"http://www.w3.org/1999/XPath\" ");
                        }
                    } else {
                        xmlDump.append("language=\"http://www.jboss.org/drools/rule\" ");
                    }
                    String constraintString = constraint.getConstraint();
                    if (constraintString == null) {
                        constraintString = "";
                    }
                    xmlDump.append(">" + XmlDumper.replaceIllegalChars((String)constraintString) + "</conditionExpression>");
                }
                xmlDump.append(EOL + "    </sequenceFlow>" + EOL);
            } else {
                xmlDump.append("/>" + EOL);
            }
        } else {
            xmlDump.append("/>" + EOL);
        }
    }

    private void visitConnectionsDi(Node[] nodes, StringBuilder xmlDump) {
        ArrayList connections = new ArrayList();
        for (Node node : nodes) {
            for (List connectionList : node.getIncomingConnections().values()) {
                connections.addAll(connectionList);
            }
            if (!(node instanceof CompositeNode)) continue;
            this.visitConnectionsDi(((CompositeNode)node).getNodes(), xmlDump);
        }
        for (Connection connection : connections) {
            Integer height;
            Integer width;
            Integer y;
            String bendpoints = (String)connection.getMetaData().get("bendpoints");
            xmlDump.append("      <bpmndi:BPMNEdge bpmnElement=\"" + XmlBPMNProcessDumper.getUniqueNodeId(connection.getFrom()) + "-" + XmlBPMNProcessDumper.getUniqueNodeId(connection.getTo()) + "\" >" + EOL);
            Integer x = (Integer)connection.getFrom().getMetaData().get("x");
            if (x == null) {
                x = 0;
            }
            if ((y = (Integer)connection.getFrom().getMetaData().get("y")) == null) {
                y = 0;
            }
            if ((width = (Integer)connection.getFrom().getMetaData().get("width")) == null) {
                width = 40;
            }
            if ((height = (Integer)connection.getFrom().getMetaData().get("height")) == null) {
                height = 40;
            }
            xmlDump.append("        <di:waypoint x=\"" + (x + width / 2) + "\" y=\"" + (y + height / 2) + "\" />" + EOL);
            if (bendpoints != null) {
                String[] points;
                bendpoints = bendpoints.substring(1, bendpoints.length() - 1);
                for (String point : points = bendpoints.split(";")) {
                    String[] coords = point.split(",");
                    if (coords.length != 2) continue;
                    xmlDump.append("        <di:waypoint x=\"" + coords[0] + "\" y=\"" + coords[1] + "\" />" + EOL);
                }
            }
            if ((x = (Integer)connection.getTo().getMetaData().get("x")) == null) {
                x = 0;
            }
            if ((y = (Integer)connection.getTo().getMetaData().get("y")) == null) {
                y = 0;
            }
            if ((width = (Integer)connection.getTo().getMetaData().get("width")) == null) {
                width = 40;
            }
            if ((height = (Integer)connection.getTo().getMetaData().get("height")) == null) {
                height = 40;
            }
            xmlDump.append("        <di:waypoint x=\"" + (x + width / 2) + "\" y=\"" + (y + height / 2) + "\" />" + EOL);
            xmlDump.append("      </bpmndi:BPMNEdge>" + EOL);
        }
    }

    public static String getUniqueNodeId(Node node) {
        String result = (String)node.getMetaData().get("UniqueId");
        if (result != null) {
            return result;
        }
        result = node.getId() + "";
        NodeContainer nodeContainer = node.getNodeContainer();
        while (nodeContainer instanceof CompositeNode) {
            CompositeNode composite = (CompositeNode)nodeContainer;
            result = composite.getId() + "-" + result;
            nodeContainer = composite.getNodeContainer();
        }
        return "_" + result;
    }
}

