/*
 * Decompiled with CFR 0.152.
 */
package org.drools.camel.component;

import com.sun.tools.xjc.Language;
import com.sun.tools.xjc.Options;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.math.BigInteger;
import javax.naming.Context;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.dataformat.JaxbDataFormat;
import org.apache.camel.spi.Policy;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactoryService;
import org.drools.builder.DirectoryLookupFactoryService;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactoryService;
import org.drools.builder.ResourceType;
import org.drools.builder.help.KnowledgeBuilderHelper;
import org.drools.camel.component.DroolsCamelTestSupport;
import org.drools.camel.component.DroolsPolicy;
import org.drools.command.runtime.BatchExecutionCommandImpl;
import org.drools.command.runtime.rule.FireAllRulesCommand;
import org.drools.command.runtime.rule.InsertObjectCommand;
import org.drools.common.InternalRuleBase;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.rule.DroolsCompositeClassLoader;
import org.drools.runtime.CommandExecutor;
import org.drools.runtime.ExecutionResults;
import org.drools.runtime.StatefulKnowledgeSession;

public class CamelEndpointWithJaxbXSDModelTest
extends DroolsCamelTestSupport {
    private JAXBContext jaxbContext;
    private DroolsCompositeClassLoader classLoader;

    public void testSessionInsert() throws Exception {
        Class personClass = this.classLoader.loadClass("org.drools.model.Person");
        CamelEndpointWithJaxbXSDModelTest.assertNotNull((Object)personClass.getPackage());
        Class addressClass = this.classLoader.loadClass("org.drools.model.AddressType");
        CamelEndpointWithJaxbXSDModelTest.assertNotNull((Object)addressClass.getPackage());
        Object baunax = personClass.newInstance();
        Object lucaz = personClass.newInstance();
        Method setName = personClass.getMethod("setName", String.class);
        setName.invoke(baunax, "baunax");
        setName.invoke(lucaz, "lucaz");
        Method setAddress = personClass.getMethod("setAddress", addressClass);
        Method setStreet = addressClass.getMethod("setStreet", String.class);
        Method setPostalCode = addressClass.getMethod("setPostalCode", BigInteger.class);
        Object lucazAddress = addressClass.newInstance();
        setStreet.invoke(lucazAddress, "Unknow 342");
        setPostalCode.invoke(lucazAddress, new BigInteger("1234"));
        Object baunaxAddress = addressClass.newInstance();
        setStreet.invoke(baunaxAddress, "New Street 123");
        setPostalCode.invoke(baunaxAddress, new BigInteger("5678"));
        setAddress.invoke(lucaz, lucazAddress);
        setAddress.invoke(baunax, baunaxAddress);
        BatchExecutionCommandImpl cmd = new BatchExecutionCommandImpl();
        cmd.setLookup("ksession1");
        cmd.getCommands().add(new InsertObjectCommand(lucaz, "lucaz"));
        cmd.getCommands().add(new InsertObjectCommand(baunax, "baunax"));
        cmd.getCommands().add(new FireAllRulesCommand());
        StringWriter xmlReq = new StringWriter();
        Marshaller marshaller = this.getJaxbContext().createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)cmd, (Writer)xmlReq);
        System.out.println(xmlReq.toString());
        String xmlCmd = "";
        xmlCmd = xmlCmd + "<batch-execution lookup='ksession1'>\n";
        xmlCmd = xmlCmd + "   <insert out-identifier='lucaz'>\n";
        xmlCmd = xmlCmd + "    <object>\n";
        xmlCmd = xmlCmd + "      <Person xmlns='http://drools.org/model' >\n";
        xmlCmd = xmlCmd + "         <name>lucaz</name>\n";
        xmlCmd = xmlCmd + "         <age>25</age>\n";
        xmlCmd = xmlCmd + "      </Person>\n";
        xmlCmd = xmlCmd + "    </object>\n";
        xmlCmd = xmlCmd + "   </insert>\n";
        xmlCmd = xmlCmd + "   <insert out-identifier='baunax'>\n";
        xmlCmd = xmlCmd + "    <object>\n";
        xmlCmd = xmlCmd + "      <Person xmlns='http://drools.org/model' >\n";
        xmlCmd = xmlCmd + "         <name>baunax</name>\n";
        xmlCmd = xmlCmd + "         <age>21</age>\n";
        xmlCmd = xmlCmd + "      </Person>\n";
        xmlCmd = xmlCmd + "    </object>\n";
        xmlCmd = xmlCmd + "   </insert>\n";
        xmlCmd = xmlCmd + "   <fire-all-rules />";
        xmlCmd = xmlCmd + "</batch-execution>\n";
        byte[] xmlResp = (byte[])this.template.requestBody("direct:test-with-session", (Object)xmlReq.toString());
        CamelEndpointWithJaxbXSDModelTest.assertNotNull((Object)xmlResp);
        System.out.println(new String(xmlResp));
        ExecutionResults resp = (ExecutionResults)this.getJaxbContext().createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xmlResp));
        CamelEndpointWithJaxbXSDModelTest.assertNotNull((Object)resp);
        CamelEndpointWithJaxbXSDModelTest.assertEquals((int)2, (int)resp.getIdentifiers().size());
        CamelEndpointWithJaxbXSDModelTest.assertNotNull((Object)resp.getValue("lucaz"));
        CamelEndpointWithJaxbXSDModelTest.assertNotNull((Object)resp.getValue("baunax"));
        CamelEndpointWithJaxbXSDModelTest.assertNotNull((Object)resp.getFactHandle("lucaz"));
        CamelEndpointWithJaxbXSDModelTest.assertNotNull((Object)resp.getFactHandle("baunax"));
    }

    public JAXBContext getJaxbContext() {
        if (this.jaxbContext == null) {
            JaxbDataFormat def = new JaxbDataFormat();
            def.setPrettyPrint(Boolean.valueOf(true));
            def.setContextPath("org.drools.model:org.drools.pipeline.camel");
            StatefulKnowledgeSession ksession1 = (StatefulKnowledgeSession)((DirectoryLookupFactoryService)this.node.get(DirectoryLookupFactoryService.class)).lookup("ksession1");
            KnowledgeBase kbase = ksession1.getKnowledgeBase();
            ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)((ReteooRuleBase)((KnowledgeBaseImpl)kbase).getRuleBase()).getRootClassLoader());
                def = DroolsPolicy.augmentJaxbDataFormatDefinition((JaxbDataFormat)def);
                org.apache.camel.converter.jaxb.JaxbDataFormat jaxbDataformat = (org.apache.camel.converter.jaxb.JaxbDataFormat)def.getDataFormat(((Route)this.context.getRoutes().get(0)).getRouteContext());
                this.jaxbContext = jaxbDataformat.getContext();
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCl);
            }
        }
        return this.jaxbContext;
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                JaxbDataFormat def = new JaxbDataFormat();
                def.setPrettyPrint(Boolean.valueOf(true));
                def.setContextPath("org.drools.model:org.drools.pipeline.camel");
                ((PolicyDefinition)((PolicyDefinition)this.from("direct:test-with-session").policy((Policy)new DroolsPolicy()).unmarshal((DataFormatDefinition)def)).to("drools:node/ksession1")).marshal((DataFormatDefinition)def);
            }
        };
    }

    protected void configureDroolsContext(Context jndiContext) {
        String rule = "";
        rule = rule + "package org.drools.pipeline.camel.test \n";
        rule = rule + "import org.drools.model.Person \n";
        rule = rule + "global java.util.List list \n";
        rule = rule + "query persons \n";
        rule = rule + "   $p : Person(name != null) \n";
        rule = rule + "end \n";
        rule = rule + "query personWithName(String param)\n";
        rule = rule + "   $p : Person(name == param) \n";
        rule = rule + "end \n";
        rule = rule + "rule rule1 \n";
        rule = rule + "  when \n";
        rule = rule + "    $p : Person() \n";
        rule = rule + " \n";
        rule = rule + "  then \n";
        rule = rule + "    System.out.println(\"executed\"); \n";
        rule = rule + "end\n";
        this.registerKnowledgeRuntime("ksession1", rule);
    }

    protected StatefulKnowledgeSession registerKnowledgeRuntime(String identifier, String rule) {
        KnowledgeBuilder kbuilder = ((KnowledgeBuilderFactoryService)this.node.get(KnowledgeBuilderFactoryService.class)).newKnowledgeBuilder();
        Options xjcOpts = new Options();
        xjcOpts.setSchemaLanguage(Language.XMLSCHEMA);
        try {
            KnowledgeBuilderHelper.addXsdModel((Resource)ResourceFactory.newClassPathResource((String)"person.xsd", ((Object)((Object)this)).getClass()), (KnowledgeBuilder)kbuilder, (Options)xjcOpts, (String)"xsd");
        }
        catch (IOException e) {
            LOG.error("Errors while adding xsd model. ", (Object)kbuilder.getErrors());
        }
        CamelEndpointWithJaxbXSDModelTest.assertFalse((boolean)kbuilder.hasErrors());
        if (rule != null && rule.length() > 0) {
            kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
            if (kbuilder.hasErrors()) {
                LOG.info("Errors while adding rule. ", (Object)kbuilder.getErrors());
            }
        }
        CamelEndpointWithJaxbXSDModelTest.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = ((KnowledgeBaseFactoryService)this.node.get(KnowledgeBaseFactoryService.class)).newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        this.classLoader = ((InternalRuleBase)((KnowledgeBaseImpl)kbase).getRuleBase()).getRootClassLoader();
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        ((DirectoryLookupFactoryService)this.node.get(DirectoryLookupFactoryService.class)).register(identifier, (CommandExecutor)session);
        return session;
    }
}

