/*
 * Decompiled with CFR 0.152.
 */
package org.drools.camel.component;

import java.util.Collection;
import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.examples.RecursiveElementNameAndTextQualifier;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactoryService;
import org.drools.builder.DirectoryLookupFactoryService;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactoryService;
import org.drools.builder.ResourceType;
import org.drools.grid.ExecutionNode;
import org.drools.grid.local.LocalConnection;
import org.drools.io.ResourceFactory;
import org.drools.runtime.CommandExecutor;
import org.drools.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DroolsCamelTestSupport
extends ContextTestSupport {
    protected static final Logger LOG = LoggerFactory.getLogger(DroolsCamelTestSupport.class);
    protected ExecutionNode node;

    public void setNode(ExecutionNode node) {
        this.node = node;
    }

    public ExecutionNode getNode() {
        return this.node;
    }

    public void setUp() throws Exception {
        super.setUp();
        XMLUnit.setIgnoreComments((boolean)true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
        XMLUnit.setNormalizeWhitespace((boolean)true);
        XMLUnit.setNormalize((boolean)true);
    }

    protected Context createJndiContext() throws Exception {
        Context context = super.createJndiContext();
        LocalConnection connection = new LocalConnection();
        this.node = connection.getExecutionNode(null);
        this.node.setId("node");
        context.bind("node", (Object)this.node);
        this.configureDroolsContext(context);
        return context;
    }

    protected abstract void configureDroolsContext(Context var1);

    protected StatefulKnowledgeSession registerKnowledgeRuntime(String identifier, String rule) {
        KnowledgeBuilder kbuilder = ((KnowledgeBuilderFactoryService)this.node.get(KnowledgeBuilderFactoryService.class)).newKnowledgeBuilder();
        if (rule != null && rule.length() > 0) {
            kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
            if (kbuilder.hasErrors()) {
                LOG.info("Errors while adding rule. ", (Object)kbuilder.getErrors());
            }
        }
        DroolsCamelTestSupport.assertFalse((boolean)kbuilder.hasErrors());
        Collection pkgs = kbuilder.getKnowledgePackages();
        KnowledgeBase kbase = ((KnowledgeBaseFactoryService)this.node.get(KnowledgeBaseFactoryService.class)).newKnowledgeBase();
        kbase.addKnowledgePackages(pkgs);
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        ((DirectoryLookupFactoryService)this.node.get(DirectoryLookupFactoryService.class)).register(identifier, (CommandExecutor)session);
        return session;
    }

    protected void assertXMLEqual(String expected, String result) throws Exception {
        Diff diff = new Diff(expected, result);
        diff.overrideElementQualifier((ElementQualifier)new RecursiveElementNameAndTextQualifier());
        XMLAssert.assertXMLEqual((Diff)diff, (boolean)true);
    }

    protected void configureDroolsContext() {
    }
}

