/*
 * Decompiled with CFR 0.152.
 */
package org.drools.camel.component;

import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.DataFormat;
import org.drools.builder.DirectoryLookupFactoryService;
import org.drools.camel.component.DroolsComponent;
import org.drools.camel.component.DroolsProducer;
import org.drools.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.util.StringUtils;
import org.drools.grid.ExecutionNode;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.impl.StatelessKnowledgeSessionImpl;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.rule.DroolsCompositeClassLoader;
import org.drools.runtime.CommandExecutor;

public class DroolsEndpoint
extends DefaultEndpoint {
    public String ksessionId;
    public CommandExecutor executor;
    public ExecutionNode node;
    public String dataFormatName;
    public DataFormat dataFormat;
    public static Pattern p = Pattern.compile("[\"']?lookup[\"']?\\s*[:=]\\s*[\"']([^\"']+)[\"']");

    public DroolsEndpoint(String endpointUri, String remaining, DroolsComponent component) throws URISyntaxException {
        super(endpointUri, (Component)component);
        this.configure(component, remaining);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new RuntimeCamelException("Drools consumers not supported.");
    }

    public Producer createProducer() throws Exception {
        return new DroolsProducer((Endpoint)this, this.node);
    }

    public boolean isSingleton() {
        return true;
    }

    public String getKsessionId() {
        return this.ksessionId;
    }

    public void setKsessionId(String ksession) {
        this.ksessionId = ksession;
    }

    public CommandExecutor getExecutor() {
        return this.executor;
    }

    public ExecutionNode getExecutionNode() {
        return this.node;
    }

    protected void configure(DroolsComponent component, String uri) {
        String nodeId = DroolsEndpoint.getExecuteNodeId(uri);
        this.ksessionId = DroolsEndpoint.getKsessionId(uri);
        if (!StringUtils.isEmpty((CharSequence)nodeId)) {
            this.node = (ExecutionNode)component.getCamelContext().getRegistry().lookup(nodeId, ExecutionNode.class);
            if (this.node == null) {
                throw new RuntimeCamelException("Could not find ExecutionNode for uri=\"" + uri + "\" in CamelContext. Check configuration.");
            }
            if (!StringUtils.isEmpty((CharSequence)this.ksessionId)) {
                this.executor = ((DirectoryLookupFactoryService)this.node.get(DirectoryLookupFactoryService.class)).lookup(this.ksessionId);
                if (this.executor == null) {
                    throw new RuntimeCamelException("Failed to instantiate DroolsEndpoint. Lookup of CommandExecutor with uri=\"" + uri + "\" failed. Check configuration.");
                }
            }
        } else {
            this.executor = (CommandExecutor)component.getCamelContext().getRegistry().lookup(this.ksessionId, CommandExecutor.class);
            if (this.executor == null) {
                throw new RuntimeCamelException("Failed to instantiate DroolsEndpoint. Could not find ksession for  uri=\"" + uri + "\". Check configuration.");
            }
        }
    }

    public static final String getExecuteNodeId(String uri) {
        int pos = uri.indexOf(47);
        return pos < 0 ? uri : uri.substring(0, pos);
    }

    public static final String getKsessionId(String uri) {
        int pos = uri.indexOf(47);
        return pos < 0 ? "" : uri.substring(pos + 1);
    }

    public String getDataFormat() {
        return this.dataFormatName;
    }

    public void setDataFormat(String dataFormatName) {
        this.dataFormatName = dataFormatName;
    }

    public String getLookup(String body) {
        Matcher m = p.matcher(body);
        String name = null;
        if (m.find()) {
            name = m.group(1);
        }
        return name;
    }

    public CommandExecutor getCommandExecutor(String name) {
        if (this.executor != null) {
            return this.executor;
        }
        if (this.node == null) {
            throw new RuntimeException("ExecutionNode for CommandExecutor lookup cannot be null");
        }
        return ((DirectoryLookupFactoryService)this.node.get(DirectoryLookupFactoryService.class)).lookup(name);
    }

    public ClassLoader getClassLoader(CommandExecutor exec) {
        DroolsCompositeClassLoader cl = null;
        if (exec instanceof StatefulKnowledgeSessionImpl) {
            cl = ((ReteooRuleBase)((StatefulKnowledgeSessionImpl)exec).getRuleBase()).getRootClassLoader();
        } else if (exec instanceof StatelessKnowledgeSessionImpl) {
            cl = ((ReteooRuleBase)((StatelessKnowledgeSessionImpl)exec).getRuleBase()).getRootClassLoader();
        } else if (exec instanceof CommandBasedStatefulKnowledgeSession) {
            cl = ((ReteooRuleBase)((KnowledgeBaseImpl)((CommandBasedStatefulKnowledgeSession)exec).getKnowledgeBase()).getRuleBase()).getRootClassLoader();
        }
        return cl;
    }
}

