/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.view;

import java.util.UUID;
import org.drools.model.Variable;
import org.drools.model.view.ExprViewItem;

public abstract class AbstractExprViewItem<T>
implements ExprViewItem<T> {
    private final String exprId;
    private final Variable<T> var;
    private String[] reactiveProps;
    private String[] watchedProps;
    private boolean queryExpression;

    public AbstractExprViewItem(Variable<T> var) {
        this(UUID.randomUUID().toString(), var);
    }

    public AbstractExprViewItem(String exprId, Variable<T> var) {
        this.exprId = exprId;
        this.var = var;
    }

    @Override
    public Variable<T> getFirstVariable() {
        return this.var;
    }

    @Override
    public AbstractExprViewItem<T> reactOn(String ... props) {
        this.reactiveProps = props;
        return this;
    }

    @Override
    public AbstractExprViewItem<T> watch(String ... props) {
        this.watchedProps = props;
        return this;
    }

    @Override
    public String getExprId() {
        return this.exprId;
    }

    public String[] getReactiveProps() {
        return this.reactiveProps;
    }

    public String[] getWatchedProps() {
        return this.watchedProps;
    }

    public boolean isQueryExpression() {
        return this.queryExpression;
    }

    public void setQueryExpression(boolean queryExpression) {
        this.queryExpression = queryExpression;
    }
}

