/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.constraints;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.model.Constraint;
import org.drools.model.Variable;
import org.drools.model.constraints.AbstractConstraint;
import org.drools.model.constraints.OrConstraints;
import org.drools.model.impl.ModelComponent;

public class MultipleConstraints
extends AbstractConstraint
implements ModelComponent {
    private final List<Constraint> constraints;

    public MultipleConstraints(List<Constraint> constraints) {
        this.constraints = constraints;
    }

    public MultipleConstraints(Constraint ... constraints) {
        this.constraints = new ArrayList<Constraint>();
        for (Constraint constraint : constraints) {
            this.with(constraint);
        }
    }

    @Override
    public MultipleConstraints with(Constraint constraint) {
        this.constraints.add(constraint);
        return this;
    }

    @Override
    public List<Constraint> getChildren() {
        return this.constraints;
    }

    @Override
    public Constraint.Type getType() {
        return Constraint.Type.MULTIPLE;
    }

    @Override
    public boolean isEqualTo(ModelComponent o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultipleConstraints)) {
            return false;
        }
        MultipleConstraints that = (MultipleConstraints)o;
        return ModelComponent.areEqualInModel(this.constraints, that.constraints);
    }

    @Override
    public Constraint negate() {
        if (this.constraints.size() == 1) {
            return new MultipleConstraints(this.constraints.get(0).negate());
        }
        OrConstraints or = new OrConstraints(new Constraint[0]);
        for (Constraint constraint : this.constraints) {
            or.or(constraint.negate());
        }
        return or;
    }

    @Override
    public MultipleConstraints replaceVariable(Variable oldVar, Variable newVar) {
        return new MultipleConstraints(this.constraints.stream().map(c -> c.replaceVariable(oldVar, newVar)).collect(Collectors.toList()));
    }

    public String toString() {
        return "MultipleConstraints (constraints: " + this.constraints + ")";
    }
}

