/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.view;

import java.util.UUID;
import org.drools.model.Declaration;
import org.drools.model.DomainClassMetadata;
import org.drools.model.Variable;
import org.drools.model.constraints.ReactivitySpecs;
import org.drools.model.view.ExprViewItem;

public abstract class AbstractExprViewItem<T>
implements ExprViewItem<T> {
    private final String exprId;
    private final Variable<T> var;
    private ReactivitySpecs reactivitySpecs = ReactivitySpecs.EMPTY;
    private String[] watchedProps;
    private boolean queryExpression;

    public AbstractExprViewItem(Variable<T> var) {
        this(UUID.randomUUID().toString(), var);
    }

    public AbstractExprViewItem(String exprId, Variable<T> var) {
        this.exprId = exprId;
        this.var = var;
    }

    @Override
    public Variable<T> getFirstVariable() {
        return this.var;
    }

    @Override
    public AbstractExprViewItem<T> reactOn(String ... props) {
        this.reactivitySpecs = new ReactivitySpecs(this.getDomainClassMetadata(), props);
        return this;
    }

    private DomainClassMetadata getDomainClassMetadata() {
        return this.var instanceof Declaration ? ((Declaration)this.var).getMetadata() : null;
    }

    @Override
    public AbstractExprViewItem<T> watch(String ... props) {
        this.watchedProps = props;
        return this;
    }

    @Override
    public String getExprId() {
        return this.exprId;
    }

    public ReactivitySpecs getReactivitySpecs() {
        return this.reactivitySpecs;
    }

    public String[] getWatchedProps() {
        return this.watchedProps;
    }

    public boolean isQueryExpression() {
        return this.queryExpression;
    }

    public void setQueryExpression(boolean queryExpression) {
        this.queryExpression = queryExpression;
    }
}

