/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.constraints;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.model.Constraint;
import org.drools.model.Variable;
import org.drools.model.constraints.AbstractConstraint;
import org.drools.model.constraints.AndConstraints;
import org.drools.model.impl.ModelComponent;

public class OrConstraints
extends AbstractConstraint
implements ModelComponent {
    private final List<Constraint> constraints;

    public OrConstraints(List<Constraint> constraints) {
        this.constraints = constraints;
    }

    public OrConstraints(Constraint ... constraints) {
        this.constraints = new ArrayList<Constraint>();
        for (Constraint constraint : constraints) {
            this.or(constraint);
        }
    }

    @Override
    public OrConstraints or(Constraint constraint) {
        this.constraints.add(constraint);
        return this;
    }

    @Override
    public List<Constraint> getChildren() {
        return this.constraints;
    }

    @Override
    public Constraint.Type getType() {
        return Constraint.Type.OR;
    }

    @Override
    public boolean isEqualTo(ModelComponent o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OrConstraints)) {
            return false;
        }
        OrConstraints that = (OrConstraints)o;
        return ModelComponent.areEqualInModel(this.constraints, that.constraints);
    }

    @Override
    public Constraint negate() {
        if (this.constraints.size() == 1) {
            return new OrConstraints(this.constraints.get(0).negate());
        }
        AndConstraints and = new AndConstraints(new Constraint[0]);
        for (Constraint constraint : this.constraints) {
            and.and(constraint.negate());
        }
        return and;
    }

    @Override
    public OrConstraints replaceVariable(Variable oldVar, Variable newVar) {
        return new OrConstraints(this.constraints.stream().map(c -> c.replaceVariable(oldVar, newVar)).collect(Collectors.toList()));
    }

    public String toString() {
        return "OrConstraints (constraints: " + this.constraints + ")";
    }
}

