/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model;

import java.util.function.Function;
import org.drools.model.AlphaIndex;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Prototype;
import org.drools.model.PrototypeFact;
import org.drools.model.PrototypeVariable;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Predicate1;
import org.drools.model.functions.Predicate2;
import org.drools.model.impl.PrototypeImpl;
import org.drools.model.impl.PrototypeVariableImpl;

public class PrototypeDSL {
    public static Prototype prototype(String name) {
        return new PrototypeImpl(name);
    }

    public static Prototype prototype(String name, String ... fields) {
        return new PrototypeImpl(name, fields);
    }

    public static Prototype prototype(String name, Prototype.Field ... fields) {
        return new PrototypeImpl(name, fields);
    }

    public static Prototype.Field field(String name) {
        return new PrototypeImpl.FieldImpl(name);
    }

    public static Prototype.Field field(String name, Function<PrototypeFact, Object> extractor) {
        return new PrototypeImpl.FieldImpl(name, extractor);
    }

    public static Prototype.Field field(String name, Class<?> type) {
        return new PrototypeImpl.FieldImpl(name, type);
    }

    public static Prototype.Field field(String name, Class<?> type, Function<PrototypeFact, Object> extractor) {
        return new PrototypeImpl.FieldImpl(name, type, extractor);
    }

    public static PrototypeVariable variable(Prototype prototype) {
        return new PrototypeVariableImpl(prototype);
    }

    public static PrototypeVariable variable(Prototype prototype, String name) {
        return new PrototypeVariableImpl(prototype, name);
    }

    public static PrototypePatternDef protoPattern(PrototypeVariable protoVar) {
        return new PrototypePatternDefImpl(protoVar);
    }

    public static class PrototypePatternDefImpl
    extends PatternDSL.PatternDefImpl<PrototypeFact>
    implements PrototypePatternDef {
        public PrototypePatternDefImpl(PrototypeVariable variable) {
            super(variable);
        }

        @Override
        public PrototypePatternDef expr(String fieldName, Index.ConstraintType constraintType, Object value) {
            int fieldIndex;
            PrototypeVariable protoVar = (PrototypeVariable)this.getFirstVariable();
            Prototype prototype = protoVar.getPrototype();
            Prototype.Field field = prototype.getField(fieldName);
            Function1<PrototypeFact, Object> extractor = this.getFieldValueExtractor(prototype, fieldName);
            int n = fieldIndex = field != null ? prototype.getFieldIndex(fieldName) : Math.abs(fieldName.hashCode());
            Class<?> fieldClass = field != null && field.isTyped() ? field.getType() : (value != null ? value.getClass() : null);
            AlphaIndex<PrototypeFact, Object> alphaIndex = fieldClass != null ? PatternDSL.alphaIndexedBy(fieldClass, constraintType, fieldIndex, extractor, value) : null;
            this.expr("expr:" + fieldName + ":" + (Object)((Object)constraintType) + ":" + value, this.asPredicate(extractor, constraintType, value), alphaIndex, PatternDSL.reactOn(fieldName));
            return this;
        }

        @Override
        public PrototypePatternDef expr(String fieldName, Index.ConstraintType constraintType, PrototypeVariable other, String otherFieldName) {
            PrototypeVariable protoVar = (PrototypeVariable)this.getFirstVariable();
            Prototype prototype = protoVar.getPrototype();
            Prototype.Field field = prototype.getField(fieldName);
            Function1<PrototypeFact, Object> extractor = this.getFieldValueExtractor(prototype, fieldName);
            Class<Object> fieldClass = field != null && field.isTyped() ? field.getType() : Object.class;
            int fieldIndex = field != null ? prototype.getFieldIndex(fieldName) : Math.abs(fieldName.hashCode());
            Prototype otherPrototype = other.getPrototype();
            Function1<PrototypeFact, Object> otherExtractor = this.getFieldValueExtractor(otherPrototype, otherFieldName);
            this.expr("expr:" + fieldName + ":" + (Object)((Object)constraintType) + ":" + otherFieldName, other, this.asPredicate(extractor, constraintType, otherExtractor), PatternDSL.betaIndexedBy(fieldClass, constraintType, fieldIndex, extractor, otherExtractor), PatternDSL.reactOn(fieldName));
            return this;
        }

        private Predicate1<PrototypeFact> asPredicate(Function1<PrototypeFact, Object> extractor, Index.ConstraintType constraintType, Object value) {
            return p -> constraintType.asPredicate().test(extractor.apply((PrototypeFact)p), value);
        }

        private Predicate2<PrototypeFact, PrototypeFact> asPredicate(Function1<PrototypeFact, Object> extractor, Index.ConstraintType constraintType, Function1<PrototypeFact, Object> otherExtractor) {
            return (p1, p2) -> constraintType.asPredicate().test(extractor.apply((PrototypeFact)p1), otherExtractor.apply((PrototypeFact)p2));
        }

        private Function1<PrototypeFact, Object> getFieldValueExtractor(Prototype prototype, String fieldName) {
            return prototype.getFieldValueExtractor(fieldName)::apply;
        }
    }

    public static interface PrototypePatternDef
    extends PatternDSL.PatternDef<PrototypeFact> {
        public PrototypePatternDef expr(String var1, Index.ConstraintType var2, Object var3);

        public PrototypePatternDef expr(String var1, Index.ConstraintType var2, PrototypeVariable var3, String var4);
    }
}

