/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.constraints;

import org.drools.model.Variable;
import org.drools.model.constraints.TemporalConstraint;
import org.drools.model.functions.Function1;
import org.drools.model.functions.temporal.TemporalPredicate;
import org.drools.model.impl.ModelComponent;
import org.drools.model.view.FixedTemporalExprViewItem;

public class FixedTemporalConstraint<A>
extends TemporalConstraint {
    private final Function1<?, ?> func;
    private final long value;

    public FixedTemporalConstraint(String exprId, Variable<A> var1, Function1<?, ?> func, long value, TemporalPredicate temporalPredicate) {
        super(exprId, var1, temporalPredicate);
        this.func = func;
        this.value = value;
    }

    public FixedTemporalConstraint(FixedTemporalExprViewItem<A> expr) {
        this(expr.getExprId(), expr.getFirstVariable(), expr.getF1(), expr.getValue(), expr.getTemporalPredicate());
    }

    @Override
    public Variable[] getVariables() {
        return new Variable[]{this.var1};
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public boolean isEqualTo(ModelComponent o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FixedTemporalConstraint that = (FixedTemporalConstraint)o;
        if (!ModelComponent.areEqualInModel(this.var1, that.var1)) {
            return false;
        }
        if (!ModelComponent.areEqualInModel(this.func, that.func)) {
            return false;
        }
        if (this.value != that.value) {
            return false;
        }
        return this.temporalPredicate.equals(that.temporalPredicate);
    }

    @Override
    public Function1<?, ?> getF1() {
        return this.func;
    }

    @Override
    public Function1<?, ?> getF2() {
        return null;
    }

    @Override
    public FixedTemporalConstraint<A> negate() {
        return new FixedTemporalConstraint<A>("!" + this.getExprId(), this.var1, this.func, this.value, this.temporalPredicate.negate());
    }

    @Override
    public FixedTemporalConstraint replaceVariable(Variable oldVar, Variable newVar) {
        if (this.var1 == oldVar) {
            return new FixedTemporalConstraint<A>(this.getExprId(), newVar, this.func, this.value, this.temporalPredicate);
        }
        return this;
    }

    @Override
    public String toString() {
        return "FixedTemporalConstraint for '" + this.getExprId() + "' (function: lambda " + System.identityHashCode(this.func) + ", value: " + this.value + ")";
    }
}

