/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.function.BiPredicate;
import org.drools.model.ConstraintOperator;
import org.drools.model.functions.Function1;

public interface Index<A, V> {
    public IndexType getIndexType();

    public Class<V> getIndexedClass();

    public ConstraintType getConstraintType();

    public int getIndexId();

    public Function1<A, V> getLeftOperandExtractor();

    public Index<A, V> negate();

    public static enum ConstraintType implements ConstraintOperator
    {
        EQUAL,
        NOT_EQUAL,
        GREATER_THAN,
        GREATER_OR_EQUAL,
        LESS_THAN,
        LESS_OR_EQUAL,
        RANGE,
        FORALL_SELF_JOIN,
        UNKNOWN;


        public ConstraintType negate() {
            switch (this) {
                case FORALL_SELF_JOIN: 
                case EQUAL: {
                    return NOT_EQUAL;
                }
                case NOT_EQUAL: {
                    return EQUAL;
                }
                case GREATER_THAN: {
                    return LESS_OR_EQUAL;
                }
                case GREATER_OR_EQUAL: {
                    return LESS_THAN;
                }
                case LESS_OR_EQUAL: {
                    return GREATER_THAN;
                }
                case LESS_THAN: {
                    return GREATER_OR_EQUAL;
                }
            }
            return UNKNOWN;
        }

        public boolean canInverse() {
            switch (this) {
                case EQUAL: 
                case NOT_EQUAL: 
                case GREATER_THAN: 
                case GREATER_OR_EQUAL: 
                case LESS_OR_EQUAL: 
                case LESS_THAN: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public <T, V> BiPredicate<T, V> asPredicate() {
            switch (this) {
                case EQUAL: {
                    return (t, v) -> this.areEqual(t, v);
                }
                case NOT_EQUAL: {
                    return (t, v) -> !this.areEqual(t, v);
                }
                case GREATER_THAN: {
                    return (t, v) -> t != null && this.compare(t, v) > 0;
                }
                case GREATER_OR_EQUAL: {
                    return (t, v) -> t != null && this.compare(t, v) >= 0;
                }
                case LESS_THAN: {
                    return (t, v) -> t != null && this.compare(t, v) < 0;
                }
                case LESS_OR_EQUAL: {
                    return (t, v) -> t != null && this.compare(t, v) <= 0;
                }
            }
            throw new UnsupportedOperationException("Cannot convert " + this + " into a predicate");
        }

        private boolean areEqual(Object o1, Object o2) {
            return o1 instanceof Number && o2 instanceof Number ? this.areNumericEqual((Number)o1, (Number)o2) : Objects.equals(o1, o2);
        }

        private <T, V> boolean areNumericEqual(Number n1, Number n2) {
            return n1.getClass() != n2.getClass() ? this.asBigDecimal(n1).equals(this.asBigDecimal(n2)) : Objects.equals(n1, n2);
        }

        private int compare(Object o1, Object o2) {
            return o1.getClass() != o2.getClass() && o1 instanceof Number && o2 instanceof Number ? this.asBigDecimal(o1).compareTo(this.asBigDecimal(o2)) : ((Comparable)o1).compareTo(o2);
        }

        private BigDecimal asBigDecimal(Object obj) {
            return obj instanceof BigDecimal ? (BigDecimal)obj : BigDecimal.valueOf(((Number)obj).doubleValue());
        }

        public ConstraintType inverse() {
            switch (this) {
                case GREATER_THAN: {
                    return LESS_THAN;
                }
                case GREATER_OR_EQUAL: {
                    return LESS_OR_EQUAL;
                }
                case LESS_THAN: {
                    return GREATER_THAN;
                }
                case LESS_OR_EQUAL: {
                    return GREATER_OR_EQUAL;
                }
            }
            return this;
        }

        public boolean isComparison() {
            return this.isAscending() || this.isDescending();
        }

        public boolean isAscending() {
            return this == GREATER_THAN || this == GREATER_OR_EQUAL;
        }

        public boolean isDescending() {
            return this == LESS_THAN || this == LESS_OR_EQUAL;
        }
    }

    public static enum IndexType {
        ALPHA,
        BETA;

    }
}

