/*
 * Decompiled with CFR 0.152.
 */
package org.drools.codegen.common.context;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import javax.lang.model.SourceVersion;
import org.drools.codegen.common.AppPaths;
import org.drools.codegen.common.DroolsModelApplicationPropertyProvider;
import org.drools.codegen.common.DroolsModelBuildContext;
import org.drools.codegen.common.di.DependencyInjectionAnnotator;
import org.drools.codegen.common.rest.RestAnnotator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDroolsModelBuildContext
implements DroolsModelBuildContext {
    public static final String DEFAULT_GROUP_ID = "org.kie.kogito";
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractDroolsModelBuildContext.class);
    protected final Predicate<String> classAvailabilityResolver;
    protected final DroolsModelApplicationPropertyProvider applicationProperties;
    protected final String packageName;
    protected final ClassLoader classLoader;
    protected final AppPaths appPaths;
    protected final String contextName;
    protected final Map<String, Object> contextAttributes;
    protected final DependencyInjectionAnnotator dependencyInjectionAnnotator;
    protected final RestAnnotator restAnnotator;

    protected AbstractDroolsModelBuildContext(AbstractBuilder builder, DependencyInjectionAnnotator dependencyInjectionAnnotator, RestAnnotator restAnnotator, String contextName) {
        this.dependencyInjectionAnnotator = dependencyInjectionAnnotator;
        this.restAnnotator = restAnnotator;
        this.packageName = builder.packageName;
        this.classAvailabilityResolver = builder.classAvailabilityResolver;
        this.applicationProperties = builder.applicationProperties;
        this.classLoader = builder.classLoader;
        this.appPaths = builder.appPaths;
        this.contextName = contextName;
        this.contextAttributes = new HashMap<String, Object>();
    }

    protected static Properties load(File ... resourcePaths) {
        Properties applicationProperties = new Properties();
        for (File resourcePath : resourcePaths) {
            try (FileReader fileReader = new FileReader(new File(resourcePath, "application.properties"), StandardCharsets.UTF_8);){
                applicationProperties.load(fileReader);
            }
            catch (IOException ioe) {
                LOGGER.debug("Unable to load 'application.properties'.");
            }
        }
        return applicationProperties;
    }

    @Override
    public boolean hasClassAvailable(String fqcn) {
        return this.classAvailabilityResolver.test(fqcn);
    }

    @Override
    public Optional<String> getApplicationProperty(String property) {
        return this.applicationProperties.getApplicationProperty(property);
    }

    @Override
    public Collection<String> getApplicationProperties() {
        return this.applicationProperties.getApplicationProperties();
    }

    @Override
    public void setApplicationProperty(String key, String value) {
        this.applicationProperties.setApplicationProperty(key, value);
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String name() {
        return this.contextName;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public AppPaths getAppPaths() {
        return this.appPaths;
    }

    @Override
    public DependencyInjectionAnnotator getDependencyInjectionAnnotator() {
        return this.dependencyInjectionAnnotator;
    }

    @Override
    public RestAnnotator getRestAnnotator() {
        return this.restAnnotator;
    }

    public String toString() {
        return "KogitoBuildContext{contextName='" + this.contextName + "', applicationProperties=" + this.applicationProperties + ", packageName='" + this.packageName + "'}";
    }

    protected static abstract class AbstractBuilder
    implements DroolsModelBuildContext.Builder {
        protected String packageName = "org.kie.kogito.app";
        protected DroolsModelApplicationPropertyProvider applicationProperties = DroolsModelApplicationPropertyProvider.of(new Properties());
        protected ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        protected Predicate<String> classAvailabilityResolver = this::hasClass;
        protected AppPaths appPaths = AppPaths.fromProjectDir(new File(".").toPath());

        protected AbstractBuilder() {
        }

        @Override
        public DroolsModelBuildContext.Builder withPackageName(String packageName) {
            Objects.requireNonNull(packageName, "packageName cannot be null");
            if (!SourceVersion.isName(packageName)) {
                throw new IllegalArgumentException(MessageFormat.format("Package name \"{0}\" is not valid. It should be a valid Java package name.", packageName));
            }
            if (!packageName.equals(AbstractDroolsModelBuildContext.DEFAULT_GROUP_ID)) {
                this.packageName = packageName;
            } else {
                LOGGER.warn("Skipping the package provided because invalid: '{}' (current value '{}')", (Object)packageName, (Object)this.packageName);
            }
            return this;
        }

        @Override
        public DroolsModelBuildContext.Builder withApplicationPropertyProvider(DroolsModelApplicationPropertyProvider applicationProperties) {
            Objects.requireNonNull(applicationProperties, "applicationPropertiesProvider cannot be null");
            this.applicationProperties = applicationProperties;
            return this;
        }

        @Override
        public DroolsModelBuildContext.Builder withApplicationProperties(Properties applicationProperties) {
            Objects.requireNonNull(applicationProperties, "applicationProperties cannot be null");
            this.applicationProperties = DroolsModelApplicationPropertyProvider.of(applicationProperties);
            return this;
        }

        @Override
        public DroolsModelBuildContext.Builder withApplicationProperties(File ... files) {
            this.applicationProperties = DroolsModelApplicationPropertyProvider.of(AbstractDroolsModelBuildContext.load(files));
            return this;
        }

        @Override
        public DroolsModelBuildContext.Builder withClassAvailabilityResolver(Predicate<String> classAvailabilityResolver) {
            Objects.requireNonNull(classAvailabilityResolver, "classAvailabilityResolver cannot be null");
            this.classAvailabilityResolver = classAvailabilityResolver;
            return this;
        }

        @Override
        public DroolsModelBuildContext.Builder withClassLoader(ClassLoader classLoader) {
            Objects.requireNonNull(classLoader, "classLoader cannot be null");
            this.classLoader = classLoader;
            return this;
        }

        @Override
        public DroolsModelBuildContext.Builder withAppPaths(AppPaths appPaths) {
            Objects.requireNonNull(appPaths, "appPaths cannot be null");
            this.appPaths = appPaths;
            return this;
        }

        private boolean hasClass(String className) {
            try {
                this.classLoader.loadClass(className);
                return true;
            }
            catch (ClassNotFoundException ex) {
                return false;
            }
        }
    }
}

