/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.drools.compiler.kie.builder.impl.AbstractKieProject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModuleProvider;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.event.KieModuleDiscovered;
import org.drools.compiler.kie.builder.impl.event.KieServicesEventListerner;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.util.IoUtils;
import org.drools.util.PortablePath;
import org.drools.util.StringUtils;
import org.drools.wiring.api.classloader.ProjectClassLoader;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.util.maven.support.PomModel;
import org.kie.util.maven.support.ReleaseIdImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathKieProject
extends AbstractKieProject {
    private static final Logger log = LoggerFactory.getLogger(ClasspathKieProject.class);
    public static final String OSGI_KIE_MODULE_CLASS_NAME = "org.kie.osgi.compiler.OsgiKieModule";
    private final Map<ReleaseId, InternalKieModule> kieModules = new HashMap<ReleaseId, InternalKieModule>();
    private final Map<String, InternalKieModule> kJarFromKBaseName = new HashMap<String, InternalKieModule>();
    private final KieRepository kieRepository = KieServices.Factory.get().getRepository();
    private final ClassLoader parentCL;
    private ClassLoader classLoader;
    private final WeakReference<KieServicesEventListerner> listener;
    private ReleaseId classPathreleaseId;

    ClasspathKieProject(ClassLoader parentCL, WeakReference<KieServicesEventListerner> listener, ReleaseId classPathreleaseId) {
        this.listener = listener;
        this.parentCL = parentCL;
        this.classPathreleaseId = classPathreleaseId;
    }

    ClasspathKieProject(ClassLoader parentCL, WeakReference<KieServicesEventListerner> listener) {
        this(parentCL, listener, null);
    }

    @Override
    public void init() {
        this.classLoader = ProjectClassLoader.createProjectClassLoader((ClassLoader)this.parentCL);
        this.discoverKieModules();
        this.indexParts(null, this.kieModules.values(), this.kJarFromKBaseName);
    }

    @Override
    public ReleaseId getGAV() {
        return this.classPathreleaseId;
    }

    @Override
    public long getCreationTimestamp() {
        return 0L;
    }

    public void discoverKieModules() {
        PortablePath[] configFiles;
        for (PortablePath configFile : configFiles = new PortablePath[]{KieModuleModelImpl.KMODULE_JAR_PATH, KieModuleModelImpl.KMODULE_SPRING_JAR_PATH}) {
            HashSet<URL> resources = new HashSet<URL>();
            try {
                for (ClassLoader currentClassLoader = this.classLoader; currentClassLoader != null; currentClassLoader = currentClassLoader.getParent()) {
                    Enumeration<URL> list = currentClassLoader.getResources(configFile.asString());
                    while (list.hasMoreElements()) {
                        resources.add(list.nextElement());
                    }
                }
            }
            catch (IOException exc) {
                log.error("Unable to find and build index of " + configFile.asString() + "." + exc.getMessage());
                return;
            }
            for (URL url : resources) {
                this.notifyKieModuleFound(url);
                try {
                    InternalKieModule kModule = ClasspathKieProject.fetchKModule(url);
                    if (kModule == null) continue;
                    ReleaseId releaseId = kModule.getReleaseId();
                    this.kieModules.put(releaseId, kModule);
                    log.debug("Discovered classpath module " + releaseId.toExternalForm());
                    this.kieRepository.addKieModule((KieModule)kModule);
                }
                catch (Exception exc) {
                    log.error("Unable to build index of kmodule.xml url=" + url.toExternalForm() + "\n" + exc.getMessage());
                }
            }
        }
    }

    private void notifyKieModuleFound(URL url) {
        log.info("Found kmodule: " + url);
        if (this.listener != null && this.listener.get() != null) {
            ((KieServicesEventListerner)this.listener.get()).onKieModuleDiscovered(new KieModuleDiscovered(url.toString()));
        }
    }

    public static InternalKieModule fetchKModule(URL url) {
        if (url.toString().equals("resource:" + KieModuleModelImpl.KMODULE_JAR_PATH.asString())) {
            return InternalKieModuleProvider.getFromClasspath();
        }
        if (url.toString().startsWith("bundle:") || url.toString().startsWith("bundleresource:")) {
            return ClasspathKieProject.fetchOsgiKModule(url);
        }
        return ClasspathKieProject.fetchKModule(url, ClasspathKieProject.fixURLFromKProjectPath(url));
    }

    private static InternalKieModule fetchOsgiKModule(URL url) {
        Method m;
        try {
            Class<?> c = Class.forName(OSGI_KIE_MODULE_CLASS_NAME);
            m = c.getMethod("create", URL.class);
        }
        catch (Exception e) {
            log.error("It is necessary to have the kie-osgi-integration module on the path in order to create a KieProject from an OSGi bundle", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            return (InternalKieModule)m.invoke(null, url);
        }
        catch (Exception e) {
            log.error("Failure creating a OsgiKieModule caused by: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static void fetchKModuleFromSpring(URL kModuleUrl) {
        try {
            Class<?> clazz = Class.forName("org.kie.spring.KModuleSpringMarshaller");
            Method method = clazz.getDeclaredMethod("fromXML", URL.class);
            method.invoke(null, kModuleUrl);
        }
        catch (Exception e) {
            log.error("It is necessary to have the kie-spring module on the path in order to create a KieProject from a spring context", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static InternalKieModule fetchKModule(URL url, String fixedURL) {
        if (url.getPath().endsWith("-spring.xml")) {
            ClasspathKieProject.fetchKModuleFromSpring(url);
            return null;
        }
        KieModuleModel kieProject = KieModuleModelImpl.fromXML(url);
        KieBuilderImpl.setDefaultsforEmptyKieModule(kieProject);
        String pomProperties = ClasspathKieProject.getPomProperties(fixedURL);
        if (pomProperties == null) {
            log.warn("Cannot find maven pom properties for this project. Using the container's default ReleaseId");
        }
        ReleaseIdImpl releaseId = pomProperties != null ? ReleaseIdImpl.fromPropertiesString((String)pomProperties) : KieServices.Factory.get().getRepository().getDefaultReleaseId();
        String rootPath = fixedURL;
        if (rootPath.lastIndexOf(58) > 0) {
            rootPath = IoUtils.asSystemSpecificPath((String)rootPath, (int)rootPath.lastIndexOf(58));
        }
        return ClasspathKieProject.createInternalKieModule(kieProject, (ReleaseId)releaseId, rootPath);
    }

    public static InternalKieModule createInternalKieModule(KieModuleModel kieProject, ReleaseId releaseId, String rootPath) {
        return InternalKieModuleProvider.get(releaseId, kieProject, new File(rootPath));
    }

    public static String getPomProperties(String urlPathToAdd) {
        String pomProperties;
        String rootPath = urlPathToAdd;
        if (rootPath.lastIndexOf(58) > 0) {
            rootPath = IoUtils.asSystemSpecificPath((String)rootPath, (int)rootPath.lastIndexOf(58));
        }
        if (urlPathToAdd.endsWith(".apk") || ClasspathKieProject.isJarFile(urlPathToAdd, rootPath) || urlPathToAdd.endsWith("/content")) {
            pomProperties = rootPath.indexOf(".jar!") > 0 ? ClasspathKieProject.getPomPropertiesFromZipStream(rootPath) : ClasspathKieProject.getPomPropertiesFromZipFile(rootPath);
        } else {
            int webInf;
            pomProperties = ClasspathKieProject.getPomPropertiesFromFileSystem(rootPath);
            if (pomProperties == null && (webInf = rootPath.indexOf("/WEB-INF")) > 0) {
                rootPath = rootPath.substring(0, webInf);
                pomProperties = ClasspathKieProject.getPomPropertiesFromFileSystem(rootPath);
            }
            if (pomProperties == null) {
                pomProperties = ClasspathKieProject.generatePomPropertiesFromPom(rootPath);
            }
        }
        if (pomProperties == null) {
            log.warn("Unable to load pom.properties from" + urlPathToAdd);
        }
        return pomProperties;
    }

    private static boolean isJarFile(String urlPathToAdd, String rootPath) {
        boolean result = false;
        if (urlPathToAdd.endsWith(".jar")) {
            File actualZipFile = new File(rootPath);
            if (actualZipFile.exists() && actualZipFile.isFile()) {
                result = true;
            } else if (urlPathToAdd.indexOf(".jar!") > 0) {
                result = true;
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPomPropertiesFromZipFile(String rootPath) {
        File actualZipFile = new File(rootPath);
        if (!actualZipFile.exists()) {
            if (rootPath.indexOf(".jar!") > 0) {
                return ClasspathKieProject.getPomPropertiesFromZipStream(rootPath);
            }
            log.error("Unable to load pom.properties from" + rootPath + " as jarPath cannot be found\n" + rootPath);
            return null;
        }
        try (ZipFile zipFile = new ZipFile(actualZipFile);){
            String file = KieBuilderImpl.findPomProperties(zipFile);
            if (file == null) {
                log.warn("Unable to find pom.properties in " + rootPath);
                String string = null;
                return string;
            }
            ZipEntry zipEntry = zipFile.getEntry(file);
            String pomProps = StringUtils.readFileAsString((Reader)new InputStreamReader(zipFile.getInputStream(zipEntry), IoUtils.UTF8_CHARSET));
            log.debug("Found and used pom.properties " + file);
            String string = pomProps;
            return string;
        }
        catch (Exception e) {
            log.error("Unable to load pom.properties from " + rootPath + "\n" + e.getMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPomPropertiesFromZipStream(String rootPath) {
        rootPath = rootPath.substring(rootPath.lastIndexOf(33) + 1);
        InputStream in = ClasspathKieProject.class.getResourceAsStream(rootPath);
        try (ZipInputStream zipIn = new ZipInputStream(in);){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                String fileName = entry.getName();
                if (fileName.endsWith("pom.properties") && fileName.startsWith("META-INF/maven/")) {
                    String string = StringUtils.readFileAsString((Reader)new InputStreamReader((InputStream)zipIn, IoUtils.UTF8_CHARSET));
                    return string;
                }
                entry = zipIn.getNextEntry();
            }
            return null;
        }
        catch (Exception e) {
            log.error("Unable to load pom.properties from zip input stream " + rootPath + "\n" + e.getMessage());
        }
        return null;
    }

    private static String getPomPropertiesFromFileSystem(String rootPath) {
        String string;
        File file = KieBuilderImpl.findPomProperties(new File(rootPath));
        if (file == null) {
            log.warn("Unable to find pom.properties in " + rootPath);
            return null;
        }
        log.debug("Found and used pom.properties " + file);
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), IoUtils.UTF8_CHARSET);
        try {
            string = StringUtils.toString((Reader)reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.warn("Unable to load pom.properties tried recursing down from " + rootPath + "\n" + e.getMessage());
                return null;
            }
        }
        ((Reader)reader).close();
        return string;
    }

    private static String generatePomPropertiesFromPom(String rootPath) {
        File file = null;
        File folder = new File(rootPath);
        while (folder.getParent() != null && !(file = new File(folder, "pom.xml")).exists()) {
            file = null;
            folder = new File(folder.getParent());
        }
        if (file != null) {
            String string;
            FileInputStream fis = new FileInputStream(file);
            try {
                PomModel pomModel = PomModel.Parser.parse((String)(rootPath + "/pom.xml"), (InputStream)fis);
                KieBuilderImpl.validatePomModel(pomModel);
                ReleaseId gav = pomModel.getReleaseId();
                String str = KieBuilderImpl.generatePomProperties(gav);
                log.info("Recursed up folders, found and used pom.xml " + file);
                string = str;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("As folder project tried to fall back to pom.xml " + file + "\nbut failed with exception:\n" + e.getMessage());
                }
            }
            fis.close();
            return string;
        } else {
            log.warn("As folder project tried to fall back to pom.xml, but could not find one");
        }
        return null;
    }

    public static String fixURLFromKProjectPath(URL url) {
        int firstSlash;
        String urlPath = url.toExternalForm();
        String urlType = "file";
        int colonIndex = urlPath.indexOf(":");
        if (colonIndex != -1) {
            urlType = urlPath.substring(0, colonIndex);
        }
        urlPath = url.getPath();
        if ("jar".equals(urlType)) {
            if (urlPath.indexOf(33) > 0) {
                urlPath = urlPath.substring(0, urlPath.lastIndexOf(33));
            }
        } else if ("vfs".equals(urlType)) {
            urlPath = ClasspathKieProject.getPathForVFS(url);
        } else if (url.toString().contains("-spring.xml")) {
            urlPath = urlPath.substring(0, urlPath.length() - ("/" + KieModuleModelImpl.KMODULE_SPRING_JAR_PATH.asString()).length());
        } else if (url.toString().endsWith(KieModuleModelImpl.KMODULE_JAR_PATH.asString())) {
            urlPath = urlPath.substring(0, urlPath.length() - ("/" + KieModuleModelImpl.KMODULE_JAR_PATH.asString()).length());
        }
        if (urlPath.endsWith(".jar!")) {
            urlPath = urlPath.substring(0, urlPath.length() - 1);
        }
        int n = colonIndex = (firstSlash = urlPath.indexOf(47)) > 0 ? urlPath.lastIndexOf(":", firstSlash) : urlPath.lastIndexOf(":");
        if (colonIndex >= 0) {
            urlPath = IoUtils.asSystemSpecificPath((String)urlPath, (int)colonIndex);
        }
        try {
            urlPath = URLDecoder.decode(urlPath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Error decoding URL (" + url + ") using UTF-8", e);
        }
        log.debug("KieModule URL type=" + urlType + " url=" + urlPath);
        return urlPath;
    }

    private static String getPathForVFS(URL url) {
        Method vfsGetPhysicalFileMethod = null;
        try {
            vfsGetPhysicalFileMethod = Class.forName("org.jboss.vfs.VirtualFile").getMethod("getPhysicalFile", new Class[0]);
        }
        catch (Exception e) {
            try {
                vfsGetPhysicalFileMethod = Class.forName("org.jboss.vfs.VirtualFile", true, Thread.currentThread().getContextClassLoader()).getMethod("getPhysicalFile", new Class[0]);
            }
            catch (Exception e1) {
                log.warn("Found virtual file " + url + " but org.jboss.vfs.VirtualFile is not available on the classpath");
            }
        }
        Class<?> vfsClass = null;
        Method vfsGetChildMethod = null;
        boolean useTccl = false;
        try {
            vfsClass = ClasspathKieProject.lookupVfsClass("org.jboss.vfs.VFS", useTccl);
            vfsGetChildMethod = Class.forName("org.jboss.vfs.VFS").getMethod("getChild", URI.class);
        }
        catch (Exception e) {
            try {
                useTccl = true;
                vfsClass = ClasspathKieProject.lookupVfsClass("org.jboss.vfs.VFS", useTccl);
                vfsGetChildMethod = vfsClass.getMethod("getChild", URI.class);
            }
            catch (Exception e1) {
                log.warn("Found virtual file " + url + " but org.jboss.vfs.VFS is not available on the classpath");
            }
        }
        if (vfsGetPhysicalFileMethod == null || vfsGetChildMethod == null) {
            return url.getPath();
        }
        String path = null;
        Object virtualFile = null;
        try {
            virtualFile = vfsGetChildMethod.invoke(null, url.toURI());
            File f = (File)vfsGetPhysicalFileMethod.invoke(virtualFile, new Object[0]);
            path = PortablePath.of((String)f.getPath()).asString();
        }
        catch (Exception e) {
            log.error("Error when reading virtual file from " + url.toString(), (Throwable)e);
        }
        if (path == null) {
            return url.getPath();
        }
        String urlString = url.toString();
        if (!urlString.contains("/" + KieModuleModelImpl.KMODULE_JAR_PATH.asString())) {
            return path;
        }
        try {
            path = ClasspathKieProject.rewriteVFSPath(path, urlString);
            if (!Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
                path = ClasspathKieProject.rewriteVFSPathAfter_7_4_15(vfsClass, virtualFile, useTccl);
            }
            log.info("Virtual file physical path = " + path);
            return path;
        }
        catch (Exception e) {
            log.error("Error when reading virtual file from " + url, (Throwable)e);
            return url.getPath();
        }
    }

    private static String rewriteVFSPath(String path, String urlString) {
        int kModulePos = urlString.length() - ("/" + KieModuleModelImpl.KMODULE_JAR_PATH.asString()).length();
        boolean isInJar = urlString.startsWith(".jar", kModulePos - 4);
        if (isInJar && ((String)path).contains("contents/")) {
            String jarName = urlString.substring(0, kModulePos);
            jarName = jarName.substring(jarName.lastIndexOf(47) + 1);
            String jarFolderPath = ((String)path).substring(0, ((String)path).length() - ("contents/" + KieModuleModelImpl.KMODULE_JAR_PATH.asString()).length());
            String jarPath = jarFolderPath + jarName;
            Object object = path = new File(jarPath).exists() ? jarPath : jarFolderPath + "content";
        }
        if (((String)path).endsWith("/kmodule.xml")) {
            return ((String)path).substring(0, ((String)path).length() - ("/" + KieModuleModelImpl.KMODULE_JAR_PATH.asString()).length());
        }
        return path;
    }

    private static String rewriteVFSPathAfter_7_4_15(Class vfsClass, Object virtualFile, boolean useTccl) throws Exception {
        Method vfsGetMountMethod = vfsClass.getDeclaredMethod("getMount", ClasspathKieProject.lookupVfsClass("org.jboss.vfs.VirtualFile", useTccl));
        vfsGetMountMethod.setAccessible(true);
        Object mount = vfsGetMountMethod.invoke(null, virtualFile);
        Method mountGetFileSystemMethod = ClasspathKieProject.lookupVfsClass("org.jboss.vfs.VFS$Mount", useTccl).getDeclaredMethod("getFileSystem", new Class[0]);
        mountGetFileSystemMethod.setAccessible(true);
        Object fileSystem = mountGetFileSystemMethod.invoke(mount, new Object[0]);
        Method fileSystemGetMountSourceMethod = ClasspathKieProject.lookupVfsClass("org.jboss.vfs.spi.FileSystem", useTccl).getMethod("getMountSource", new Class[0]);
        File mountSource = (File)fileSystemGetMountSourceMethod.invoke(fileSystem, new Object[0]);
        return mountSource.getPath();
    }

    private static Class<?> lookupVfsClass(String classname, boolean useTccl) throws ClassNotFoundException {
        return useTccl ? Class.forName(classname, true, Thread.currentThread().getContextClassLoader()) : Class.forName(classname);
    }

    @Override
    public InternalKieModule getKieModuleForKBase(String kBaseName) {
        return this.kJarFromKBaseName.get(kBaseName);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public InputStream getPomAsStream() {
        return this.classLoader.getResourceAsStream("pom.xml");
    }
}

