/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.ParserError;
import org.drools.lang.RuleParser;
import org.drools.lang.RuleParserLexer;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.dsl.DefaultExpanderResolver;

public class DrlParser {
    private List results = new ArrayList();

    public PackageDescr parse(String text) throws DroolsParserException {
        RuleParser parser = this.getParser(text);
        this.compile(parser);
        return parser.getPackageDescr();
    }

    private void compile(RuleParser parser) throws DroolsParserException {
        try {
            parser.compilation_unit();
            this.makeErrorList(parser);
        }
        catch (RecognitionException e) {
            throw new DroolsParserException(e);
        }
    }

    private void makeErrorList(RuleParser parser) {
        Iterator iter = parser.getErrors().iterator();
        while (iter.hasNext()) {
            RecognitionException recogErr = (RecognitionException)((Object)iter.next());
            ParserError err = new ParserError(parser.createErrorMessage(recogErr), recogErr.line, recogErr.charPositionInLine);
            this.results.add(err);
        }
    }

    private RuleParser getParser(String text) {
        return new RuleParser((TokenStream)new CommonTokenStream((TokenSource)new RuleParserLexer((CharStream)new ANTLRStringStream(text))));
    }

    public PackageDescr parse(Reader reader) throws IOException, DroolsParserException {
        StringBuffer text = this.getDRLText(reader);
        return this.parse(text.toString());
    }

    public PackageDescr parse(Reader drl, Reader dsl) throws DroolsParserException, IOException {
        StringBuffer text = this.getDRLText(drl);
        return this.parse(text.toString(), dsl);
    }

    public PackageDescr parse(String source, Reader dsl) throws DroolsParserException {
        DefaultExpanderResolver resolver = new DefaultExpanderResolver(dsl);
        RuleParser parser = this.getParser(source);
        parser.setExpanderResolver(resolver);
        this.compile(parser);
        return parser.getPackageDescr();
    }

    private StringBuffer getDRLText(Reader reader) throws IOException {
        StringBuffer text = new StringBuffer();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return text;
    }

    public boolean hasErrors() {
        return this.results.size() > 0;
    }

    public List getErrors() {
        return this.results;
    }
}

