/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.jci.compilers.CompilationResult;
import org.apache.commons.jci.compilers.JavaCompiler;
import org.apache.commons.jci.compilers.JavaCompilerFactory;
import org.apache.commons.jci.readers.MemoryResourceReader;
import org.apache.commons.jci.readers.ResourceReader;
import org.apache.commons.jci.stores.ResourceStore;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsError;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.FunctionError;
import org.drools.compiler.GlobalError;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.RuleError;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.semantics.java.ClassTypeResolver;
import org.drools.semantics.java.FunctionBuilder;
import org.drools.semantics.java.PackageStore;
import org.drools.semantics.java.RuleBuilder;
import org.drools.xml.XmlPackageReader;
import org.xml.sax.SAXException;

public class PackageBuilder {
    private JavaCompiler compiler;
    private Package pkg;
    private List results;
    private PackageStore packageStoreWrapper;
    private MemoryResourceReader src;
    private PackageBuilderConfiguration configuration;

    public PackageBuilder() {
        this(null, null);
    }

    public PackageBuilder(Package pkg) {
        this(pkg, null);
    }

    public PackageBuilder(Package pkg, PackageBuilderConfiguration configuration) {
        if (configuration == null) {
            configuration = new PackageBuilderConfiguration();
        }
        this.compiler = this.getCompiler(configuration.getCompiler());
        this.configuration = configuration;
        this.src = new MemoryResourceReader();
        this.results = new ArrayList();
        this.pkg = pkg;
        if (pkg != null) {
            this.packageStoreWrapper = new PackageStore(pkg.getPackageCompilationData());
        }
    }

    public void addPackageFromDrl(Reader reader) throws DroolsParserException, IOException {
        DrlParser parser = new DrlParser();
        PackageDescr pkg = parser.parse(reader);
        this.results.addAll(parser.getErrors());
        this.addPackage(pkg);
    }

    public void addPackageFromXml(Reader reader) throws DroolsParserException, IOException {
        XmlPackageReader xmlReader = new XmlPackageReader();
        try {
            xmlReader.read(reader);
        }
        catch (SAXException e) {
            throw new DroolsParserException(((Throwable)e).getCause());
        }
        this.addPackage(xmlReader.getPackageDescr());
    }

    public void addPackageFromDrl(Reader source, Reader dsl) throws DroolsParserException, IOException {
        DrlParser parser = new DrlParser();
        PackageDescr pkg = parser.parse(source, dsl);
        this.results.addAll(parser.getErrors());
        this.addPackage(pkg);
    }

    public void addPackage(PackageDescr packageDescr) {
        if (packageDescr.getName() == null || "".equals(packageDescr.getName())) {
            throw new MissingPackageNameException("Missing package name for rule package.");
        }
        if (this.pkg != null) {
            this.mergePackage(this.pkg, packageDescr);
        } else {
            this.pkg = this.newPackage(packageDescr);
        }
        if (!this.hasErrors()) {
            Iterator it = packageDescr.getFunctions().iterator();
            while (it.hasNext()) {
                this.addFunction((FunctionDescr)it.next());
            }
            it = packageDescr.getRules().iterator();
            while (it.hasNext()) {
                this.addRule((RuleDescr)it.next());
            }
        }
    }

    private Package newPackage(PackageDescr packageDescr) {
        Package pkg = new Package(packageDescr.getName(), this.configuration.getClassLoader());
        this.packageStoreWrapper = new PackageStore(pkg.getPackageCompilationData());
        this.mergePackage(pkg, packageDescr);
        return pkg;
    }

    private void mergePackage(Package pkg, PackageDescr packageDescr) {
        List imports = packageDescr.getImports();
        Iterator it = imports.iterator();
        while (it.hasNext()) {
            pkg.addImport((String)it.next());
        }
        ClassTypeResolver typeResolver = new ClassTypeResolver(imports, pkg.getPackageCompilationData().getClassLoader());
        Map globals = packageDescr.getGlobals();
        Iterator it2 = globals.keySet().iterator();
        while (it2.hasNext()) {
            String identifier = (String)it2.next();
            String className = (String)globals.get(identifier);
            try {
                Class clazz = typeResolver.resolveType(className);
                pkg.addGlobal(identifier, clazz);
            }
            catch (ClassNotFoundException e) {
                new GlobalError(identifier);
            }
        }
    }

    private CompilationResult compile(String className, String text, MemoryResourceReader src, ResourceStore dst) {
        src.add(className.replace('.', '/') + ".java", text.getBytes());
        CompilationResult result = this.compiler.compile(new String[]{className}, (ResourceReader)src, dst, this.pkg.getPackageCompilationData().getClassLoader());
        return result;
    }

    private void addFunction(FunctionDescr functionDescr) {
        FunctionBuilder buidler = new FunctionBuilder();
        CompilationResult result = this.compile(this.pkg.getName() + "." + this.ucFirst(functionDescr.getName()), buidler.build(this.pkg, functionDescr), this.src, this.packageStoreWrapper);
        if (result.getErrors().length > 0) {
            this.results.add(new FunctionError(functionDescr, result.getErrors(), "Function Compilation error"));
        }
    }

    private void addRule(RuleDescr ruleDescr) {
        String ruleClassName = this.getUniqueLegalName(this.pkg.getName(), ruleDescr.getName(), "java", (ResourceReader)this.src);
        ruleDescr.SetClassName(this.ucFirst(ruleClassName));
        RuleBuilder builder = new RuleBuilder();
        builder.build(this.pkg, ruleDescr);
        this.results.addAll(builder.getErrors());
        Rule rule = builder.getRule();
        if (builder.getRuleClass() != null) {
            this.compileRule(builder, rule, ruleDescr);
        }
        this.pkg.addRule(rule);
    }

    public void compileRule(RuleBuilder builder, Rule rule, RuleDescr ruleDescr) {
        CompilationResult result = this.compile(this.pkg.getName() + "." + ruleDescr.getClassName(), builder.getRuleClass(), this.src, this.packageStoreWrapper);
        if (result.getErrors().length > 0) {
            this.results.add(new RuleError(rule, ruleDescr, result.getErrors(), "Rule Compilation error"));
        } else {
            Iterator it = builder.getInvokers().keySet().iterator();
            while (it.hasNext()) {
                String text;
                String className = (String)it.next();
                Object invoker = builder.getInvokerLookups().get(className);
                if (invoker != null) {
                    this.pkg.getPackageCompilationData().putInvoker(className, invoker);
                }
                if ((result = this.compile(className, text = (String)builder.getInvokers().get(className), this.src, this.packageStoreWrapper)).getErrors().length <= 0) continue;
                PatternDescr descr = (PatternDescr)builder.getDescrLookups().get(className);
                this.results.add(new RuleError(rule, descr, result.getErrors(), "Rule Compilation error for Invoker"));
            }
        }
    }

    public Package getPackage() {
        if (this.hasErrors()) {
            this.pkg.setError(this.printErrors());
        }
        return this.pkg;
    }

    public boolean hasErrors() {
        return this.results.size() > 0;
    }

    public DroolsError[] getErrors() {
        return this.results.toArray(new DroolsError[this.results.size()]);
    }

    public String printErrors() {
        StringBuffer buf = new StringBuffer();
        Iterator iter = this.results.iterator();
        while (iter.hasNext()) {
            DroolsError err = (DroolsError)iter.next();
            buf.append(err.getMessage());
            buf.append("\n");
        }
        return buf.toString();
    }

    private String getUniqueLegalName(String packageName, String name, String ext, ResourceReader src) {
        String newName = "Rule_" + name.replaceAll("[^\\w$]", "_");
        int counter = -1;
        boolean exists = true;
        while (exists) {
            String fileName = packageName.replaceAll("\\.", "/") + newName + "_" + ++counter + ext;
            exists = src.isAvailable(fileName);
        }
        if (counter >= 0) {
            newName = newName + "_" + counter;
        }
        return newName;
    }

    private JavaCompiler getCompiler(int compiler) {
        switch (compiler) {
            case 1: {
                return JavaCompilerFactory.getInstance().createCompiler("janino");
            }
        }
        return JavaCompilerFactory.getInstance().createCompiler("eclipse");
    }

    private String ucFirst(String name) {
        return name.toUpperCase().charAt(0) + name.substring(1);
    }

    public static class MissingPackageNameException
    extends IllegalArgumentException {
        public MissingPackageNameException(String message) {
            super(message);
        }
    }
}

