/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import org.drools.RuntimeDroolsException;

public class PackageBuilderConfiguration {
    public static final int ECLIPSE = 0;
    public static final int JANINO = 1;
    private static final int CONFIGURED_COMPILER = PackageBuilderConfiguration.getDefaultCompiler();
    private int compiler = CONFIGURED_COMPILER;
    private ClassLoader classLoader;

    public PackageBuilderConfiguration() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.classLoader = classLoader;
    }

    public int getCompiler() {
        return this.compiler;
    }

    public void setCompiler(int compiler) {
        switch (compiler) {
            case 0: {
                this.compiler = 0;
                break;
            }
            case 1: {
                this.compiler = 1;
                break;
            }
            default: {
                throw new RuntimeDroolsException("value '" + compiler + "' is not a valid compiler");
            }
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            this.classLoader = classLoader;
        }
    }

    static int getDefaultCompiler() {
        try {
            String prop = System.getProperty("drools.compiler", "ECLIPSE");
            if (prop.equals("ECLIPSE".intern())) {
                return 0;
            }
            if (prop.equals("JANINO")) {
                return 1;
            }
            System.err.println("Drools config: unable to use the drools.compiler property. Using default. It was set to:" + prop);
            return 0;
        }
        catch (SecurityException e) {
            System.err.println("Drools config: unable to read the drools.compiler property. Using default.");
            return 0;
        }
    }
}

