/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.BoundVariableDescr;
import org.drools.lang.descr.ColumnDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.FieldBindingDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.LiteralDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.PackageDescrDumper;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.ReturnValueDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.util.ReflectiveVisitor;

public class DrlDumper
extends ReflectiveVisitor
implements PackageDescrDumper {
    private StringBuffer drlDump;
    private static final String eol = System.getProperty("line.separator");
    private String template;

    public synchronized String dump(PackageDescr packageDescr) {
        this.drlDump = new StringBuffer();
        this.visitPackageDescr(packageDescr);
        return this.drlDump.toString();
    }

    public void visitAndDescr(AndDescr descr) {
        this.template = new String();
        this.template = descr.getDescrs() != Collections.EMPTY_LIST ? this.processDescrList(descr.getDescrs()) : "";
    }

    public void visitAttributeDescr(AttributeDescr attributeDescr) {
        this.template = new String();
        this.template = "\t " + attributeDescr.getName() + " " + attributeDescr.getValue() + eol;
    }

    public void visitBoundVariableDescr(BoundVariableDescr descr) {
        this.template = new String();
        this.template = descr.getFieldName() + " " + descr.getEvaluator() + " " + descr.getIdentifier();
    }

    public void visitColumnDescr(ColumnDescr descr) {
        this.template = new String();
        this.template = descr.getDescrs() != Collections.EMPTY_LIST ? (descr.getIdentifier() != null ? "\t\t" + descr.getIdentifier() + " : " + descr.getObjectType() + "( " + this.processColoumnConstraintList(descr.getDescrs()) + ")" : "\t\t" + descr.getObjectType() + "( " + this.processColoumnConstraintList(descr.getDescrs()) + ")") : (descr.getIdentifier() != null ? "\t\t" + descr.getIdentifier() + " : " + descr.getObjectType() + "( )" : "\t\t" + descr.getObjectType() + "( )");
    }

    public void visitEvalDescr(EvalDescr descr) {
        this.template = new String();
        this.template = "\t\teval ( " + descr.getText() + " )" + eol;
    }

    public void visitExistsDescr(ExistsDescr descr) {
        this.template = new String();
        this.template = descr.getDescrs() != Collections.EMPTY_LIST ? "\t\texists " + this.processDescrList(descr.getDescrs()) : "";
    }

    public void visitFieldBindingDescr(FieldBindingDescr descr) {
        this.template = new String();
        this.template = descr.getIdentifier() + " : ";
    }

    public void visitFunctionDescr(FunctionDescr functionDescr) {
        this.template = new String();
        String parameterTemplate = this.processParameters(functionDescr.getParameterNames(), functionDescr.getParameterTypes());
        this.template = "function " + functionDescr.getReturnType() + " " + functionDescr.getName() + "(" + parameterTemplate + "){" + functionDescr.getText() + eol + "}" + eol;
    }

    public void visitLiteralDescr(LiteralDescr descr) {
        this.template = new String();
        String text = descr.getText();
        try {
            Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            text = "\"" + text + "\"";
        }
        this.template = descr.getFieldName() + " " + descr.getEvaluator() + " " + text;
    }

    public void visitNotDescr(NotDescr descr) {
        this.template = new String();
        this.template = descr.getDescrs() != Collections.EMPTY_LIST ? "\t   not " + this.processDescrList(descr.getDescrs()) : "";
    }

    public void visitOrDescr(OrDescr descr) {
        this.template = new String();
        this.template = descr.getDescrs() != Collections.EMPTY_LIST ? this.processOrDescrList(descr.getDescrs()) : " ";
    }

    public void visitPackageDescr(PackageDescr packageDescr) {
        String packageName = packageDescr.getName();
        String xmlString = "package " + packageName + ";" + eol + eol;
        this.appendDrlDump(xmlString);
        if (packageDescr.getImports() != null) {
            this.appendDrlDump(this.processImportsList(packageDescr.getImports()));
        }
        if (packageDescr.getGlobals() != null) {
            this.appendDrlDump(this.processGlobalsMap(packageDescr.getGlobals()));
        }
        if (packageDescr.getFunctions() != null) {
            this.appendDrlDump(this.processFunctionsList(packageDescr.getFunctions()));
        }
        if (packageDescr.getRules() != null) {
            this.appendDrlDump(this.processRules(packageDescr.getRules()));
        }
    }

    public void visitPredicateDescr(PredicateDescr descr) {
        this.template = new String();
        this.template = descr.getDeclaration() + ":" + descr.getFieldName() + " -> ( " + descr.getText() + " )";
    }

    public void visitReturnValueDescr(ReturnValueDescr descr) {
        this.template = new String();
        this.template = descr.getFieldName() + " " + descr.getEvaluator() + " ( " + descr.getText() + ")";
    }

    public void visitQueryDescr(QueryDescr descr) {
        this.template = new String();
        this.template = "<query name=\"" + descr.getName() + "\">" + "<lhs>" + this.processDescrList(descr.getLhs().getDescrs()) + "</lhs>" + "</query>";
    }

    private String processRules(List rules) {
        String ruleList = "";
        Iterator iterator = rules.iterator();
        while (iterator.hasNext()) {
            RuleDescr ruleDescr = (RuleDescr)iterator.next();
            String rule = "rule \"" + ruleDescr.getName() + "\" " + eol;
            String attribute = this.processAttribute(ruleDescr.getAttributes());
            String lhs = "";
            lhs = ruleDescr.getLhs().getDescrs() != Collections.EMPTY_LIST ? "\t when" + eol + this.processDescrList(ruleDescr.getLhs().getDescrs()) + eol : "\t when";
            String rhs = ruleDescr.getConsequence();
            rhs = rhs == null ? "\t then" + eol + "\t" : "\t then" + eol + "\t\t" + ruleDescr.getConsequence();
            rule = rule + attribute;
            rule = rule + lhs;
            rule = rule + rhs;
            rule = rule + "end" + eol;
            ruleList = ruleList + rule;
        }
        return ruleList + eol;
    }

    private String processOrDescrList(List descr) {
        String descrString = "";
        Iterator iterator = descr.iterator();
        while (iterator.hasNext()) {
            this.visit(iterator.next());
            descrString = descrString + this.template;
            if (descrString.endsWith(eol)) {
                descrString = descrString.substring(0, descrString.indexOf(eol));
            }
            descrString = descrString + " || ";
        }
        return descrString.substring(0, descrString.length() - 4);
    }

    private String processColoumnConstraintList(List descr) {
        String descrString = "";
        Iterator iterator = descr.iterator();
        while (iterator.hasNext()) {
            Object temp = iterator.next();
            this.visit(temp);
            descrString = descrString + this.template;
            if (temp instanceof FieldBindingDescr) continue;
            descrString = descrString + " , ";
        }
        return descrString.substring(0, descrString.length() - 2);
    }

    private String processDescrList(List descr) {
        String descrString = "";
        Iterator iterator = descr.iterator();
        while (iterator.hasNext()) {
            this.visit(iterator.next());
            descrString = descrString + this.template;
            descrString = descrString + eol;
        }
        return descrString;
    }

    private String processFunctionsList(List functions) {
        String functionList = "";
        Iterator iterator = functions.iterator();
        while (iterator.hasNext()) {
            this.visit(iterator.next());
            functionList = functionList + this.template;
        }
        return functionList + eol;
    }

    private String processAttribute(List attributes) {
        String attributeList = "";
        Iterator iterator = attributes.iterator();
        while (iterator.hasNext()) {
            AttributeDescr attributeDescr = (AttributeDescr)iterator.next();
            this.visit(attributeDescr);
            attributeList = attributeList + this.template;
        }
        return attributeList;
    }

    private String processParameters(List parameterNames, List parameterTypes) {
        String paramList = "";
        int i = 0;
        Iterator iterator = parameterNames.iterator();
        while (iterator.hasNext()) {
            String paramName = (String)iterator.next();
            String paramType = (String)parameterTypes.get(i);
            String paramTemplate = paramType + " " + paramName + ",";
            paramList = paramList + paramTemplate;
            ++i;
        }
        paramList = paramList.substring(0, paramList.length() - 1);
        return paramList;
    }

    private String processGlobalsMap(Map globals) {
        String globalList = "";
        Iterator iterator = globals.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = (String)globals.get(key);
            String globalTemplate = "global " + value + " " + key + ";" + eol;
            globalList = globalList + globalTemplate;
        }
        return globalList + eol;
    }

    private String processImportsList(List imports) {
        String importList = "";
        Iterator iterator = imports.iterator();
        while (iterator.hasNext()) {
            String importString = (String)iterator.next();
            String importTemplate = "import " + importString + ";" + eol;
            importList = importList + importTemplate;
        }
        return importList + eol;
    }

    private void appendDrlDump(String temp) {
        this.drlDump.append(temp);
    }
}

