/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl.template;

import java.util.Map;
import org.apache.commons.lang.StringUtils;

class Chunk {
    final String text;
    final boolean isHole;
    Chunk next;
    String padL = "";
    String padR = "";
    String value;

    Chunk(String text) {
        this.text = text;
        this.isHole = text.startsWith("{");
    }

    void buildSubtitutionKey(StringBuffer buffer) {
        if (this.isHole) {
            buffer.append(this.padL + this.value + this.padR);
        } else {
            buffer.append(this.text);
        }
        if (this.next != null) {
            this.next.buildSubtitutionKey(buffer);
        }
    }

    void process(String expression) {
        if (this.isHole) {
            if (this.next == null || this.next.text == null) {
                this.storeSpacePadding(expression);
                this.value = expression.trim();
            } else {
                String val = StringUtils.substringBefore((String)expression, (String)this.next.text);
                this.storeSpacePadding(val);
                this.value = val.trim();
            }
        } else {
            this.value = this.text;
        }
        if (this.next != null) {
            this.next.process(StringUtils.substringAfter((String)expression, (String)this.value));
        }
    }

    private void storeSpacePadding(String val) {
        if (val.startsWith(" ")) {
            this.padL = " ";
        }
        if (val.endsWith(" ")) {
            this.padR = " ";
        }
    }

    void buildValueMap(Map map) {
        if (this.isHole) {
            map.put(this.text, this.value);
        }
        if (this.next != null) {
            this.next.buildValueMap(map);
        }
    }

    void addToEnd(Chunk chunk) {
        if (this.next == null) {
            this.next = chunk;
        } else {
            this.next.addToEnd(chunk);
        }
    }

    public void clearValues() {
        this.value = null;
        if (this.next != null) {
            this.next.clearValues();
        }
    }
}

