/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl.template;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.lang.dsl.template.MappingError;

public class NLMappingItem
implements Serializable {
    private static final long serialVersionUID = 7185580607729787497L;
    private static final Pattern tokenPattern = Pattern.compile("\\{(\\w*)\\}");
    private static final Pattern invalidPattern1 = Pattern.compile("\\{\\w*(\\z|[^\\}\\w])");
    private static final Pattern invalidPattern2 = Pattern.compile("[^\\{\\w]\\w*\\}");
    private String naturalTemplate;
    private String targetTemplate;
    private String scope;

    public void setNaturalTemplate(String naturalTemplate) {
        this.naturalTemplate = naturalTemplate.replaceAll("\\s*,\\s*", " , ");
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setTargetTemplate(String targetTemplate) {
        this.targetTemplate = targetTemplate;
    }

    public NLMappingItem(String naturalTemplate, String targetTemplate, String scope) {
        this.setNaturalTemplate(naturalTemplate);
        this.setTargetTemplate(targetTemplate);
        this.setScope(scope);
    }

    public String getNaturalTemplate() {
        return this.naturalTemplate;
    }

    public String getTargetTemplate() {
        return this.targetTemplate;
    }

    public String getScope() {
        return this.scope;
    }

    public List validateTokenUsage() {
        NLMappingItem item = this;
        ArrayList<MappingError> result = new ArrayList<MappingError>();
        Matcher natural = tokenPattern.matcher(item.getNaturalTemplate());
        Matcher target = tokenPattern.matcher(item.getTargetTemplate());
        HashSet<String> naturalSet = new HashSet<String>();
        HashSet<String> targetSet = new HashSet<String>();
        while (natural.find()) {
            naturalSet.add(natural.group());
        }
        while (target.find()) {
            targetSet.add(target.group());
        }
        if (!((Object)naturalSet).equals(targetSet)) {
            String token;
            HashSet aux = new HashSet(naturalSet);
            naturalSet.removeAll(targetSet);
            targetSet.removeAll(aux);
            Iterator i = naturalSet.iterator();
            while (i.hasNext()) {
                token = (String)i.next();
                result.add(new MappingError(21, 1, item.getNaturalTemplate().indexOf(token), token, this.naturalTemplate));
            }
            i = targetSet.iterator();
            while (i.hasNext()) {
                token = (String)i.next();
                result.add(new MappingError(22, 2, item.getTargetTemplate().indexOf(token), token, this.naturalTemplate));
            }
        }
        return result;
    }

    public List validateUnmatchingBraces() {
        String token;
        NLMappingItem item = this;
        ArrayList<MappingError> result = new ArrayList<MappingError>();
        Matcher natural1 = invalidPattern1.matcher(item.getNaturalTemplate());
        Matcher natural2 = invalidPattern2.matcher(item.getNaturalTemplate());
        Matcher target1 = invalidPattern1.matcher(item.getTargetTemplate());
        Matcher target2 = invalidPattern2.matcher(item.getTargetTemplate());
        while (natural1.find()) {
            token = natural1.group();
            result.add(new MappingError(23, 1, natural1.start(), token, this.naturalTemplate));
        }
        while (natural2.find()) {
            token = natural2.group();
            result.add(new MappingError(24, 1, natural2.start(), token, this.naturalTemplate));
        }
        while (target1.find()) {
            token = target1.group();
            result.add(new MappingError(23, 2, target1.start(), token, this.naturalTemplate));
        }
        while (target2.find()) {
            token = target2.group();
            result.add(new MappingError(24, 2, target2.start(), token, this.naturalTemplate));
        }
        return result;
    }
}

