/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl.template;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.lang.dsl.template.Template;

class TemplateFactory {
    TemplateFactory() {
    }

    public Template getTemplate(String naturalTemplate) {
        Template template = new Template();
        List chunkList = this.lexChunks(naturalTemplate);
        Iterator iter = chunkList.iterator();
        while (iter.hasNext()) {
            template.addChunk((String)iter.next());
        }
        return template;
    }

    List lexChunks(String grammarTemplate) {
        ChunkLexer lexer = new ChunkLexer();
        return lexer.lex(grammarTemplate);
    }

    static class ChunkLexer {
        private List chunks = new ArrayList();
        private StringBuffer buffer = new StringBuffer();

        ChunkLexer() {
        }

        public List lex(String grammarTemplate) {
            char[] chars = grammarTemplate.toCharArray();
            block4: for (int i = 0; i < chars.length; ++i) {
                switch (chars[i]) {
                    case '{': {
                        this.startHole();
                        continue block4;
                    }
                    case '}': {
                        this.endHole();
                        continue block4;
                    }
                    default: {
                        this.buffer.append(chars[i]);
                    }
                }
            }
            String buf = this.buffer.toString();
            if (!buf.equals("")) {
                this.addChunk(buf);
            }
            return this.chunks;
        }

        private boolean addChunk(String buf) {
            return this.chunks.add(buf.trim());
        }

        private void endHole() {
            String buf = this.buffer.toString();
            this.chunks.add("{" + buf + "}");
            this.buffer = new StringBuffer();
        }

        private void startHole() {
            String buf = this.buffer.toString();
            if (!buf.equals("")) {
                this.addChunk(buf);
            }
            this.buffer = new StringBuffer();
        }
    }
}

