/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.java;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.spi.TypeResolver;

public class ClassTypeResolver
implements TypeResolver {
    private final List imports;
    private final ClassLoader classLoader;
    private Map cachedImports = new HashMap();

    public ClassTypeResolver(List imports) {
        this(imports, null);
    }

    public ClassTypeResolver(List imports, ClassLoader classLoader) {
        this.imports = imports;
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.classLoader = classLoader;
    }

    public List getImports() {
        return this.imports;
    }

    public void addImport(String importEntry) {
        if (!this.imports.contains(importEntry)) {
            this.imports.add(importEntry);
        }
    }

    public Class lookupFromCache(String className) {
        return (Class)this.cachedImports.get(className);
    }

    public Class resolveType(String className) throws ClassNotFoundException {
        Class clazz = null;
        try {
            clazz = this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            clazz = null;
        }
        if (clazz == null) {
            clazz = this.lookupFromCache(className);
        }
        if (clazz == null) {
            HashSet<Class> validClazzCandidates = new HashSet<Class>();
            Iterator it = this.imports.iterator();
            while (it.hasNext()) {
                clazz = this.importClass((String)it.next(), className);
                if (clazz == null) continue;
                validClazzCandidates.add(clazz);
            }
            if (validClazzCandidates.size() > 1) {
                StringBuffer sb = new StringBuffer();
                Iterator clazzCandIter = validClazzCandidates.iterator();
                while (clazzCandIter.hasNext()) {
                    if (0 != sb.length()) {
                        sb.append(", ");
                    }
                    sb.append(((Class)clazzCandIter.next()).getName());
                }
                throw new Error("Unable to find unambiguously defined class '" + className + "', candidates are: [" + sb.toString() + "]");
            }
            clazz = validClazzCandidates.size() == 1 ? (Class)validClazzCandidates.toArray()[0] : null;
        }
        if (clazz == null) {
            throw new ClassNotFoundException("Unable to find class '" + className + "'");
        }
        return clazz;
    }

    private Class importClass(String importText, String className) {
        String qualifiedClass = null;
        Class<?> clazz = null;
        if (importText.endsWith("*")) {
            qualifiedClass = importText.substring(0, importText.indexOf(42)) + className;
        } else if (importText.endsWith("." + className)) {
            qualifiedClass = importText;
        } else if (importText.equals(className)) {
            qualifiedClass = importText;
        }
        if (qualifiedClass != null) {
            try {
                clazz = this.classLoader.loadClass(qualifiedClass);
            }
            catch (ClassNotFoundException e) {
                clazz = null;
            }
            if (clazz == null) {
                try {
                    int lastIndex = qualifiedClass.lastIndexOf(46);
                    qualifiedClass = qualifiedClass.substring(0, lastIndex) + "$" + qualifiedClass.substring(lastIndex + 1);
                    clazz = this.classLoader.loadClass(qualifiedClass);
                }
                catch (ClassNotFoundException e) {
                    clazz = null;
                }
            }
        }
        if (clazz != null) {
            if (this.cachedImports == Collections.EMPTY_MAP) {
                this.cachedImports = new HashMap();
            }
            this.cachedImports.put(className, clazz);
        }
        return clazz;
    }

    public boolean isEmpty() {
        return this.imports.isEmpty();
    }
}

