/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.java;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FunctionFixer {
    static Pattern FUNCTION = Pattern.compile("(\\S*\\s*|\\.\\s*)\\b([\\S&&[^\\.]]+)\\s*\\(([^)]*)\\)", 32);
    static final Set KEYWORDS = FunctionFixer.getJavaKeywords();

    public String fix(String raw) {
        return this.fix(raw, FUNCTION);
    }

    public String fix(String raw, Pattern pattern) {
        if (raw == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int lastIndex = 0;
        Matcher matcher = pattern.matcher(raw);
        while (matcher.find()) {
            String function;
            String trimmedPre;
            String pre = matcher.group(1);
            if (matcher.group(1) != null && ((trimmedPre = pre.trim()).endsWith(".") || trimmedPre.endsWith("new")) || KEYWORDS.contains(function = matcher.group(2).trim())) continue;
            String params = matcher.group(3).trim();
            String target = this.ucFirst(function) + "." + function + "(" + params + ")";
            buf.append(raw.substring(lastIndex, matcher.start(2)));
            buf.append(target);
            lastIndex = matcher.end();
        }
        buf.append(raw.substring(lastIndex));
        return buf.toString();
    }

    private String ucFirst(String name) {
        return name.toUpperCase().charAt(0) + name.substring(1);
    }

    private static Set getJavaKeywords() {
        HashSet<String> keys = new HashSet<String>();
        keys.add("abstract");
        keys.add("continue");
        keys.add("for");
        keys.add("new");
        keys.add("switch");
        keys.add("assert");
        keys.add("default");
        keys.add("goto");
        keys.add("package");
        keys.add("synchronized");
        keys.add("boolean");
        keys.add("do");
        keys.add("if");
        keys.add("private");
        keys.add("this");
        keys.add("break");
        keys.add("double");
        keys.add("implements");
        keys.add("protected");
        keys.add("throw");
        keys.add("byte");
        keys.add("else");
        keys.add("import");
        keys.add("public");
        keys.add("throws");
        keys.add("case");
        keys.add("enum");
        keys.add("instanceof");
        keys.add("return");
        keys.add("transient");
        keys.add("catch");
        keys.add("extends");
        keys.add("int");
        keys.add("short");
        keys.add("try");
        keys.add("char");
        keys.add("final");
        keys.add("interface");
        keys.add("static");
        keys.add("void");
        keys.add("class");
        keys.add("finally");
        keys.add("long");
        keys.add("strictfp");
        keys.add("volatile");
        keys.add("const");
        keys.add("float");
        keys.add("native");
        keys.add("super");
        keys.add("while");
        return keys;
    }
}

