/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.java;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KnowledgeHelperFixer {
    static String KNOWLEDGE_HELPER_PFX = "";
    static Pattern MODIFY = Pattern.compile("(.*)\\b" + KNOWLEDGE_HELPER_PFX + "modify\\s*\\(([^)]+)\\)(.*)", 32);
    static Pattern ASSERT = Pattern.compile("(.*)\\b" + KNOWLEDGE_HELPER_PFX + "assert\\s*\\((.*)\\)(.*)", 32);
    static Pattern ASSERT_LOGICAL = Pattern.compile("(.*)\\b" + KNOWLEDGE_HELPER_PFX + "assertLogical\\s*\\((.*)\\)(.*)", 32);
    static Pattern RETRACT = Pattern.compile("(.*)\\b" + KNOWLEDGE_HELPER_PFX + "retract\\s*\\(([^)]+)\\)(.*)", 32);

    public String fix(String raw) {
        String result = this.fix(raw, ModifyReplacer.INSTANCE);
        result = this.fix(result, AssertReplacer.INSTANCE);
        result = this.fix(result, AssertLogicalReplacer.INSTANCE);
        result = this.fix(result, RetractReplacer.INSTANCE);
        return result;
    }

    public String fix(String raw, Replacer replacer) {
        if (raw == null) {
            return null;
        }
        Matcher matcher = replacer.getPattern().matcher(raw);
        if (matcher.matches()) {
            String pre = matcher.group(1);
            if (matcher.group(1) != null) {
                pre = this.fix(pre, replacer);
            }
            String obj = matcher.group(2).trim();
            String post = matcher.group(3);
            if (post != null) {
                post = this.fix(post, replacer);
            }
            String replacement = this.escapeDollarSigns(replacer, obj);
            return pre + matcher.replaceAll(replacement) + post;
        }
        return raw;
    }

    private String escapeDollarSigns(Replacer replacer, String obj) {
        return KnowledgeHelperFixer.replace(replacer.getReplacement(obj), "$", "\\$", 256);
    }

    static String replace(String text, String repl, String with, int max) {
        if (text == null || repl == null || repl.equals("") || with == null || max == 0) {
            return text;
        }
        StringBuffer buf = new StringBuffer(text.length());
        int start = 0;
        int end = 0;
        while ((end = text.indexOf(repl, start)) != -1) {
            buf.append(text.substring(start, end)).append(with);
            start = end + repl.length();
            if (--max != 0) continue;
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    static class RetractReplacer
    implements Replacer {
        static Replacer INSTANCE = new RetractReplacer();

        RetractReplacer() {
        }

        public Pattern getPattern() {
            return RETRACT;
        }

        public String getReplacement(String guts) {
            return "drools.retractObject(" + guts.trim() + "__Handle__)";
        }
    }

    static class ModifyReplacer
    implements Replacer {
        static Replacer INSTANCE = new ModifyReplacer();

        ModifyReplacer() {
        }

        public Pattern getPattern() {
            return MODIFY;
        }

        public String getReplacement(String guts) {
            return "drools.modifyObject(" + guts.trim() + "__Handle__, " + guts + ")";
        }
    }

    static class AssertLogicalReplacer
    implements Replacer {
        static Replacer INSTANCE = new AssertLogicalReplacer();

        AssertLogicalReplacer() {
        }

        public Pattern getPattern() {
            return ASSERT_LOGICAL;
        }

        public String getReplacement(String guts) {
            return "drools.assertLogicalObject(" + guts + ")";
        }
    }

    static class AssertReplacer
    implements Replacer {
        static Replacer INSTANCE = new AssertReplacer();

        AssertReplacer() {
        }

        public Pattern getPattern() {
            return ASSERT;
        }

        public String getReplacement(String guts) {
            return "drools.assertObject(" + guts + ")";
        }
    }

    static interface Replacer {
        public Pattern getPattern();

        public String getReplacement(String var1);
    }
}

