/*
 * Decompiled with CFR 0.152.
 */
package org.drools.xml;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.BoundVariableDescr;
import org.drools.lang.descr.ColumnDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.FieldBindingDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.LiteralDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.PackageDescrDumper;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.ReturnValueDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.util.ReflectiveVisitor;

public class XmlDumper
extends ReflectiveVisitor
implements PackageDescrDumper {
    private StringBuffer xmlDump;
    private static final String eol = System.getProperty("line.separator");
    private String template;

    public synchronized String dump(PackageDescr packageDescr) {
        this.xmlDump = new StringBuffer();
        this.visitPackageDescr(packageDescr);
        return this.xmlDump.toString();
    }

    public void visitAndDescr(AndDescr descr) {
        this.template = new String();
        this.template = descr.getDescrs() != Collections.EMPTY_LIST ? "<and>" + this.processDescrList(descr.getDescrs()) + "</and>" : "<and> </and>";
    }

    public void visitAttributeDescr(AttributeDescr attributeDescr) {
        this.template = new String();
        this.template = "<rule-attribute name=\"" + attributeDescr.getName() + "\" value=\"" + attributeDescr.getValue() + "\" />" + eol;
    }

    public void visitBoundVariableDescr(BoundVariableDescr descr) {
        this.template = new String();
        this.template = "<bound-variable field-name=\"" + descr.getFieldName() + "\" evaluator=\"" + this.getEvaluator(descr.getEvaluator()) + "\" identifier=\"" + descr.getIdentifier() + "\" />" + eol;
    }

    public void visitColumnDescr(ColumnDescr descr) {
        this.template = new String();
        this.template = descr.getDescrs() != Collections.EMPTY_LIST ? (descr.getIdentifier() != null ? "<column identifier=\"" + descr.getIdentifier() + "\" object-type=\"" + descr.getObjectType() + "\" >" + this.processDescrList(descr.getDescrs()) + "</column>" + eol : "<column object-type=\"" + descr.getObjectType() + "\" >" + this.processDescrList(descr.getDescrs()) + "</column>" + eol) : (descr.getIdentifier() != null ? "<column identifier=\"" + descr.getIdentifier() + "\" object-type=\"" + descr.getObjectType() + "\" > </column>" + eol : "<column object-type=\"" + descr.getObjectType() + "\" > </column>" + eol);
    }

    public void visitEvalDescr(EvalDescr descr) {
        this.template = new String();
        this.template = "<eval>" + descr.getText() + "</eval>" + eol;
    }

    public void visitExistsDescr(ExistsDescr descr) {
        this.template = new String();
        this.template = descr.getDescrs() != Collections.EMPTY_LIST ? "<exists>" + this.processDescrList(descr.getDescrs()) + "</exists>" : "<exists> </exists>";
    }

    public void visitFieldBindingDescr(FieldBindingDescr descr) {
        this.template = new String();
        this.template = "<field-binding field-name=\"" + descr.getFieldName() + "\" identifier=\"" + descr.getIdentifier() + "\" />" + eol;
    }

    public void visitFunctionDescr(FunctionDescr functionDescr) {
        this.template = new String();
        String parameterTemplate = this.processParameters(functionDescr.getParameterNames(), functionDescr.getParameterTypes());
        this.template = "<function return-type=\"" + functionDescr.getReturnType() + "\" name=\"" + functionDescr.getName() + "\">" + eol + parameterTemplate + "<body>" + eol + functionDescr.getText() + eol + "</body>" + eol + "</function>" + eol;
    }

    public void visitLiteralDescr(LiteralDescr descr) {
        this.template = new String();
        this.template = "<literal field-name=\"" + descr.getFieldName() + "\" evaluator=\"" + this.getEvaluator(descr.getEvaluator()) + "\" value=\"" + descr.getText() + "\" />" + eol;
    }

    public void visitNotDescr(NotDescr descr) {
        this.template = new String();
        this.template = descr.getDescrs() != Collections.EMPTY_LIST ? "<not>" + this.processDescrList(descr.getDescrs()) + "</not>" : "<not> </not>";
    }

    public void visitOrDescr(OrDescr descr) {
        this.template = new String();
        this.template = descr.getDescrs() != Collections.EMPTY_LIST ? "<or>" + this.processDescrList(descr.getDescrs()) + "</or>" : "<or> </or>";
    }

    public void visitPackageDescr(PackageDescr packageDescr) {
        String packageName = packageDescr.getName();
        String xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> " + eol + " <package name=\"" + packageName + "\"  " + eol + "\txmlns=\"http://drools.org/drools-3.0\" " + eol + "\txmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\" " + eol + "\txs:schemaLocation=\"http://drools.org/drools-3.0 drools-3.0.xsd\"> " + eol;
        this.appendXmlDump(xmlString);
        this.appendXmlDump(this.processImportsList(packageDescr.getImports()));
        this.appendXmlDump(this.processGlobalsMap(packageDescr.getGlobals()));
        this.appendXmlDump(this.processFunctionsList(packageDescr.getFunctions()));
        this.appendXmlDump(this.processRules(packageDescr.getRules()));
        this.appendXmlDump("</package>");
    }

    public void visitPredicateDescr(PredicateDescr descr) {
        this.template = new String();
        this.template = "<predicate field-name=\"" + descr.getFieldName() + "\" identifier=\"" + descr.getDeclaration() + "\" >" + descr.getText() + "</predicate>" + eol;
    }

    public void visitReturnValueDescr(ReturnValueDescr descr) {
        this.template = new String();
        this.template = "<return-value field-name=\"" + descr.getFieldName() + "\" evaluator=\"" + this.getEvaluator(descr.getEvaluator()) + "\" >" + descr.getText() + "</return-value>" + eol;
    }

    public void visitQueryDescr(QueryDescr descr) {
        this.template = new String();
        this.template = "<query name=\"" + descr.getName() + "\">" + "<lhs>" + this.processDescrList(descr.getLhs().getDescrs()) + "</lhs>" + "</query>";
    }

    private String processRules(List rules) {
        String ruleList = "";
        Iterator iterator = rules.iterator();
        while (iterator.hasNext()) {
            RuleDescr ruleDescr = (RuleDescr)iterator.next();
            String rule = "<rule name=\"" + ruleDescr.getName() + "\">" + eol;
            String attribute = this.processAttribute(ruleDescr.getAttributes());
            String lhs = "";
            lhs = ruleDescr.getLhs().getDescrs() != Collections.EMPTY_LIST ? "<lhs>" + this.processDescrList(ruleDescr.getLhs().getDescrs()) + "</lhs>" : "<lhs> </lhs>";
            String rhs = "<rhs>" + ruleDescr.getConsequence() + "</rhs>" + eol;
            rule = rule + attribute;
            rule = rule + lhs;
            rule = rule + rhs;
            rule = rule + "</rule>";
            ruleList = ruleList + rule;
        }
        return ruleList + eol;
    }

    private String processDescrList(List descr) {
        String descrString = "";
        Iterator iterator = descr.iterator();
        while (iterator.hasNext()) {
            this.visit(iterator.next());
            descrString = descrString + this.template;
            descrString = descrString + eol;
        }
        return descrString + eol;
    }

    private String processFunctionsList(List functions) {
        String functionList = "";
        Iterator iterator = functions.iterator();
        while (iterator.hasNext()) {
            this.visit(iterator.next());
            functionList = functionList + this.template;
        }
        return functionList + eol;
    }

    private String processAttribute(List attributes) {
        String attributeList = "";
        Iterator iterator = attributes.iterator();
        while (iterator.hasNext()) {
            AttributeDescr attributeDescr = (AttributeDescr)iterator.next();
            this.visit(attributeDescr);
            attributeList = attributeList + this.template;
        }
        return attributeList + eol;
    }

    private String processParameters(List parameterNames, List parameterTypes) {
        String paramList = "";
        int i = 0;
        Iterator iterator = parameterNames.iterator();
        while (iterator.hasNext()) {
            String paramName = (String)iterator.next();
            String paramType = (String)parameterTypes.get(i);
            String paramTemplate = "<parameter identifier=\"" + paramName + "\" type=\"" + paramType + "\" />" + eol;
            paramList = paramList + paramTemplate;
            ++i;
        }
        return paramList + eol;
    }

    private String processGlobalsMap(Map globals) {
        String globalList = "";
        Iterator iterator = globals.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = (String)globals.get(key);
            String globalTemplate = "<global identifier=\"" + key + "\" type=\"" + value + "\" />" + eol;
            globalList = globalList + globalTemplate;
        }
        return globalList + eol;
    }

    private String processImportsList(List imports) {
        String importList = "";
        Iterator iterator = imports.iterator();
        while (iterator.hasNext()) {
            String importString = (String)iterator.next();
            String importTemplate = "<import name=\"" + importString + "\" /> " + eol;
            importList = importList + importTemplate;
        }
        return importList + eol;
    }

    private void appendXmlDump(String temp) {
        this.xmlDump.append(temp);
    }

    private String getEvaluator(String eval) {
        eval = eval.replaceAll("<", "&lt;");
        eval = eval.replaceAll(">", "&gt;");
        return eval;
    }
}

