/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.jci.compilers.CompilationResult;
import org.apache.commons.jci.compilers.EclipseJavaCompiler;
import org.apache.commons.jci.compilers.EclipseJavaCompilerSettings;
import org.apache.commons.jci.compilers.JavaCompiler;
import org.apache.commons.jci.compilers.JavaCompilerFactory;
import org.apache.commons.jci.problems.CompilationProblem;
import org.apache.commons.jci.readers.MemoryResourceReader;
import org.apache.commons.jci.readers.ResourceReader;
import org.apache.commons.jci.stores.ResourceStore;
import org.drools.RuntimeDroolsException;
import org.drools.base.ClassFieldExtractorCache;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsError;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.FunctionError;
import org.drools.compiler.GlobalError;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.ParserError;
import org.drools.compiler.RuleError;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.semantics.java.ClassTypeResolver;
import org.drools.semantics.java.FunctionBuilder;
import org.drools.semantics.java.PackageStore;
import org.drools.semantics.java.RuleBuilder;
import org.drools.spi.TypeResolver;
import org.drools.xml.XmlPackageReader;
import org.xml.sax.SAXException;

public class PackageBuilder {
    private JavaCompiler compiler;
    private Package pkg;
    private List results;
    private PackageStore packageStoreWrapper;
    private MemoryResourceReader src;
    private PackageBuilderConfiguration configuration;
    private Map errorHandlers;
    private List generatedClassList;
    private ClassTypeResolver typeResolver;
    private ClassFieldExtractorCache classFieldExtractorCache;
    private static JavaCompiler cachedJavaCompiler = null;

    public PackageBuilder() {
        this(null, null);
    }

    public PackageBuilder(Package pkg) {
        this(pkg, null);
    }

    public PackageBuilder(PackageBuilderConfiguration configuration) {
        this(null, configuration);
    }

    public PackageBuilder(Package pkg, PackageBuilderConfiguration configuration) {
        if (configuration == null) {
            configuration = new PackageBuilderConfiguration();
        }
        this.configuration = configuration;
        this.loadCompiler();
        this.src = new MemoryResourceReader();
        this.results = new ArrayList();
        this.errorHandlers = new HashMap();
        this.pkg = pkg;
        this.generatedClassList = new ArrayList();
        this.classFieldExtractorCache = new ClassFieldExtractorCache();
        if (pkg != null) {
            this.packageStoreWrapper = new PackageStore(pkg.getPackageCompilationData());
        }
    }

    public void addPackageFromDrl(Reader reader) throws DroolsParserException, IOException {
        DrlParser parser = new DrlParser();
        PackageDescr pkg = parser.parse(reader);
        this.results.addAll(parser.getErrors());
        this.addPackage(pkg);
    }

    public void addPackageFromXml(Reader reader) throws DroolsParserException, IOException {
        XmlPackageReader xmlReader = new XmlPackageReader();
        try {
            xmlReader.read(reader);
        }
        catch (SAXException e) {
            throw new DroolsParserException(e.getCause());
        }
        this.addPackage(xmlReader.getPackageDescr());
    }

    public void addPackageFromDrl(Reader source, Reader dsl) throws DroolsParserException, IOException {
        DrlParser parser = new DrlParser();
        PackageDescr pkg = parser.parse(source, dsl);
        this.results.addAll(parser.getErrors());
        this.addPackage(pkg);
    }

    public void addPackage(PackageDescr packageDescr) {
        this.validatePackageName(packageDescr);
        this.validateUniqueRuleNames(packageDescr);
        if (this.pkg != null) {
            this.mergePackage(this.pkg, packageDescr);
        } else {
            this.pkg = this.newPackage(packageDescr);
        }
        if (!this.hasErrors()) {
            Iterator it = packageDescr.getFunctions().iterator();
            while (it.hasNext()) {
                this.addFunction((FunctionDescr)it.next());
            }
            it = packageDescr.getRules().iterator();
            while (it.hasNext()) {
                this.addRule((RuleDescr)it.next());
            }
        }
        if (this.generatedClassList.size() > 0) {
            this.compileAll();
        }
    }

    private void validatePackageName(PackageDescr packageDescr) {
        if (packageDescr.getName() == null || "".equals(packageDescr.getName())) {
            throw new MissingPackageNameException("Missing package name for rule package.");
        }
    }

    private void validateUniqueRuleNames(PackageDescr packageDescr) {
        HashSet<String> names = new HashSet<String>();
        Iterator iter = packageDescr.getRules().iterator();
        while (iter.hasNext()) {
            RuleDescr rule = (RuleDescr)iter.next();
            String name = rule.getName();
            if (names.contains(name)) {
                this.results.add(new ParserError("Duplicate rule name: " + name, rule.getLine(), rule.getColumn()));
            }
            names.add(name);
        }
    }

    private Package newPackage(PackageDescr packageDescr) {
        Package pkg = new Package(packageDescr.getName(), this.configuration.getClassLoader());
        this.packageStoreWrapper = new PackageStore(pkg.getPackageCompilationData());
        this.mergePackage(pkg, packageDescr);
        return pkg;
    }

    private void mergePackage(Package pkg, PackageDescr packageDescr) {
        List imports = packageDescr.getImports();
        Iterator it = imports.iterator();
        while (it.hasNext()) {
            pkg.addImport((String)it.next());
        }
        ClassTypeResolver typeResolver = new ClassTypeResolver(imports, pkg.getPackageCompilationData().getClassLoader());
        Map globals = packageDescr.getGlobals();
        Iterator it2 = globals.keySet().iterator();
        while (it2.hasNext()) {
            String identifier = (String)it2.next();
            String className = (String)globals.get(identifier);
            try {
                Class clazz = typeResolver.resolveType(className);
                pkg.addGlobal(identifier, clazz);
            }
            catch (ClassNotFoundException e) {
                new GlobalError(identifier);
            }
        }
    }

    private void addClassCompileTask(String className, String text, MemoryResourceReader src, ErrorHandler handler) {
        String fileName = String.valueOf(className.replace('.', '/')) + ".java";
        src.add(fileName, text.getBytes());
        this.errorHandlers.put(fileName, handler);
        this.generatedClassList.add(className);
    }

    private void addFunction(FunctionDescr functionDescr) {
        FunctionBuilder buidler = new FunctionBuilder();
        this.addClassCompileTask(String.valueOf(this.pkg.getName()) + "." + this.ucFirst(functionDescr.getName()), buidler.build(this.pkg, functionDescr), this.src, new FunctionErrorHandler(functionDescr, "Function Compilation error"));
    }

    private void addRule(RuleDescr ruleDescr) {
        String ruleClassName = this.getUniqueLegalName(this.pkg.getName(), ruleDescr.getName(), "java", (ResourceReader)this.src);
        ruleDescr.SetClassName(this.ucFirst(ruleClassName));
        RuleBuilder builder = new RuleBuilder(this.getTypeResolver(), this.classFieldExtractorCache);
        builder.build(this.pkg, ruleDescr);
        this.results.addAll(builder.getErrors());
        Rule rule = builder.getRule();
        if (builder.getRuleClass() != null) {
            this.addRuleSemantics(builder, rule, ruleDescr);
        }
        this.pkg.addRule(rule);
    }

    private TypeResolver getTypeResolver() {
        if (this.typeResolver == null) {
            this.typeResolver = new ClassTypeResolver(this.pkg.getImports(), this.pkg.getPackageCompilationData().getClassLoader());
            this.typeResolver.addImport(String.valueOf(this.pkg.getName()) + ".*");
            this.typeResolver.addImport("java.lang.*");
        }
        return this.typeResolver;
    }

    public void compileRule(RuleBuilder builder, Rule rule, RuleDescr ruleDescr) {
        this.addRuleSemantics(builder, rule, ruleDescr);
        this.compileAll();
    }

    private void addRuleSemantics(RuleBuilder builder, Rule rule, RuleDescr ruleDescr) {
        this.addClassCompileTask(String.valueOf(this.pkg.getName()) + "." + ruleDescr.getClassName(), builder.getRuleClass(), this.src, new RuleErrorHandler(ruleDescr, rule, "Rule Compilation error"));
        Iterator it = builder.getInvokers().keySet().iterator();
        while (it.hasNext()) {
            String className = (String)it.next();
            Object invoker = builder.getInvokerLookups().get(className);
            if (invoker != null) {
                this.pkg.getPackageCompilationData().putInvoker(className, invoker);
            }
            String text = (String)builder.getInvokers().get(className);
            PatternDescr descr = (PatternDescr)builder.getDescrLookups().get(className);
            this.addClassCompileTask(className, text, this.src, new RuleInvokerErrorHandler(descr, rule, "Unable to generate rule invoker."));
        }
    }

    public Package getPackage() {
        if (this.hasErrors()) {
            this.pkg.setError(this.printErrors());
        }
        return this.pkg;
    }

    private void compileAll() {
        String[] classes = new String[this.generatedClassList.size()];
        this.generatedClassList.toArray(classes);
        CompilationResult result = this.compiler.compile(classes, (ResourceReader)this.src, (ResourceStore)this.packageStoreWrapper, this.pkg.getPackageCompilationData().getClassLoader());
        if (result.getErrors().length > 0) {
            ErrorHandler handler;
            int i = 0;
            while (i < result.getErrors().length) {
                CompilationProblem err = result.getErrors()[i];
                handler = (ErrorHandler)this.errorHandlers.get(err.getFileName());
                handler.addError(err);
                ++i;
            }
            Collection errors = this.errorHandlers.values();
            Iterator iter = errors.iterator();
            while (iter.hasNext()) {
                handler = (ErrorHandler)iter.next();
                if (!(handler instanceof RuleInvokerErrorHandler)) {
                    this.results.add(handler.getError());
                    continue;
                }
                System.err.println("!!!! An error occurred compiling the invoker: " + handler.getError());
            }
        }
    }

    public boolean hasErrors() {
        return this.results.size() > 0;
    }

    public DroolsError[] getErrors() {
        return this.results.toArray(new DroolsError[this.results.size()]);
    }

    public String printErrors() {
        StringBuffer buf = new StringBuffer();
        Iterator iter = this.results.iterator();
        while (iter.hasNext()) {
            DroolsError err = (DroolsError)iter.next();
            buf.append(err.getMessage());
            buf.append("\n");
        }
        return buf.toString();
    }

    private String getUniqueLegalName(String packageName, String name, String ext, ResourceReader src) {
        String newName = "Rule_" + name.replaceAll("[^\\w$]", "_");
        int counter = -1;
        boolean exists = true;
        while (exists) {
            String fileName = String.valueOf(packageName.replaceAll("\\.", "/")) + newName + "_" + ++counter + ext;
            exists = src.isAvailable(fileName);
        }
        if (counter >= 0) {
            newName = String.valueOf(newName) + "_" + counter;
        }
        return newName;
    }

    private void loadCompiler() {
        switch (this.configuration.getCompiler()) {
            case 1: {
                if (!"1.4".intern().equals(this.configuration.getJavaLanguageLevel())) {
                    throw new RuntimeDroolsException("Incompatible Java language level with selected compiler");
                }
                this.compiler = JavaCompilerFactory.getInstance().createCompiler("janino");
            }
        }
        EclipseJavaCompilerSettings eclipseSettings = new EclipseJavaCompilerSettings();
        eclipseSettings.getMap().put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", this.configuration.getJavaLanguageLevel());
        eclipseSettings.getMap().put("org.eclipse.jdt.core.compiler.source", this.configuration.getJavaLanguageLevel());
        this.compiler = new EclipseJavaCompiler(eclipseSettings);
    }

    private String ucFirst(String name) {
        return String.valueOf(name.toUpperCase().charAt(0)) + name.substring(1);
    }

    public static class MissingPackageNameException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 4056984379574366454L;

        public MissingPackageNameException(String message) {
            super(message);
        }
    }

    public static abstract class ErrorHandler {
        private List errors = new ArrayList();
        protected String message;

        public void addError(CompilationProblem err) {
            this.errors.add(err);
        }

        public abstract DroolsError getError();

        protected CompilationProblem[] collectCompilerProblems() {
            if (this.errors.size() == 0) {
                return null;
            }
            CompilationProblem[] list = new CompilationProblem[this.errors.size()];
            this.errors.toArray(list);
            return list;
        }
    }

    public static class RuleErrorHandler
    extends ErrorHandler {
        private PatternDescr descr;
        private Rule rule;

        public RuleErrorHandler(PatternDescr ruleDescr, Rule rule, String message) {
            this.descr = ruleDescr;
            this.rule = rule;
            this.message = message;
        }

        public DroolsError getError() {
            return new RuleError(this.rule, this.descr, this.collectCompilerProblems(), this.message);
        }
    }

    public static class RuleInvokerErrorHandler
    extends RuleErrorHandler {
        public RuleInvokerErrorHandler(PatternDescr ruleDescr, Rule rule, String message) {
            super(ruleDescr, rule, message);
        }
    }

    public static class FunctionErrorHandler
    extends ErrorHandler {
        private FunctionDescr descr;

        public FunctionErrorHandler(FunctionDescr functionDescr, String message) {
            this.descr = functionDescr;
            this.message = message;
        }

        public DroolsError getError() {
            return new FunctionError(this.descr, this.collectCompilerProblems(), this.message);
        }
    }
}

