/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl;

import java.util.StringTokenizer;
import org.drools.lang.Expander;

public class LineBasedExpander {
    private String source;
    private StringBuffer output = new StringBuffer();
    private boolean lhs;
    private boolean rhs;
    private int lineNumber = 0;
    private Expander expander;

    public LineBasedExpander(String rawSource, Expander exp) {
        this.source = rawSource;
        this.expander = exp;
    }

    public String expand() {
        StringTokenizer st = new StringTokenizer(this.source, "\r\n");
        while (st.hasMoreTokens()) {
            ++this.lineNumber;
            String raw = st.nextToken();
            String line = raw.trim();
            if (this.matchesKeyword("when", line)) {
                this.lhs();
                this.appendLine(raw);
                continue;
            }
            if (this.matchesKeyword("then", line)) {
                this.rhs();
                this.appendLine(raw);
                continue;
            }
            if (this.matchesKeyword("end", line)) {
                this.endRule();
                this.appendLine(raw);
                this.output.append("\n");
                continue;
            }
            if (this.matchesKeyword("query", line)) {
                this.query();
                this.appendLine(raw);
                continue;
            }
            this.consume(raw);
        }
        return this.output.toString();
    }

    private void appendLine(String raw) {
        this.output.append(raw);
        this.output.append("\n");
    }

    public String getExpanded() {
        return this.output.toString();
    }

    private void consume(String raw) {
        if (this.lhs) {
            this.appendLine(this.expand("when", raw));
        } else if (this.rhs) {
            this.appendLine(this.expand("then", raw));
        } else {
            this.appendLine(raw);
        }
    }

    private String expand(String scope, String raw) {
        String trimmed = raw.trim();
        if (trimmed.startsWith(">")) {
            return raw.substring(1);
        }
        return "\t\t" + this.expander.expand(scope, this.normaliseSpaces(raw));
    }

    boolean matchesKeyword(String token, String line) {
        if (line.length() < token.length()) {
            return false;
        }
        if (!line.startsWith(token)) {
            return false;
        }
        String rest = line.substring(token.length()).trim();
        if (rest.length() == 0) {
            return true;
        }
        char next = rest.charAt(0);
        return next == '#' || next == '/';
    }

    String normaliseSpaces(String original) {
        boolean singleQ = false;
        boolean doubleQ = false;
        boolean prevSpace = false;
        StringBuffer buf = new StringBuffer();
        char[] cs = original.trim().toCharArray();
        int i = 0;
        while (i < cs.length) {
            char c = cs[i];
            if (Character.isWhitespace(c) && !singleQ && !doubleQ) {
                if (!prevSpace) {
                    buf.append(' ');
                    prevSpace = true;
                }
            } else {
                prevSpace = false;
                if (c == '\'') {
                    boolean bl = singleQ = !singleQ;
                }
                if (c == '\"') {
                    doubleQ = !doubleQ;
                }
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    private void query() {
        this.lhs();
    }

    private void endRule() {
        this.lhs = false;
        this.rhs = false;
    }

    private void rhs() {
        this.rhs = true;
        this.lhs = false;
    }

    private void lhs() {
        this.lhs = true;
    }
}

