/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl.template;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.lang.dsl.template.NLGrammar;
import org.drools.lang.dsl.template.NLMappingItem;
import org.drools.lang.dsl.template.Template;
import org.drools.lang.dsl.template.TemplateFactory;

public class NLExpressionCompiler {
    private Map templateCache;
    private NLGrammar grammar;

    public NLExpressionCompiler(NLGrammar grammar) {
        List grammarItems = grammar.getMappings();
        this.templateCache = new HashMap();
        this.grammar = grammar;
        TemplateFactory factory = new TemplateFactory();
        Iterator iter = grammarItems.iterator();
        while (iter.hasNext()) {
            NLMappingItem mapping = (NLMappingItem)iter.next();
            Template template = factory.getTemplate(mapping.getNaturalTemplate());
            this.templateCache.put(mapping, template);
        }
    }

    public String compile(String expression, String scope) {
        String expanded = expression;
        List mappings = this.grammar.getMappings();
        expanded = this.processMappings(expanded, mappings, "*");
        if (scope != null) {
            expanded = this.processMappings(expanded, mappings, scope);
        }
        if (expanded.equals(expression)) {
            throw new IllegalArgumentException("Expression was not expandable: " + expression);
        }
        return expanded;
    }

    private String processMappings(String input, List mappings, String scope) {
        Iterator iter = mappings.iterator();
        while (iter.hasNext()) {
            NLMappingItem mapping = (NLMappingItem)iter.next();
            if (!mapping.getScope().equals(scope)) continue;
            Template template = (Template)this.templateCache.get(mapping);
            input = template.expandAll(input, mapping.getTargetTemplate());
        }
        return input;
    }
}

