/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl.template;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.drools.lang.dsl.template.NLMappingItem;

public class NLGrammar
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List mappings = new ArrayList();
    private static final Pattern itemPrefix = Pattern.compile("\\[\\s*(when|then)\\s*\\].*");
    private String description;

    public void addNLItem(NLMappingItem item) {
        this.mappings.add(item);
    }

    public List getMappings() {
        return this.mappings;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void removeMapping(NLMappingItem item) {
        this.mappings.remove(item);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(Reader reader) {
        BufferedReader buf = new BufferedReader(reader);
        try {
            String line = null;
            block2: while (true) {
                if ((line = buf.readLine()) == null) {
                    return;
                }
                while (true) {
                    if (!line.endsWith("\\")) {
                        if (!(line = line.trim()).startsWith("#")) break;
                        this.description = line.substring(1);
                        continue block2;
                    }
                    line = String.valueOf(line.substring(0, line.length() - 1)) + buf.readLine();
                }
                if (line.equals("")) continue;
                this.mappings.add(this.parseLine(line));
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read DSL configuration.");
        }
    }

    public void save(Writer writer) {
        BufferedWriter buffer = new BufferedWriter(writer);
        try {
            buffer.write("#" + this.description + "\n");
            Iterator iter = this.mappings.iterator();
            while (iter.hasNext()) {
                NLMappingItem item = (NLMappingItem)iter.next();
                if (item.getScope().equals("*")) {
                    buffer.write(String.valueOf(item.getNaturalTemplate()) + "=" + item.getTargetTemplate() + "\n");
                    continue;
                }
                buffer.write("[" + item.getScope() + "]" + item.getNaturalTemplate() + "=" + item.getTargetTemplate() + "\n");
            }
            buffer.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to save DSL configuration.");
        }
    }

    public List getMappings(String scope) {
        ArrayList<NLMappingItem> list = new ArrayList<NLMappingItem>();
        Iterator iter = this.mappings.iterator();
        while (iter.hasNext()) {
            NLMappingItem item = (NLMappingItem)iter.next();
            if (!item.getScope().equals("*") && !item.getScope().equals(scope)) continue;
            list.add(item);
        }
        return list;
    }

    public NLMappingItem parseLine(String line) {
        int split = line.indexOf("=");
        String left = line.substring(0, split).trim();
        String right = line.substring(split + 1).trim();
        Matcher matcher = itemPrefix.matcher(left = StringUtils.replace((String)left, (String)"\\", (String)""));
        if (matcher.matches()) {
            String type = matcher.group(1);
            left = left.substring(left.indexOf("]") + 1).trim();
            return new NLMappingItem(left, right, type);
        }
        return new NLMappingItem(left, right, "*");
    }

    public List validateMapping(NLMappingItem item) {
        List errors = item.validateTokenUsage();
        errors.addAll(item.validateUnmatchingBraces());
        return errors;
    }
}

