/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl.template;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.drools.lang.dsl.template.Template;
import org.drools.lang.dsl.template.TemplateFactory;

public class RegexTemplate {
    private Pattern templatePattern;
    private List holes;
    private String template;

    public static void main(String[] args) {
        RegexTemplate regTemplate = new RegexTemplate("the date between {before} and {after}");
        regTemplate.compile();
        String out = regTemplate.populate("the date between date1 and date2", "dateBetween({before},{after})");
        RegexTemplate.perfRegex(regTemplate, out);
        regTemplate = new RegexTemplate("date of '{date}'");
        regTemplate.compile();
        System.out.println(regTemplate.populate("date of 'today' and date of 'tomorrow'", "dateOf({date})"));
        RegexTemplate.perfTemplate();
    }

    private static void perfRegex(RegexTemplate regTemplate, String out) {
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < 100000) {
            regTemplate.populate("the date between date1 and date2", "dateBetween({before},{after})");
            ++i;
        }
        System.out.println("time for regex " + (System.currentTimeMillis() - start));
        System.out.println(out);
    }

    private static void perfTemplate() {
        TemplateFactory factory = new TemplateFactory();
        Template template = factory.getTemplate("the date between {before} and {after}");
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < 100000) {
            template.expandAll("the date between date1 and date2", "dateBetween({before},{after})");
            ++i;
        }
        System.out.println("time for non " + (System.currentTimeMillis() - start));
    }

    List lex() {
        ChunkLexer lex = new ChunkLexer();
        List chunks = lex.lex(this.template);
        return chunks;
    }

    public String populate(String source, String targetTemplate) {
        Matcher matcher = this.templatePattern.matcher(source);
        if (!matcher.matches()) {
            return source;
        }
        String result = targetTemplate;
        if (matcher.groupCount() != this.holes.size()) {
            throw new IllegalArgumentException("Unable to match up holes in template with source.");
        }
        int i = 0;
        while (i < matcher.groupCount()) {
            String val = matcher.group(i + 1);
            String hole = (String)this.holes.get(i);
            result = this.replace(result, hole, val.trim());
            ++i;
        }
        return result;
    }

    public void compile() {
        List chunks = this.lex();
        StringBuffer regex = new StringBuffer();
        ArrayList<String> holes = new ArrayList<String>();
        Iterator iter = chunks.iterator();
        while (iter.hasNext()) {
            String chunk = (String)iter.next();
            if (chunk.startsWith("{")) {
                holes.add(chunk);
                regex.append("\\b(.*)\\b");
                continue;
            }
            regex.append(this.replace(chunk, " ", "\\s"));
        }
        this.holes = holes;
        this.templatePattern = Pattern.compile("\\s*" + regex.toString() + "\\s*");
    }

    public RegexTemplate(String grammarTemplate) {
        this.template = grammarTemplate;
    }

    private String replace(String str, String find, String replace) {
        return StringUtils.replace((String)str, (String)find, (String)replace);
    }

    static class ChunkLexer {
        private final List chunks = new ArrayList();
        private StringBuffer buffer = new StringBuffer();

        ChunkLexer() {
        }

        public List lex(String grammarTemplate) {
            char[] chars = grammarTemplate.toCharArray();
            int i = 0;
            while (i < chars.length) {
                switch (chars[i]) {
                    case '{': {
                        this.startHole();
                        break;
                    }
                    case '}': {
                        this.endHole();
                        break;
                    }
                    default: {
                        this.buffer.append(chars[i]);
                    }
                }
                ++i;
            }
            String buf = this.buffer.toString();
            if (!buf.equals("")) {
                this.addChunk(buf);
            }
            return this.chunks;
        }

        private boolean addChunk(String buf) {
            return this.chunks.add(buf.trim());
        }

        private void endHole() {
            String buf = this.buffer.toString();
            this.chunks.add("{" + buf + "}");
            this.buffer = new StringBuffer();
        }

        private void startHole() {
            String buf = this.buffer.toString();
            if (!buf.equals("")) {
                this.addChunk(buf);
            }
            this.buffer = new StringBuffer();
        }
    }
}

