/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl.template;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.drools.lang.dsl.template.Chunk;

class Template {
    Chunk start;

    Template() {
    }

    Template addChunk(String chunkText) {
        Chunk chunk = new Chunk(chunkText);
        if (this.start == null) {
            this.start = chunk;
        } else {
            this.start.addToEnd(chunk);
        }
        return this;
    }

    void processNL(String nl, Map map) {
        this.start.clearValues();
        this.start.process(nl);
        this.start.buildValueMap(map);
    }

    String getSubstitutionKey() {
        StringBuffer buffer = new StringBuffer();
        this.start.buildSubtitutionKey(buffer);
        return buffer.toString().trim();
    }

    String populateTargetString(Map map, String grammar_r) {
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            grammar_r = StringUtils.replace((String)grammar_r, (String)key, (String)((String)map.get(key)));
        }
        return grammar_r;
    }

    String interpolate(String nl, String subKey, String target) {
        return StringUtils.replace((String)nl, (String)subKey, (String)target);
    }

    String expandOnce(String nl, String targetTemplate) {
        HashMap values = new HashMap();
        this.processNL(nl, values);
        String subKey = this.getSubstitutionKey();
        String target = this.populateTargetString(values, targetTemplate);
        return this.interpolate(nl, subKey, target);
    }

    public String expandAll(String nl, String targetTemplate) {
        String result = nl;
        int i = 0;
        while (i < 10) {
            String newResult = this.expandOnce(result, targetTemplate);
            if (newResult.equals(result)) break;
            result = newResult;
            if (++i != 10) continue;
            throw new IllegalArgumentException("To many iterations in processing the expression: [" + nl + "] with target template: [" + targetTemplate + "]");
        }
        return result;
    }
}

