/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl.template;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.lang.dsl.template.Template;

class TemplateFactory {
    TemplateFactory() {
    }

    public Template getTemplate(String naturalTemplate) {
        Template template = new Template();
        List chunkList = this.lexChunks(naturalTemplate);
        Iterator iter = chunkList.iterator();
        while (iter.hasNext()) {
            template.addChunk((String)iter.next());
        }
        return template;
    }

    List lexChunks(String grammarTemplate) {
        ChunkLexer lexer = new ChunkLexer();
        return lexer.lex(grammarTemplate);
    }

    static class ChunkLexer {
        private final List chunks = new ArrayList();
        private StringBuffer buffer = new StringBuffer();

        ChunkLexer() {
        }

        public List lex(String grammarTemplate) {
            char[] chars = grammarTemplate.toCharArray();
            int i = 0;
            while (i < chars.length) {
                switch (chars[i]) {
                    case '{': {
                        this.startHole();
                        break;
                    }
                    case '}': {
                        this.endHole();
                        break;
                    }
                    default: {
                        this.buffer.append(chars[i]);
                    }
                }
                ++i;
            }
            String buf = this.buffer.toString();
            if (!buf.equals("")) {
                this.addChunk(buf);
            }
            return this.chunks;
        }

        private boolean addChunk(String buf) {
            return this.chunks.add(buf.trim());
        }

        private void endHole() {
            String buf = this.buffer.toString();
            this.chunks.add("{" + buf + "}");
            this.buffer = new StringBuffer();
        }

        private void startHole() {
            String buf = this.buffer.toString();
            if (!buf.equals("")) {
                this.addChunk(buf);
            }
            this.buffer = new StringBuffer();
        }
    }
}

