/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.java;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FunctionFixer {
    static Pattern FUNCTION = Pattern.compile("(\\S*\\s*|\\.\\s*)\\b([\\S&&[^\\.\\(\\)]]+)\\s*\\(([^)]*)\\)", 32);
    static final Set KEYWORDS = FunctionFixer.getJavaKeywords();

    public String fix(String raw) {
        return this.fix(raw, FUNCTION);
    }

    public String fix(String raw, Pattern pattern) {
        if (raw == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int lastIndex = 0;
        int startIndex = 0;
        Matcher matcher = pattern.matcher(raw);
        while (matcher.find(startIndex)) {
            String trimmedPre;
            int endIndex = this.findEndParenthesis(raw, matcher);
            if (endIndex < 0) {
                startIndex = matcher.start(3);
                continue;
            }
            startIndex = endIndex;
            String params = matcher.group(3).trim();
            if (endIndex > matcher.end()) {
                params = String.valueOf(params) + raw.substring(matcher.end() - 1, endIndex - 1);
            }
            params = this.fix(params, pattern);
            String function = null;
            String pre = matcher.group(1);
            if (matcher.group(1) != null && ((trimmedPre = pre.trim()).endsWith(".") || trimmedPre.endsWith("new"))) {
                function = raw.substring(matcher.start(2), matcher.start(3) - 1);
            }
            if (function == null) {
                function = matcher.group(2).trim();
                function = function == null || function.length() == 0 || KEYWORDS.contains(function) ? raw.substring(matcher.start(2), matcher.start(3) - 1) : String.valueOf(this.ucFirst(function)) + "." + function;
            }
            String target = String.valueOf(function) + "(" + params + ")";
            buf.append(raw.substring(lastIndex, matcher.start(2)));
            buf.append(target);
            lastIndex = endIndex;
        }
        buf.append(raw.substring(lastIndex));
        return buf.toString();
    }

    private String ucFirst(String name) {
        return String.valueOf(name.toUpperCase().charAt(0)) + name.substring(1);
    }

    private int findEndParenthesis(String raw, Matcher matcher) {
        int start = matcher.start(3) - 1;
        int end = matcher.end();
        int oCount = 0;
        int cCount = 0;
        int lastQuoteIndex = -1;
        int i = 0;
        while (i < raw.length()) {
            if (i > end && oCount == cCount) {
                if (lastQuoteIndex < 0 || lastQuoteIndex > start) break;
                return -1;
            }
            switch (raw.charAt(i)) {
                case '\"': {
                    if (lastQuoteIndex >= 0) {
                        if (lastQuoteIndex <= start && start <= i) {
                            return -1;
                        }
                        lastQuoteIndex = -1;
                        break;
                    }
                    lastQuoteIndex = i;
                    break;
                }
                case '(': {
                    if (lastQuoteIndex >= 0 || i < start) break;
                    ++oCount;
                    break;
                }
                case ')': {
                    if (lastQuoteIndex >= 0 || i < start) break;
                    ++cCount;
                    if (i < end) break;
                    end = i + 1;
                }
            }
            ++i;
        }
        return end;
    }

    private static Set getJavaKeywords() {
        HashSet<String> keys = new HashSet<String>();
        keys.add("abstract");
        keys.add("continue");
        keys.add("for");
        keys.add("new");
        keys.add("switch");
        keys.add("assert");
        keys.add("default");
        keys.add("goto");
        keys.add("package");
        keys.add("synchronized");
        keys.add("boolean");
        keys.add("do");
        keys.add("if");
        keys.add("private");
        keys.add("this");
        keys.add("break");
        keys.add("double");
        keys.add("implements");
        keys.add("protected");
        keys.add("throw");
        keys.add("byte");
        keys.add("else");
        keys.add("import");
        keys.add("public");
        keys.add("throws");
        keys.add("case");
        keys.add("enum");
        keys.add("instanceof");
        keys.add("return");
        keys.add("transient");
        keys.add("catch");
        keys.add("extends");
        keys.add("int");
        keys.add("short");
        keys.add("try");
        keys.add("char");
        keys.add("final");
        keys.add("interface");
        keys.add("static");
        keys.add("void");
        keys.add("class");
        keys.add("finally");
        keys.add("long");
        keys.add("strictfp");
        keys.add("volatile");
        keys.add("const");
        keys.add("float");
        keys.add("native");
        keys.add("super");
        keys.add("while");
        return keys;
    }
}

