/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.drools.semantics.java.parser.JavaParser;
import org.drools.semantics.java.parser.JavaParserLexer;

public class JavaExprAnalyzer {
    public List[] analyzeExpression(String expr, Set[] availableIdentifiers) throws RecognitionException {
        ANTLRStringStream charStream = new ANTLRStringStream(expr);
        JavaParserLexer lexer = new JavaParserLexer((CharStream)charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        JavaParser parser = new JavaParser((TokenStream)tokenStream);
        parser.logicalOrExpression();
        return this.analyze(parser.getIdentifiers(), availableIdentifiers);
    }

    public List[] analyzeBlock(String expr, Set[] availableIdentifiers) throws RecognitionException {
        ANTLRStringStream charStream = new ANTLRStringStream("{" + expr + "}");
        JavaParserLexer lexer = new JavaParserLexer((CharStream)charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        JavaParser parser = new JavaParser((TokenStream)tokenStream);
        parser.compoundStatement();
        return this.analyze(parser.getIdentifiers(), availableIdentifiers);
    }

    private List[] analyze(List identifiers, Set[] availableIdentifiers) throws RecognitionException {
        List[] used = new List[availableIdentifiers.length];
        int i = 0;
        int length = used.length;
        while (i < length) {
            used[i] = new ArrayList();
            ++i;
        }
        i = 0;
        length = availableIdentifiers.length;
        while (i < length) {
            Set set = availableIdentifiers[i];
            Iterator it = set.iterator();
            while (it.hasNext()) {
                String eachDecl = (String)it.next();
                if (!identifiers.contains(eachDecl)) continue;
                used[i].add(eachDecl);
            }
            ++i;
        }
        return used;
    }
}

