/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.java;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.drools.RuntimeDroolsException;
import org.drools.base.ClassFieldExtractor;
import org.drools.base.ClassFieldExtractorCache;
import org.drools.base.ClassObjectType;
import org.drools.base.EvaluatorFactory;
import org.drools.base.FieldFactory;
import org.drools.base.FieldImpl;
import org.drools.compiler.RuleError;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.BoundVariableDescr;
import org.drools.lang.descr.ColumnDescr;
import org.drools.lang.descr.ConditionalElementDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.FieldBindingDescr;
import org.drools.lang.descr.LiteralDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.ReturnValueDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.And;
import org.drools.rule.BoundVariableConstraint;
import org.drools.rule.Column;
import org.drools.rule.ConditionalElement;
import org.drools.rule.Declaration;
import org.drools.rule.EvalCondition;
import org.drools.rule.Exists;
import org.drools.rule.GroupElement;
import org.drools.rule.LiteralConstraint;
import org.drools.rule.Not;
import org.drools.rule.Or;
import org.drools.rule.Package;
import org.drools.rule.PredicateConstraint;
import org.drools.rule.Query;
import org.drools.rule.ReturnValueConstraint;
import org.drools.rule.Rule;
import org.drools.semantics.java.FunctionFixer;
import org.drools.semantics.java.JavaExprAnalyzer;
import org.drools.semantics.java.KnowledgeHelperFixer;
import org.drools.spi.Evaluator;
import org.drools.spi.Extractor;
import org.drools.spi.FieldConstraint;
import org.drools.spi.FieldExtractor;
import org.drools.spi.FieldValue;
import org.drools.spi.ObjectType;
import org.drools.spi.TypeResolver;

public class RuleBuilder {
    private Package pkg;
    private Rule rule;
    private RuleDescr ruleDescr;
    public String ruleClass;
    public List methods;
    public Map invokers;
    private Map invokerLookups;
    private Map descrLookups;
    private Map declarations;
    private int counter;
    private ColumnCounter columnCounter;
    private int columnOffset;
    private List errors;
    private final TypeResolver typeResolver;
    private Map notDeclarations;
    private static final StringTemplateGroup ruleGroup;
    private static final StringTemplateGroup invokerGroup;
    private static final KnowledgeHelperFixer knowledgeHelperFixer;
    private static final FunctionFixer functionFixer;
    private final JavaExprAnalyzer analyzer = new JavaExprAnalyzer();
    private ClassFieldExtractorCache classFieldExtractorCache;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.drools.semantics.java.RuleBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InputStreamReader inputStreamReader = new InputStreamReader(clazz.getResourceAsStream("javaRule.stg"));
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.antlr.stringtemplate.language.AngleBracketTemplateLexer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ruleGroup = new StringTemplateGroup((Reader)inputStreamReader, (Class)clazz2);
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.drools.semantics.java.RuleBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InputStreamReader inputStreamReader2 = new InputStreamReader(clazz3.getResourceAsStream("javaInvokers.stg"));
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("org.antlr.stringtemplate.language.AngleBracketTemplateLexer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        invokerGroup = new StringTemplateGroup((Reader)inputStreamReader2, (Class)clazz4);
        knowledgeHelperFixer = new KnowledgeHelperFixer();
        functionFixer = new FunctionFixer();
    }

    public RuleBuilder(TypeResolver resolver, ClassFieldExtractorCache cache) {
        this.classFieldExtractorCache = cache;
        this.typeResolver = resolver;
        this.errors = new ArrayList();
    }

    public Map getInvokers() {
        return this.invokers;
    }

    public Map getDescrLookups() {
        return this.descrLookups;
    }

    public String getRuleClass() {
        return this.ruleClass;
    }

    public Map getInvokerLookups() {
        return this.invokerLookups;
    }

    public List getErrors() {
        return this.errors;
    }

    public Rule getRule() {
        if (!this.errors.isEmpty()) {
            this.rule.setSemanticallyValid(false);
        }
        return this.rule;
    }

    public Package getPackage() {
        return this.pkg;
    }

    public synchronized Rule build(Package pkg, RuleDescr ruleDescr) {
        this.pkg = pkg;
        this.methods = new ArrayList();
        this.invokers = new HashMap();
        this.invokerLookups = new HashMap();
        this.declarations = new HashMap();
        this.descrLookups = new HashMap();
        this.columnCounter = new ColumnCounter();
        this.ruleDescr = ruleDescr;
        this.rule = ruleDescr instanceof QueryDescr ? new Query(ruleDescr.getName()) : new Rule(ruleDescr.getName());
        this.setAttributes(this.rule, ruleDescr.getAttributes());
        this.build(ruleDescr);
        return this.rule;
    }

    private void setAttributes(Rule rule, List attributes) {
        Iterator it = attributes.iterator();
        while (it.hasNext()) {
            AttributeDescr attributeDescr = (AttributeDescr)it.next();
            String name = attributeDescr.getName();
            if (name.equals("salience")) {
                rule.setSalience(Integer.parseInt(attributeDescr.getValue()));
                continue;
            }
            if (name.equals("no-loop")) {
                if (attributeDescr.getValue() == null) {
                    rule.setNoLoop(true);
                    continue;
                }
                rule.setNoLoop(Boolean.valueOf(attributeDescr.getValue()).booleanValue());
                continue;
            }
            if (name.equals("auto-focus")) {
                if (attributeDescr.getValue() == null) {
                    rule.setAutoFocus(true);
                    continue;
                }
                rule.setAutoFocus(Boolean.valueOf(attributeDescr.getValue()).booleanValue());
                continue;
            }
            if (name.equals("agenda-group")) {
                rule.setAgendaGroup(attributeDescr.getValue());
                continue;
            }
            if (name.equals("activation-group")) {
                rule.setXorGroup(attributeDescr.getValue());
                continue;
            }
            if (name.equals("duration")) {
                rule.setDuration(Long.parseLong(attributeDescr.getValue()));
                rule.setAgendaGroup("");
                continue;
            }
            name.equals("language");
        }
    }

    private void build(RuleDescr ruleDescr) {
        Iterator it = ruleDescr.getLhs().getDescrs().iterator();
        while (it.hasNext()) {
            Column column;
            Object object = it.next();
            if (object instanceof ConditionalElementDescr) {
                EvalCondition eval;
                Iterator notIt;
                if (object instanceof AndDescr) {
                    And and = new And();
                    this.columnCounter.setParent((GroupElement)and);
                    this.build(this.rule, (ConditionalElementDescr)object, (GroupElement)and, false, false);
                    this.rule.addPattern((ConditionalElement)and);
                    continue;
                }
                if (object instanceof OrDescr) {
                    Or or = new Or();
                    this.columnCounter.setParent((GroupElement)or);
                    this.build(this.rule, (ConditionalElementDescr)object, (GroupElement)or, true, false);
                    this.rule.addPattern((ConditionalElement)or);
                    continue;
                }
                if (object instanceof NotDescr) {
                    this.notDeclarations = new HashMap();
                    Not not = new Not();
                    this.columnCounter.setParent((GroupElement)not);
                    this.build(this.rule, (ConditionalElementDescr)object, (GroupElement)not, true, true);
                    this.rule.addPattern((ConditionalElement)not);
                    notIt = this.notDeclarations.keySet().iterator();
                    while (notIt.hasNext()) {
                        this.declarations.remove(notIt.next());
                    }
                    this.notDeclarations = null;
                    continue;
                }
                if (object instanceof ExistsDescr) {
                    this.notDeclarations = new HashMap();
                    Exists exists = new Exists();
                    this.columnCounter.setParent((GroupElement)exists);
                    this.build(this.rule, (ConditionalElementDescr)object, (GroupElement)exists, true, true);
                    notIt = this.notDeclarations.keySet().iterator();
                    while (notIt.hasNext()) {
                        this.declarations.remove(notIt.next());
                    }
                    this.notDeclarations = null;
                    this.rule.addPattern((ConditionalElement)exists);
                    continue;
                }
                if (!(object instanceof EvalDescr) || (eval = this.build((EvalDescr)object)) == null) continue;
                this.rule.addPattern((ConditionalElement)eval);
                continue;
            }
            if (!(object instanceof ColumnDescr) || (column = this.build((ColumnDescr)object)) == null) continue;
            this.rule.addPattern(column);
        }
        if (!(ruleDescr instanceof QueryDescr)) {
            this.buildConsequence(ruleDescr);
        }
        this.buildRule(ruleDescr);
    }

    private void build(Rule rule, ConditionalElementDescr descr, GroupElement ce, boolean decrementOffset, boolean decrementFirst) {
        Iterator it = descr.getDescrs().iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof ConditionalElementDescr) {
                EvalCondition eval;
                if (object instanceof AndDescr) {
                    And and = new And();
                    this.columnCounter.setParent((GroupElement)and);
                    this.build(rule, (ConditionalElementDescr)object, (GroupElement)and, false, false);
                    ce.addChild((Object)and);
                    continue;
                }
                if (object instanceof OrDescr) {
                    Or or = new Or();
                    this.columnCounter.setParent((GroupElement)or);
                    this.build(rule, (ConditionalElementDescr)object, (GroupElement)or, true, false);
                    ce.addChild((Object)or);
                    continue;
                }
                if (object instanceof NotDescr) {
                    Not not = new Not();
                    this.columnCounter.setParent((GroupElement)not);
                    this.build(rule, (ConditionalElementDescr)object, (GroupElement)not, true, true);
                    ce.addChild((Object)not);
                    continue;
                }
                if (object instanceof ExistsDescr) {
                    Exists exists = new Exists();
                    this.columnCounter.setParent((GroupElement)exists);
                    this.build(rule, (ConditionalElementDescr)object, (GroupElement)exists, true, true);
                    ce.addChild((Object)exists);
                    continue;
                }
                if (!(object instanceof EvalDescr) || (eval = this.build((EvalDescr)object)) == null) continue;
                ce.addChild((Object)eval);
                continue;
            }
            if (!(object instanceof ColumnDescr)) continue;
            if (decrementOffset && decrementFirst) {
                --this.columnOffset;
            } else {
                decrementFirst = true;
            }
            Column column = this.build((ColumnDescr)object);
            if (column == null) continue;
            ce.addChild((Object)column);
        }
    }

    private Column build(ColumnDescr columnDescr) {
        Column column;
        if (columnDescr.getObjectType() == null || columnDescr.getObjectType().equals("")) {
            this.errors.add(new RuleError(this.rule, columnDescr, null, "ObjectType not correctly defined"));
            return null;
        }
        Class clazz = null;
        try {
            clazz = this.typeResolver.resolveType(columnDescr.getObjectType());
        }
        catch (ClassNotFoundException e) {
            this.errors.add(new RuleError(this.rule, columnDescr, null, "Unable to resolve ObjectType '" + columnDescr.getObjectType() + "'"));
            return null;
        }
        if (columnDescr.getIdentifier() != null && !columnDescr.getIdentifier().equals("")) {
            column = new Column(this.columnCounter.getNext(), this.columnOffset, (ObjectType)new ClassObjectType(clazz), columnDescr.getIdentifier());
            this.declarations.put(column.getDeclaration().getIdentifier(), column.getDeclaration());
            if (this.notDeclarations != null) {
                this.notDeclarations.put(column.getDeclaration().getIdentifier(), column.getDeclaration());
            }
        } else {
            column = new Column(this.columnCounter.getNext(), this.columnOffset, (ObjectType)new ClassObjectType(clazz), null);
        }
        Iterator it = columnDescr.getDescrs().iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof FieldBindingDescr) {
                this.build(column, (FieldBindingDescr)object);
                continue;
            }
            if (object instanceof LiteralDescr) {
                this.build(column, (LiteralDescr)object);
                continue;
            }
            if (object instanceof BoundVariableDescr) {
                this.build(column, (BoundVariableDescr)object);
                continue;
            }
            if (object instanceof ReturnValueDescr) {
                this.build(column, (ReturnValueDescr)object);
                continue;
            }
            if (!(object instanceof PredicateDescr)) continue;
            this.build(column, (PredicateDescr)object);
        }
        return column;
    }

    private void build(Column column, FieldBindingDescr fieldBindingDescr) {
        Declaration declaration = (Declaration)this.declarations.get(fieldBindingDescr.getIdentifier());
        if (declaration != null) {
            this.errors.add(new RuleError(this.rule, fieldBindingDescr, null, "Duplicate declaration for variable '" + fieldBindingDescr.getIdentifier() + "' in the rule '" + this.rule.getName() + "'"));
            return;
        }
        Class clazz = ((ClassObjectType)column.getObjectType()).getClassType();
        FieldExtractor extractor = this.getFieldExtractor(fieldBindingDescr, clazz, fieldBindingDescr.getFieldName());
        if (extractor == null) {
            return;
        }
        declaration = column.addDeclaration(fieldBindingDescr.getIdentifier(), (Extractor)extractor);
        this.declarations.put(declaration.getIdentifier(), declaration);
        if (this.notDeclarations != null) {
            this.notDeclarations.put(declaration.getIdentifier(), declaration);
        }
    }

    private void build(Column column, BoundVariableDescr boundVariableDescr) {
        if (boundVariableDescr.getIdentifier() == null || boundVariableDescr.getIdentifier().equals("")) {
            this.errors.add(new RuleError(this.rule, boundVariableDescr, null, "Identifier not defined for binding field '" + boundVariableDescr.getFieldName() + "'"));
            return;
        }
        Class clazz = ((ClassObjectType)column.getObjectType()).getClassType();
        FieldExtractor extractor = this.getFieldExtractor(boundVariableDescr, clazz, boundVariableDescr.getFieldName());
        if (extractor == null) {
            return;
        }
        Declaration declaration = (Declaration)this.declarations.get(boundVariableDescr.getIdentifier());
        if (declaration == null) {
            this.errors.add(new RuleError(this.rule, boundVariableDescr, null, "Unable to return Declaration for identifier '" + boundVariableDescr.getIdentifier() + "'"));
            return;
        }
        Evaluator evaluator = this.getEvaluator(boundVariableDescr, extractor.getObjectType().getValueType(), boundVariableDescr.getEvaluator());
        if (evaluator == null) {
            return;
        }
        column.addConstraint((FieldConstraint)new BoundVariableConstraint(extractor, declaration, evaluator));
    }

    private void build(Column column, LiteralDescr literalDescr) {
        Class clazz = ((ClassObjectType)column.getObjectType()).getClassType();
        FieldExtractor extractor = this.getFieldExtractor(literalDescr, clazz, literalDescr.getFieldName());
        if (extractor == null) {
            return;
        }
        FieldValue field = null;
        if (literalDescr.isStaticFieldValue()) {
            int lastDot = literalDescr.getText().lastIndexOf(46);
            String className = literalDescr.getText().substring(0, lastDot);
            String fieldName = literalDescr.getText().substring(lastDot + 1);
            try {
                Class staticClass = this.typeResolver.resolveType(className);
                field = new FieldImpl(staticClass.getField(fieldName).get(null));
            }
            catch (ClassNotFoundException e) {
                this.errors.add(new RuleError(this.rule, literalDescr, e, e.getMessage()));
            }
            catch (Exception e) {
                this.errors.add(new RuleError(this.rule, literalDescr, e, "Unable to create a Field value of type  '" + extractor.getObjectType().getValueType() + "' and value '" + literalDescr.getText() + "'"));
            }
        } else {
            try {
                field = FieldFactory.getFieldValue((String)literalDescr.getText(), (int)extractor.getObjectType().getValueType());
            }
            catch (Exception e) {
                this.errors.add(new RuleError(this.rule, literalDescr, e, "Unable to create a Field value of type  '" + extractor.getObjectType().getValueType() + "' and value '" + literalDescr.getText() + "'"));
            }
        }
        Evaluator evaluator = this.getEvaluator(literalDescr, extractor.getObjectType().getValueType(), literalDescr.getEvaluator());
        if (evaluator == null) {
            return;
        }
        column.addConstraint((FieldConstraint)new LiteralConstraint(field, extractor, evaluator));
    }

    private void build(Column column, ReturnValueDescr returnValueDescr) {
        String classMethodName = "returnValue" + this.counter++;
        returnValueDescr.setClassMethodName(classMethodName);
        List[] usedIdentifiers = this.getUsedIdentifiers(returnValueDescr, returnValueDescr.getText());
        Declaration[] declarations = new Declaration[usedIdentifiers[0].size()];
        int i = 0;
        int size = usedIdentifiers[0].size();
        while (i < size) {
            declarations[i] = (Declaration)this.declarations.get((String)usedIdentifiers[0].get(i));
            ++i;
        }
        Class clazz = ((ClassObjectType)column.getObjectType()).getClassType();
        FieldExtractor extractor = this.getFieldExtractor(returnValueDescr, clazz, returnValueDescr.getFieldName());
        if (extractor == null) {
            return;
        }
        Evaluator evaluator = this.getEvaluator(returnValueDescr, extractor.getObjectType().getValueType(), returnValueDescr.getEvaluator());
        if (evaluator == null) {
            return;
        }
        ReturnValueConstraint returnValueConstraint = new ReturnValueConstraint(extractor, declarations, evaluator);
        column.addConstraint((FieldConstraint)returnValueConstraint);
        StringTemplate st = ruleGroup.getInstanceOf("returnValueMethod");
        this.setStringTemplateAttributes(st, declarations, usedIdentifiers[1].toArray(new String[usedIdentifiers[1].size()]), returnValueDescr.getText());
        st.setAttribute("methodName", (Object)classMethodName);
        String returnValueText = functionFixer.fix(returnValueDescr.getText());
        st.setAttribute("text", (Object)returnValueText);
        this.methods.add(st.toString());
        st = invokerGroup.getInstanceOf("returnValueInvoker");
        st.setAttribute("package", (Object)this.pkg.getName());
        st.setAttribute("ruleClassName", (Object)this.ucFirst(this.ruleDescr.getClassName()));
        st.setAttribute("invokerClassName", (Object)(String.valueOf(this.ruleDescr.getClassName()) + this.ucFirst(classMethodName) + "Invoker"));
        st.setAttribute("methodName", (Object)classMethodName);
        this.setStringTemplateAttributes(st, declarations, usedIdentifiers[1].toArray(new String[usedIdentifiers[1].size()]), returnValueDescr.getText());
        st.setAttribute("hashCode", returnValueText.hashCode());
        String invokerClassName = String.valueOf(this.pkg.getName()) + "." + this.ruleDescr.getClassName() + this.ucFirst(classMethodName) + "Invoker";
        this.invokers.put(invokerClassName, st.toString());
        this.invokerLookups.put(invokerClassName, returnValueConstraint);
        this.descrLookups.put(invokerClassName, returnValueDescr);
    }

    private void build(Column column, PredicateDescr predicateDescr) {
        String classMethodName = "predicate" + this.counter++;
        predicateDescr.setClassMethodName(classMethodName);
        Class clazz = ((ClassObjectType)column.getObjectType()).getClassType();
        FieldExtractor extractor = this.getFieldExtractor(predicateDescr, clazz, predicateDescr.getFieldName());
        if (extractor == null) {
            return;
        }
        Declaration declaration = column.addDeclaration(predicateDescr.getDeclaration(), (Extractor)extractor);
        this.declarations.put(declaration.getIdentifier(), declaration);
        if (this.notDeclarations != null) {
            this.notDeclarations.put(declaration.getIdentifier(), declaration);
        }
        List[] usedIdentifiers = this.getUsedIdentifiers(predicateDescr, predicateDescr.getText());
        usedIdentifiers[0].remove(predicateDescr.getDeclaration());
        Declaration[] declarations = new Declaration[usedIdentifiers[0].size()];
        int i = 0;
        int size = usedIdentifiers[0].size();
        while (i < size) {
            declarations[i] = (Declaration)this.declarations.get((String)usedIdentifiers[0].get(i));
            ++i;
        }
        PredicateConstraint predicateConstraint = new PredicateConstraint(declaration, declarations);
        column.addConstraint((FieldConstraint)predicateConstraint);
        StringTemplate st = ruleGroup.getInstanceOf("predicateMethod");
        st.setAttribute("declaration", (Object)declaration);
        st.setAttribute("declarationType", (Object)((ClassObjectType)declaration.getObjectType()).getClassType().getName().replace('$', '.'));
        this.setStringTemplateAttributes(st, declarations, usedIdentifiers[1].toArray(new String[usedIdentifiers[1].size()]), predicateDescr.getText());
        st.setAttribute("methodName", (Object)classMethodName);
        String predicateText = functionFixer.fix(predicateDescr.getText());
        st.setAttribute("text", (Object)predicateText);
        this.methods.add(st.toString());
        st = invokerGroup.getInstanceOf("predicateInvoker");
        st.setAttribute("package", (Object)this.pkg.getName());
        st.setAttribute("ruleClassName", (Object)this.ucFirst(this.ruleDescr.getClassName()));
        st.setAttribute("invokerClassName", (Object)(String.valueOf(this.ruleDescr.getClassName()) + this.ucFirst(classMethodName) + "Invoker"));
        st.setAttribute("methodName", (Object)classMethodName);
        st.setAttribute("declaration", (Object)declaration);
        st.setAttribute("declarationType", (Object)((ClassObjectType)declaration.getObjectType()).getClassType().getName().replace('$', '.'));
        this.setStringTemplateAttributes(st, declarations, usedIdentifiers[1].toArray(new String[usedIdentifiers[1].size()]), predicateDescr.getText());
        st.setAttribute("hashCode", predicateText.hashCode());
        String invokerClassName = String.valueOf(this.pkg.getName()) + "." + this.ruleDescr.getClassName() + this.ucFirst(classMethodName) + "Invoker";
        this.invokers.put(invokerClassName, st.toString());
        this.invokerLookups.put(invokerClassName, predicateConstraint);
        this.descrLookups.put(invokerClassName, predicateDescr);
    }

    private EvalCondition build(EvalDescr evalDescr) {
        String classMethodName = "eval" + this.counter++;
        evalDescr.setClassMethodName(classMethodName);
        List[] usedIdentifiers = this.getUsedIdentifiers(evalDescr, evalDescr.getText());
        Declaration[] declarations = new Declaration[usedIdentifiers[0].size()];
        int i = 0;
        int size = usedIdentifiers[0].size();
        while (i < size) {
            declarations[i] = (Declaration)this.declarations.get((String)usedIdentifiers[0].get(i));
            ++i;
        }
        EvalCondition eval = new EvalCondition(declarations);
        StringTemplate st = ruleGroup.getInstanceOf("evalMethod");
        this.setStringTemplateAttributes(st, declarations, usedIdentifiers[1].toArray(new String[usedIdentifiers[1].size()]), evalDescr.getText());
        st.setAttribute("methodName", (Object)classMethodName);
        String evalText = functionFixer.fix(evalDescr.getText());
        st.setAttribute("text", (Object)evalText);
        this.methods.add(st.toString());
        st = invokerGroup.getInstanceOf("evalInvoker");
        st.setAttribute("package", (Object)this.pkg.getName());
        st.setAttribute("ruleClassName", (Object)this.ucFirst(this.ruleDescr.getClassName()));
        st.setAttribute("invokerClassName", (Object)(String.valueOf(this.ruleDescr.getClassName()) + this.ucFirst(classMethodName) + "Invoker"));
        st.setAttribute("methodName", (Object)classMethodName);
        this.setStringTemplateAttributes(st, declarations, usedIdentifiers[1].toArray(new String[usedIdentifiers[1].size()]), evalDescr.getText());
        st.setAttribute("hashCode", evalText.hashCode());
        String invokerClassName = String.valueOf(this.pkg.getName()) + "." + this.ruleDescr.getClassName() + this.ucFirst(classMethodName) + "Invoker";
        this.invokers.put(invokerClassName, st.toString());
        this.invokerLookups.put(invokerClassName, eval);
        this.descrLookups.put(invokerClassName, evalDescr);
        return eval;
    }

    private void buildConsequence(RuleDescr ruleDescr) {
        String classMethodName = "consequence";
        StringTemplate st = ruleGroup.getInstanceOf("consequenceMethod");
        st.setAttribute("methodName", (Object)"consequence");
        List[] usedIdentifiers = this.getUsedCIdentifiers(ruleDescr, ruleDescr.getConsequence());
        Declaration[] declarations = new Declaration[usedIdentifiers[0].size()];
        int i = 0;
        int size = usedIdentifiers[0].size();
        while (i < size) {
            declarations[i] = (Declaration)this.declarations.get((String)usedIdentifiers[0].get(i));
            ++i;
        }
        this.setStringTemplateAttributes(st, declarations, usedIdentifiers[1].toArray(new String[usedIdentifiers[1].size()]), ruleDescr.getConsequence());
        st.setAttribute("text", (Object)functionFixer.fix(knowledgeHelperFixer.fix(ruleDescr.getConsequence())));
        this.methods.add(st.toString());
        st = invokerGroup.getInstanceOf("consequenceInvoker");
        st.setAttribute("package", (Object)this.pkg.getName());
        st.setAttribute("ruleClassName", (Object)this.ucFirst(this.ruleDescr.getClassName()));
        st.setAttribute("invokerClassName", (Object)(String.valueOf(ruleDescr.getClassName()) + this.ucFirst("consequence") + "Invoker"));
        st.setAttribute("methodName", (Object)"consequence");
        this.setStringTemplateAttributes(st, declarations, usedIdentifiers[1].toArray(new String[usedIdentifiers[1].size()]), ruleDescr.getConsequence());
        List<Declaration> list = Arrays.asList(this.rule.getDeclarations());
        int[] indexes = new int[declarations.length];
        int i2 = 0;
        int length = declarations.length;
        while (i2 < length) {
            indexes[i2] = list.indexOf(declarations[i2]);
            ++i2;
        }
        st.setAttribute("indexes", (Object)indexes);
        st.setAttribute("text", (Object)ruleDescr.getConsequence());
        String invokerClassName = String.valueOf(this.pkg.getName()) + "." + ruleDescr.getClassName() + this.ucFirst("consequence") + "Invoker";
        this.invokers.put(invokerClassName, st.toString());
        this.invokerLookups.put(invokerClassName, this.rule);
        this.descrLookups.put(invokerClassName, ruleDescr);
    }

    private void buildRule(RuleDescr ruleDescr) {
        if (this.methods.isEmpty()) {
            this.ruleClass = null;
            return;
        }
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append("package " + this.pkg.getName() + ";" + lineSeparator);
        Iterator it = this.pkg.getImports().iterator();
        while (it.hasNext()) {
            buffer.append("import " + it.next() + ";" + lineSeparator);
        }
        buffer.append("public class " + this.ucFirst(this.ruleDescr.getClassName()) + " {" + lineSeparator);
        buffer.append("    private static final long serialVersionUID  = 7952983928232702826L;" + lineSeparator);
        int i = 0;
        int size = this.methods.size() - 1;
        while (i < size) {
            buffer.append(this.methods.get(i) + lineSeparator);
            ++i;
        }
        String[] lines = buffer.toString().split(lineSeparator);
        this.ruleDescr.setConsequenceOffset(lines.length + 2);
        buffer.append(this.methods.get(this.methods.size() - 1) + lineSeparator);
        buffer.append("}");
        this.ruleClass = buffer.toString();
    }

    private void setStringTemplateAttributes(StringTemplate st, Declaration[] declarations, String[] globals, String text) {
        String[] declarationTypes = new String[declarations.length];
        int i = 0;
        int size = declarations.length;
        while (i < size) {
            declarationTypes[i] = ((ClassObjectType)declarations[i].getObjectType()).getClassType().getName().replace('$', '.');
            ++i;
        }
        ArrayList<String> globalTypes = new ArrayList<String>(globals.length);
        int i2 = 0;
        int length = globals.length;
        while (i2 < length) {
            globalTypes.add(((Class)this.pkg.getGlobals().get(globals[i2])).getName().replace('$', '.'));
            ++i2;
        }
        st.setAttribute("declarations", (Object)declarations);
        st.setAttribute("declarationTypes", (Object)declarationTypes);
        st.setAttribute("globals", (Object)globals);
        st.setAttribute("globalTypes", globalTypes);
    }

    private String ucFirst(String name) {
        return String.valueOf(name.toUpperCase().charAt(0)) + name.substring(1);
    }

    private FieldExtractor getFieldExtractor(PatternDescr descr, Class clazz, String fieldName) {
        ClassFieldExtractor extractor = null;
        try {
            extractor = this.classFieldExtractorCache.getExtractor(clazz, fieldName);
        }
        catch (RuntimeDroolsException e) {
            this.errors.add(new RuleError(this.rule, descr, (Object)e, "Unable to create Field Extractor for '" + fieldName + "'"));
        }
        return extractor;
    }

    private Evaluator getEvaluator(PatternDescr descr, int valueType, String evaluatorString) {
        Evaluator evaluator = EvaluatorFactory.getEvaluator((int)valueType, (String)evaluatorString);
        if (evaluator == null) {
            this.errors.add(new RuleError(this.rule, descr, null, "Unable to determine the Evaluator for  '" + valueType + "' and '" + evaluatorString + "'"));
        }
        return evaluator;
    }

    private List[] getUsedIdentifiers(PatternDescr descr, String text) {
        List[] usedIdentifiers = null;
        try {
            usedIdentifiers = this.analyzer.analyzeExpression(text, new Set[]{this.declarations.keySet(), this.pkg.getGlobals().keySet()});
        }
        catch (Exception e) {
            this.errors.add(new RuleError(this.rule, descr, null, "Unable to determine the used declarations"));
        }
        return usedIdentifiers;
    }

    private List[] getUsedCIdentifiers(PatternDescr descr, String text) {
        List[] usedIdentifiers = null;
        try {
            usedIdentifiers = this.analyzer.analyzeBlock(text, new Set[]{this.declarations.keySet(), this.pkg.getGlobals().keySet()});
        }
        catch (Exception e) {
            this.errors.add(new RuleError(this.rule, descr, null, "Unable to determine the used declarations"));
        }
        return usedIdentifiers;
    }

    static class ColumnCounter {
        private int value = -1;
        private GroupElement ge;

        ColumnCounter() {
        }

        public void setParent(GroupElement ge) {
            this.ge = ge;
        }

        public int getNext() {
            return ++this.value;
        }
    }
}

