/*
 * Decompiled with CFR 0.152.
 */
package org.drools.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.xml.AndHandler;
import org.drools.xml.BoundVariableHandler;
import org.drools.xml.ColumnHandler;
import org.drools.xml.Configuration;
import org.drools.xml.DefaultConfiguration;
import org.drools.xml.EvalHandler;
import org.drools.xml.ExistsHandler;
import org.drools.xml.FieldBindingHandler;
import org.drools.xml.FunctionHandler;
import org.drools.xml.Handler;
import org.drools.xml.LiteralHandler;
import org.drools.xml.NotHandler;
import org.drools.xml.OrHandler;
import org.drools.xml.PackageHandler;
import org.drools.xml.PredicateHandler;
import org.drools.xml.QueryHandler;
import org.drools.xml.ReturnValueHandler;
import org.drools.xml.RuleHandler;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlPackageReader
extends DefaultHandler {
    public static final String ENTITY_RESOLVER_PROPERTY_NAME = "org.drools.io.EntityResolver";
    public static final String RULES_NAMESPACE_URI = "http://drools.org/rules";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private SAXParser parser;
    private boolean isValidating = true;
    private Locator locator;
    private LinkedList configurationStack;
    private StringBuffer characters;
    private Map handlers;
    private boolean lastWasEndElement;
    private LinkedList parents;
    private Object peer;
    private Object current;
    private PackageDescr packageDescr;
    private boolean inHandledRuleSubElement;
    private final MessageFormat message = new MessageFormat("({0}: {1}, {2}): {3}");
    private final Map namespaces = new HashMap();
    EntityResolver entityResolver;
    static /* synthetic */ Class class$0;

    public XmlPackageReader() {
        this.configurationStack = new LinkedList();
        this.parents = new LinkedList();
        this.handlers = new HashMap();
        this.handlers.put("package", new PackageHandler(this));
        this.handlers.put("rule", new RuleHandler(this));
        this.handlers.put("query", new QueryHandler(this));
        this.handlers.put("attribute", null);
        this.handlers.put("function", new FunctionHandler(this));
        this.handlers.put("lhs", new AndHandler(this));
        this.handlers.put("and", new AndHandler(this));
        this.handlers.put("or", new OrHandler(this));
        this.handlers.put("not", new NotHandler(this));
        this.handlers.put("exists", new ExistsHandler(this));
        this.handlers.put("eval", new EvalHandler(this));
        this.handlers.put("column", new ColumnHandler(this));
        this.handlers.put("literal", new LiteralHandler(this));
        this.handlers.put("predicate", new PredicateHandler(this));
        this.handlers.put("return-value", new ReturnValueHandler(this));
        this.handlers.put("field-binding", new FieldBindingHandler(this));
        this.handlers.put("bound-variable", new BoundVariableHandler(this));
        this.initEntityResolver();
    }

    public XmlPackageReader(SAXParser parser) {
        this.parser = parser;
    }

    public PackageDescr read(Reader reader) throws SAXException, IOException {
        return this.read(new InputSource(reader));
    }

    public PackageDescr read(InputStream inputStream) throws SAXException, IOException {
        return this.read(new InputSource(inputStream));
    }

    public PackageDescr read(InputSource in) throws SAXException, IOException {
        SAXParser localParser = null;
        if (this.parser == null) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            String isValidatingString = System.getProperty("drools.schema.validating");
            if (System.getProperty("drools.schema.validating") != null) {
                this.isValidating = Boolean.getBoolean("drools.schema.validating");
            }
            if (this.isValidating) {
                factory.setValidating(true);
                try {
                    localParser = factory.newSAXParser();
                }
                catch (ParserConfigurationException e) {
                    throw new RuntimeException(e.getMessage());
                }
                try {
                    localParser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                }
                catch (SAXNotRecognizedException e) {
                    boolean hideWarnings = Boolean.getBoolean("drools.schema.hidewarnings");
                    if (!hideWarnings) {
                        System.err.println("Your SAX parser is not JAXP 1.2 compliant - turning off validation.");
                    }
                    localParser = null;
                }
            }
            if (localParser == null) {
                try {
                    this.isValidating = false;
                    factory.setValidating(this.isValidating);
                    localParser = factory.newSAXParser();
                }
                catch (ParserConfigurationException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        } else {
            localParser = this.parser;
        }
        if (!localParser.isNamespaceAware()) {
            throw new RuntimeException("parser must be namespace-aware");
        }
        localParser.parse(in, (DefaultHandler)this);
        return this.packageDescr;
    }

    void setPackageDescr(PackageDescr packageDescr) {
        this.packageDescr = packageDescr;
    }

    public PackageDescr getPackageDescr() {
        return this.packageDescr;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void startDocument() {
        this.isValidating = true;
        this.packageDescr = null;
        this.current = null;
        this.peer = null;
        this.lastWasEndElement = false;
        this.parents.clear();
        this.characters = null;
        this.configurationStack.clear();
        this.namespaces.clear();
    }

    public void startElement(String uri, String localName, String qname, Attributes attrs) throws SAXException {
        Handler handler;
        if (!this.lastWasEndElement) {
            this.peer = null;
        }
        if ((handler = this.getHandler(localName)) != null && !this.parents.isEmpty() && this.parents.getLast() instanceof RuleDescr) {
            this.inHandledRuleSubElement = true;
        }
        if (handler == null) {
            this.startConfiguration(localName, attrs);
            return;
        }
        this.validate(uri, localName, handler);
        Object node = handler.start(uri, localName, attrs);
        if (node != null) {
            this.parents.add(node);
            this.current = node;
        }
        this.lastWasEndElement = false;
    }

    public void endElement(String uri, String localName, String qname) throws SAXException {
        Handler handler = this.getHandler(localName);
        if (handler != null && !this.parents.isEmpty() && this.parents.getLast() instanceof RuleDescr) {
            this.inHandledRuleSubElement = false;
        }
        if (handler == null) {
            if (this.configurationStack.size() >= 1) {
                this.endConfiguration();
            }
            return;
        }
        this.current = this.getParent(handler.generateNodeFor());
        Object node = handler.end(uri, localName);
        if (node != null && !this.lastWasEndElement) {
            this.peer = node;
        } else if (this.lastWasEndElement || this.parents.getLast().getClass().isInstance(this.current)) {
            this.peer = this.parents.removeLast();
        }
        this.lastWasEndElement = true;
    }

    private void validate(String uri, String localName, Handler handler) throws SAXParseException {
        boolean validParent = false;
        boolean validPeer = false;
        boolean invalidNesting = false;
        Set validParents = handler.getValidParents();
        Set validPeers = handler.getValidPeers();
        boolean allowNesting = handler.allowNesting();
        Object parent = this.parents.size() != 0 ? this.parents.getLast() : null;
        Class nodeClass = this.getHandler(localName).generateNodeFor();
        if (!nodeClass.isInstance(parent)) {
            Iterator it = validParents.iterator();
            while (!validParent && it.hasNext()) {
                Object allowedParent = it.next();
                if (parent == null && allowedParent == null) {
                    validParent = true;
                    continue;
                }
                if (allowedParent == null || !((Class)allowedParent).isInstance(parent)) continue;
                validParent = true;
            }
            if (!validParent) {
                throw new SAXParseException("<" + localName + "> has an invalid parent element [" + parent + "]", this.getLocator());
            }
        }
        Object peer = this.peer;
        Iterator it = validPeers.iterator();
        while (!validPeer && it.hasNext()) {
            Object allowedPeer = it.next();
            if (peer == null && allowedPeer == null) {
                validPeer = true;
                continue;
            }
            if (allowedPeer == null || !((Class)allowedPeer).isInstance(peer)) continue;
            validPeer = true;
        }
        if (!validPeer) {
            throw new SAXParseException("<" + localName + "> is after an invalid element", this.getLocator());
        }
        if (!allowNesting) {
            it = this.parents.iterator();
            while (!invalidNesting && it.hasNext()) {
                if (!nodeClass.isInstance(it.next())) continue;
                invalidNesting = true;
            }
        }
        if (invalidNesting) {
            throw new SAXParseException("<" + localName + ">  may not be nested", this.getLocator());
        }
    }

    protected void startConfiguration(String name, Attributes attrs) {
        this.characters = new StringBuffer();
        DefaultConfiguration config = new DefaultConfiguration(name);
        int numAttrs = attrs.getLength();
        int i = 0;
        while (i < numAttrs) {
            config.setAttribute(attrs.getLocalName(i), attrs.getValue(i));
            ++i;
        }
        Iterator iter = this.namespaces.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String ns = (String)entry.getKey();
            String value = (String)entry.getValue();
            ns = ns == null || ns.length() == 0 ? "xmlns" : "xmlns:" + ns;
            config.setAttribute(ns, value);
        }
        if (this.configurationStack.isEmpty()) {
            this.configurationStack.addLast(config);
        } else {
            ((DefaultConfiguration)this.configurationStack.getLast()).addChild(config);
            this.configurationStack.addLast(config);
        }
    }

    Handler getHandler(String localName) {
        return (Handler)this.handlers.get(localName);
    }

    public void characters(char[] chars, int start, int len) {
        if (this.characters != null) {
            this.characters.append(chars, start, len);
        }
    }

    protected Configuration endConfiguration() {
        DefaultConfiguration config = (DefaultConfiguration)this.configurationStack.removeLast();
        if (this.characters != null) {
            config.setText(this.characters.toString());
        }
        this.characters = null;
        return config;
    }

    LinkedList getParents() {
        return this.parents;
    }

    Object getParent(Class parent) {
        ListIterator it = this.parents.listIterator(this.parents.size());
        Object node = null;
        while (it.hasPrevious()) {
            node = it.previous();
            if (parent.isInstance(node)) break;
        }
        return node;
    }

    Object getPeer() {
        return this.peer;
    }

    Object getCurrent() {
        return this.current;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        try {
            InputSource inputSource = this.resolveSchema(publicId, systemId);
            if (inputSource != null) {
                return inputSource;
            }
            if (this.entityResolver != null) {
                return this.entityResolver.resolveEntity(publicId, systemId);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
        this.namespaces.put(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        super.endPrefixMapping(prefix);
        this.namespaces.remove(prefix);
    }

    private void print(SAXParseException x) {
        String msg = this.message.format(new Object[]{x.getSystemId(), new Integer(x.getLineNumber()), new Integer(x.getColumnNumber()), x.getMessage()});
        System.out.println(msg);
    }

    public void warning(SAXParseException x) {
        this.print(x);
    }

    public void error(SAXParseException x) {
        this.print(x);
    }

    public void fatalError(SAXParseException x) throws SAXParseException {
        this.print(x);
        throw x;
    }

    private InputSource resolveSchema(String publicId, String systemId) throws SAXException, IOException {
        if (!systemId.toLowerCase().endsWith("xsd")) {
            return null;
        }
        try {
            URL url = new URL(systemId);
            return new InputSource(url.openStream());
        }
        catch (Exception url) {
            InputStream is;
            int index = systemId.lastIndexOf("/");
            if (index == -1) {
                index = systemId.lastIndexOf("\\");
            }
            String xsd = index != -1 ? systemId.substring(index + 1) : systemId;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.drools.xml.XmlPackageReader");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                cl = clazz.getClassLoader();
            }
            if ((is = cl.getResourceAsStream("META-INF/" + xsd)) != null) {
                return new InputSource(is);
            }
            is = cl.getResourceAsStream("/META-INF/" + xsd);
            if (is != null) {
                return new InputSource(is);
            }
            is = cl.getResourceAsStream("/" + xsd);
            if (is != null) {
                return new InputSource(is);
            }
            File file = new File(xsd);
            if (file.exists()) {
                return new InputSource(new BufferedInputStream(new FileInputStream(file)));
            }
            cl = ClassLoader.getSystemClassLoader();
            is = cl.getResourceAsStream("META-INF/" + xsd);
            if (is != null) {
                return new InputSource(is);
            }
            is = cl.getResourceAsStream("/META-INF/" + xsd);
            if (is != null) {
                return new InputSource(is);
            }
            is = cl.getResourceAsStream("/" + xsd);
            if (is != null) {
                return new InputSource(is);
            }
            return null;
        }
    }

    private void initEntityResolver() {
        String entityResolveClazzName = System.getProperty(ENTITY_RESOLVER_PROPERTY_NAME);
        if (entityResolveClazzName != null && entityResolveClazzName.length() > 0) {
            try {
                Class<?> entityResolverClazz = Thread.currentThread().getContextClassLoader().loadClass(entityResolveClazzName);
                this.entityResolver = (EntityResolver)entityResolverClazz.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

