/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.BoundVariableDescr;
import org.drools.lang.descr.ColumnDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.FieldBindingDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.LiteralDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.PackageDescrDumper;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.ReturnValueDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.util.ReflectiveVisitor;

public class DrlDumper
extends ReflectiveVisitor
implements PackageDescrDumper {
    private StringBuffer drlDump;
    private static final String eol = System.getProperty("line.separator");
    private String template;

    public synchronized String dump(PackageDescr packageDescr) {
        this.drlDump = new StringBuffer();
        this.visitPackageDescr(packageDescr);
        return this.drlDump.toString();
    }

    public void visitAndDescr(AndDescr andDescr) {
        this.template = new String();
        this.template = andDescr.getDescrs() != Collections.EMPTY_LIST ? this.processDescrList(andDescr.getDescrs()) : "";
    }

    public void visitAttributeDescr(AttributeDescr attributeDescr) {
        this.template = new String();
        String string = attributeDescr.getName();
        String string2 = null;
        string2 = string.equals("agenda-group") || string.equals("activation-group") ? "\"" + attributeDescr.getValue() + "\"" : attributeDescr.getValue();
        this.template = "\t " + string + " " + string2 + eol;
    }

    public void visitBoundVariableDescr(BoundVariableDescr boundVariableDescr) {
        this.template = new String();
        this.template = boundVariableDescr.getFieldName() + " " + boundVariableDescr.getEvaluator() + " " + boundVariableDescr.getIdentifier();
    }

    public void visitColumnDescr(ColumnDescr columnDescr) {
        this.template = new String();
        this.template = columnDescr.getDescrs() != Collections.EMPTY_LIST ? (columnDescr.getIdentifier() != null ? "\t\t" + columnDescr.getIdentifier() + " : " + columnDescr.getObjectType() + "( " + this.processColoumnConstraintList(columnDescr.getDescrs()) + ")" : "\t\t" + columnDescr.getObjectType() + "( " + this.processColoumnConstraintList(columnDescr.getDescrs()) + ")") : (columnDescr.getIdentifier() != null ? "\t\t" + columnDescr.getIdentifier() + " : " + columnDescr.getObjectType() + "( )" : "\t\t" + columnDescr.getObjectType() + "( )");
    }

    public void visitEvalDescr(EvalDescr evalDescr) {
        this.template = new String();
        this.template = "\t\teval ( " + evalDescr.getText() + " )" + eol;
    }

    public void visitExistsDescr(ExistsDescr existsDescr) {
        this.template = new String();
        this.template = existsDescr.getDescrs() != Collections.EMPTY_LIST ? "\t\texists " + this.processDescrList(existsDescr.getDescrs()) : "";
    }

    public void visitFieldBindingDescr(FieldBindingDescr fieldBindingDescr) {
        this.template = new String();
        this.template = fieldBindingDescr.getIdentifier() + " : ";
    }

    public void visitFunctionDescr(FunctionDescr functionDescr) {
        this.template = new String();
        String string = this.processParameters(functionDescr.getParameterNames(), functionDescr.getParameterTypes());
        this.template = "function " + functionDescr.getReturnType() + " " + functionDescr.getName() + "(" + string + "){" + functionDescr.getText() + eol + "}" + eol;
    }

    public void visitLiteralDescr(LiteralDescr literalDescr) {
        this.template = new String();
        String string = literalDescr.getText();
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            string = "\"" + string + "\"";
        }
        this.template = literalDescr.getFieldName() + " " + literalDescr.getEvaluator() + " " + string;
    }

    public void visitNotDescr(NotDescr notDescr) {
        this.template = new String();
        this.template = notDescr.getDescrs() != Collections.EMPTY_LIST ? "\t   not " + this.processDescrList(notDescr.getDescrs()) : "";
    }

    public void visitOrDescr(OrDescr orDescr) {
        this.template = new String();
        this.template = orDescr.getDescrs() != Collections.EMPTY_LIST ? this.processOrDescrList(orDescr.getDescrs()) : " ";
    }

    public void visitPackageDescr(PackageDescr packageDescr) {
        String string = packageDescr.getName();
        String string2 = "package " + string + ";" + eol + eol;
        this.appendDrlDump(string2);
        if (packageDescr.getImports() != null) {
            this.appendDrlDump(this.processImportsList(packageDescr.getImports()));
        }
        if (packageDescr.getGlobals() != null) {
            this.appendDrlDump(this.processGlobalsMap(packageDescr.getGlobals()));
        }
        if (packageDescr.getFunctions() != null) {
            this.appendDrlDump(this.processFunctionsList(packageDescr.getFunctions()));
        }
        if (packageDescr.getRules() != null) {
            this.appendDrlDump(this.processRules(packageDescr.getRules()));
        }
    }

    public void visitPredicateDescr(PredicateDescr predicateDescr) {
        this.template = new String();
        this.template = predicateDescr.getDeclaration() + ":" + predicateDescr.getFieldName() + " -> ( " + predicateDescr.getText() + " )";
    }

    public void visitReturnValueDescr(ReturnValueDescr returnValueDescr) {
        this.template = new String();
        this.template = returnValueDescr.getFieldName() + " " + returnValueDescr.getEvaluator() + " ( " + returnValueDescr.getText() + ")";
    }

    public void visitQueryDescr(QueryDescr queryDescr) {
        this.template = new String();
        this.template = "<query name=\"" + queryDescr.getName() + "\">" + "<lhs>" + this.processDescrList(queryDescr.getLhs().getDescrs()) + "</lhs>" + "</query>";
    }

    private String processRules(List list) {
        String string = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RuleDescr ruleDescr = (RuleDescr)iterator.next();
            String string2 = "rule \"" + ruleDescr.getName() + "\" " + eol;
            String string3 = this.processAttribute(ruleDescr.getAttributes());
            String string4 = "";
            string4 = ruleDescr.getLhs().getDescrs() != Collections.EMPTY_LIST ? "\t when" + eol + this.processDescrList(ruleDescr.getLhs().getDescrs()) + eol : "\t when";
            String string5 = ruleDescr.getConsequence();
            string5 = string5 == null ? "\t then" + eol + "\t" : "\t then" + eol + "\t\t" + ruleDescr.getConsequence();
            string2 = string2 + string3;
            string2 = string2 + string4;
            string2 = string2 + string5;
            string2 = string2 + "end" + eol;
            string = string + string2;
        }
        return string + eol;
    }

    private String processOrDescrList(List list) {
        String string = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.visit(iterator.next());
            string = string + this.template;
            if (string.endsWith(eol)) {
                string = string.substring(0, string.indexOf(eol));
            }
            string = string + " || ";
        }
        return string.substring(0, string.length() - 4);
    }

    private String processColoumnConstraintList(List list) {
        String string = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.visit(e);
            string = string + this.template;
            if (e instanceof FieldBindingDescr) continue;
            string = string + " , ";
        }
        return string.substring(0, string.length() - 2);
    }

    private String processDescrList(List list) {
        String string = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.visit(iterator.next());
            string = string + this.template;
            string = string + eol;
        }
        return string;
    }

    private String processFunctionsList(List list) {
        String string = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.visit(iterator.next());
            string = string + this.template;
        }
        return string + eol;
    }

    private String processAttribute(List list) {
        String string = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeDescr attributeDescr = (AttributeDescr)iterator.next();
            this.visit(attributeDescr);
            string = string + this.template;
        }
        return string;
    }

    private String processParameters(List list, List list2) {
        String string = "";
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)list2.get(n);
            String string4 = string3 + " " + string2 + ",";
            string = string + string4;
            ++n;
        }
        string = string.substring(0, string.length() - 1);
        return string;
    }

    private String processGlobalsMap(Map map) {
        String string = "";
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)map.get(string2);
            String string4 = "global " + string3 + " " + string2 + ";" + eol;
            string = string + string4;
        }
        return string + eol;
    }

    private String processImportsList(List list) {
        String string = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = "import " + string2 + ";" + eol;
            string = string + string3;
        }
        return string + eol;
    }

    private void appendDrlDump(String string) {
        this.drlDump.append(string);
    }
}

